/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.idea.ApplicationLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLoadHelper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectStoreFactory;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.PathUtil;
import com.intellij.util.TimedReference;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;

public class ProjectImpl
extends ComponentManagerImpl
implements ProjectEx,
ProjectStoreOwner {
    private static final Logger LOG = Logger.getInstance(ProjectImpl.class);
    public static final Key<Long> CREATION_TIME = Key.create("ProjectImpl.CREATION_TIME");
    public static final Key<String> CREATION_TRACE = Key.create("ProjectImpl.CREATION_TRACE");
    public static final String LIGHT_PROJECT_NAME = "light_temp";
    private String myName;
    private final boolean myLight;
    static boolean ourClassesAreLoaded;
    private final String creationTrace;
    private ProjectStoreFactory myProjectStoreFactory;
    private final AtomicReference<Disposable> earlyDisposable;
    private volatile boolean temporarilyDisposed;
    private final AtomicNotNullLazyValue<IComponentStore> myComponentStore;
    static final String TEMPLATE_PROJECT_NAME = "Default (Template) Project";

    protected ProjectImpl(@NotNull Path filePath2, @Nullable String projectName) {
        if (filePath2 == null) {
            ProjectImpl.$$$reportNull$$$0(0);
        }
        super((ComponentManagerImpl)ApplicationManager.getApplication());
        this.earlyDisposable = new AtomicReference<Disposable>(Disposer.newDisposable());
        this.myComponentStore = AtomicNotNullLazyValue.createValue(() -> {
            ProjectStoreFactory factory = this.myProjectStoreFactory != null ? this.myProjectStoreFactory : ServiceManager.getService(ProjectStoreFactory.class);
            return factory.createStore(this);
        });
        this.putUserData(CREATION_TIME, System.nanoTime());
        this.creationTrace = ApplicationManager.getApplication().isUnitTestMode() ? DebugUtil.currentStackTrace() : null;
        this.registerServiceInstance(Project.class, this, ComponentManagerImpl.getFakeCorePluginDescriptor());
        this.myName = projectName;
        this.myLight = ApplicationManager.getApplication().isUnitTestMode() && filePath2.toString().contains(LIGHT_PROJECT_NAME);
    }

    ProjectImpl() {
        super((ComponentManagerImpl)ApplicationManager.getApplication());
        this.earlyDisposable = new AtomicReference<Disposable>(Disposer.newDisposable());
        this.myComponentStore = AtomicNotNullLazyValue.createValue(() -> {
            ProjectStoreFactory factory = this.myProjectStoreFactory != null ? this.myProjectStoreFactory : ServiceManager.getService(ProjectStoreFactory.class);
            return factory.createStore(this);
        });
        this.putUserData(CREATION_TIME, System.nanoTime());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.putUserData(CREATION_TRACE, DebugUtil.currentStackTrace());
        }
        this.creationTrace = ApplicationManager.getApplication().isUnitTestMode() ? DebugUtil.currentStackTrace() : null;
        this.myName = TEMPLATE_PROJECT_NAME;
        this.myLight = false;
    }

    @Override
    public final boolean isDisposed() {
        return super.isDisposed() || this.temporarilyDisposed;
    }

    @Override
    public boolean isLight() {
        return this.myLight;
    }

    void setTemporarilyDisposed(boolean value2) {
        Disposable newDisposable;
        if (this.temporarilyDisposed == value2) {
            return;
        }
        if (value2 && super.isDisposed()) {
            throw new IllegalStateException("Project was already disposed, flag temporarilyDisposed cannot be set to `true`");
        }
        if (!value2 && !this.earlyDisposable.compareAndSet(null, newDisposable = Disposer.newDisposable())) {
            throw new IllegalStateException("earlyDisposable must be null on second opening of light project");
        }
        this.temporarilyDisposed = value2;
    }

    boolean isTemporarilyDisposed() {
        return this.temporarilyDisposed;
    }

    @ApiStatus.Internal
    public void setProjectStoreFactory(ProjectStoreFactory projectStoreFactory) {
        this.myProjectStoreFactory = projectStoreFactory;
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            ProjectImpl.$$$reportNull$$$0(1);
        }
        if (projectName.equals(this.myName)) {
            return;
        }
        this.myName = projectName;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance(this).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
                JFrame frame = WindowManager.getInstance().getFrame(this);
                String title = FrameTitleBuilder.getInstance().getProjectTitle(this);
                if (frame != null && title != null) {
                    frame.setTitle(title);
                }
            }, ModalityState.NON_MODAL, this.getDisposed()));
        }
    }

    @NotNull
    public final IProjectStore getStateStore() {
        IProjectStore iProjectStore = (IProjectStore)this.getComponentStore();
        if (iProjectStore == null) {
            ProjectImpl.$$$reportNull$$$0(2);
        }
        return iProjectStore;
    }

    @Override
    @NotNull
    public IComponentStore getComponentStore() {
        IComponentStore iComponentStore = this.myComponentStore.getValue();
        if (iComponentStore == null) {
            ProjectImpl.$$$reportNull$$$0(3);
        }
        return iComponentStore;
    }

    @Override
    public boolean isOpen() {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
        return projectManager != null && projectManager.isProjectOpened(this);
    }

    @Override
    public boolean isInitialized() {
        return this.getComponentCreated() && !this.isDisposed() && this.isOpen() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ProjectImpl.$$$reportNull$$$0(4);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.getProject();
        if (containerDescriptor == null) {
            ProjectImpl.$$$reportNull$$$0(5);
        }
        return containerDescriptor;
    }

    @Override
    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return this.getStateStore().getProjectFilePath();
    }

    @Override
    public VirtualFile getProjectFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectFilePath());
    }

    @Override
    public VirtualFile getBaseDir() {
        return LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectBasePath());
    }

    @Override
    @Nullable
    public @SystemIndependent String getBasePath() {
        return this.getStateStore().getProjectBasePath();
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            String string = this.getStateStore().getProjectName();
            if (string == null) {
                ProjectImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public @SystemDependent String getPresentableUrl() {
        IProjectStore store = this.getStateStore();
        return PathUtil.toSystemDependentName(store.getStorageScheme() == StorageScheme.DIRECTORY_BASED ? store.getProjectBasePath() : store.getProjectFilePath());
    }

    @Override
    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String prefix = this.getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED ? "" : this.getName();
        String string = prefix + Integer.toHexString(str.hashCode());
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getWorkspaceFile() {
        String workspaceFilePath = this.getStateStore().getWorkspaceFilePath();
        return workspaceFilePath == null ? null : LocalFileSystem.getInstance().findFileByPath(workspaceFilePath);
    }

    public void init(@Nullable ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        List<? extends IdeaPluginDescriptor> plugins2 = PluginManagerCore.getLoadedPlugins();
        CompletableFuture<Void> servicePreloadingFuture = ApplicationLoader.preloadServices(plugins2, this, "project ", this.isLight());
        this.createComponents(indicator);
        servicePreloadingFuture.join();
        if (indicator != null && !application.isHeadlessEnvironment()) {
            this.distributeProgress(indicator);
        }
        if (this.myName == null) {
            this.myName = this.getStateStore().getProjectName();
        }
        ProjectLoadHelper.notifyThatComponentCreated(this);
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(9);
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded() / (double)(ourClassesAreLoaded ? 10 : 2));
    }

    private void distributeProgress(@NotNull ProgressIndicator indicator) {
        ModuleManager moduleManager;
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(10);
        }
        if (!((moduleManager = ModuleManager.getInstance(this)) instanceof ModuleManagerImpl)) {
            return;
        }
        double toDistribute = 1.0 - indicator.getFraction();
        int modulesCount = ((ModuleManagerImpl)moduleManager).getModulePathsCount();
        if (modulesCount != 0) {
            ((ModuleManagerImpl)moduleManager).setProgressStep(toDistribute / (double)modulesCount);
        }
    }

    @Override
    public void save() {
        if (!ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            return;
        }
        if (!this.isInitialized()) {
            LOG.debug("Skip save for " + this.getName() + ": not initialized");
            return;
        }
        StoreUtil.saveSettings(this, false);
    }

    @Override
    public synchronized void dispose() {
        Application app = ApplicationManager.getApplication();
        app.assertWriteAccessAllowed();
        ProjectManagerImpl projectManager = (ProjectManagerImpl)ProjectManager.getInstance();
        if (projectManager.isProjectOpened(this)) {
            throw new IllegalStateException("Must call .dispose() for a closed project only. See ProjectManager.closeProject() or ProjectUtil.closeAndDispose().");
        }
        super.dispose();
        if (this.myComponentStore.isComputed()) {
            this.myComponentStore.getValue().release();
        }
        if (!app.isDisposed()) {
            app.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC).afterProjectClosed(this);
        }
        projectManager.updateTheOnlyProjectField();
        TimedReference.disposeTimed();
        LaterInvocator.purgeExpiredItems();
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @NonNls
    public String toString() {
        return "Project (name=" + this.myName + ", containerState=" + this.getContainerStateName() + ", componentStore=" + (this.myComponentStore.isComputed() ? this.getPresentableUrl() : "<not initialized>") + ") " + (this.temporarilyDisposed ? " (disposed temporarily)" : "");
    }

    public String getCreationTrace() {
        return this.creationTrace;
    }

    @Nullable
    @ApiStatus.Internal
    public String activityNamePrefix() {
        return "project ";
    }

    @Override
    @NotNull
    @ApiStatus.Experimental
    @ApiStatus.Internal
    public final Disposable getEarlyDisposable() {
        if (this.isDisposed()) {
            throw new IllegalStateException(this + " is disposed already");
        }
        Disposable disposable2 = this.earlyDisposable.get();
        if (disposable2 == null) {
            ProjectImpl.$$$reportNull$$$0(11);
        }
        return disposable2;
    }

    @ApiStatus.Internal
    public final void disposeEarlyDisposable() {
        Disposable earlyDisposable = this.earlyDisposable.getAndSet(null);
        Disposer.dispose(earlyDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEarlyDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProjectName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "distributeProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

