/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkFinder;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SimpleJavaSdkType
extends SdkType
implements JavaSdkType {
    private static final Condition<SdkTypeId> TRUE = sdkTypeId -> true;
    private static final Condition<SdkTypeId> NOT_SIMPLE_JAVA_TYPE = sdkTypeId -> !(sdkTypeId instanceof SimpleJavaSdkType);
    private static final Condition<SdkTypeId> NOT_DEPENDENT_TYPE = sdkTypeId -> sdkTypeId instanceof SdkType && ((SdkType)sdkTypeId).getDependencyType() == null;

    public static SimpleJavaSdkType getInstance() {
        return SdkType.findInstance(SimpleJavaSdkType.class);
    }

    public SimpleJavaSdkType() {
        super("SimpleJavaSdkType");
    }

    public Sdk createJdk(@NotNull String jdkName, @NotNull String home) {
        if (jdkName == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(0);
        }
        if (home == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(1);
        }
        Sdk jdk = ProjectJdkTable.getInstance().createSdk(jdkName, this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName(home));
        sdkModificator.commitChanges();
        return jdk;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message("sdk.java.name", new Object[0]);
        if (string == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(3);
        }
        if (sdkModificator == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData2, @NotNull Element additional) {
        if (additionalData2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(5);
        }
        if (additional == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(6);
        }
    }

    @Override
    public String getBinPath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(7);
        }
        return new File(sdk2.getHomePath(), "bin").getPath();
    }

    @Override
    public String getToolsPath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(8);
        }
        return new File(sdk2.getHomePath(), "lib/tools.jar").getPath();
    }

    @Override
    public String getVMExecutablePath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(9);
        }
        return new File(sdk2.getHomePath(), "bin/java").getPath();
    }

    @Override
    @Nullable
    public String suggestHomePath() {
        return JdkFinder.getInstance().defaultJavaLocation();
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths() {
        if (!SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists().value(this)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                SimpleJavaSdkType.$$$reportNull$$$0(10);
            }
            return list2;
        }
        List<String> list3 = JdkFinder.getInstance().suggestHomePaths();
        if (list3 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(11);
        }
        return list3;
    }

    @Override
    public boolean isValidSdkHome(String path2) {
        return JdkUtil.checkForJdk(path2);
    }

    @Override
    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String suggestedName = JdkUtil.suggestJdkName(this.getVersionString(sdkHome));
        return suggestedName != null ? suggestedName : (currentSdkName != null ? currentSdkName : "");
    }

    @Override
    public final String getVersionString(String sdkHome) {
        JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo(sdkHome);
        return jdkInfo != null ? JdkVersionDetector.formatVersionString(jdkInfo.version) : null;
    }

    @Override
    @NotNull
    public Comparator<String> versionStringComparator() {
        Comparator comparator2 = (sdk1, sdk2) -> Comparing.compare(JavaVersion.tryParse(sdk1), JavaVersion.tryParse(sdk2));
        if (comparator2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(12);
        }
        return comparator2;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType() {
        Condition<SdkTypeId> condition2 = NOT_SIMPLE_JAVA_TYPE;
        if (condition2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(13);
        }
        return condition2;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkType(@Nullable Condition<? super SdkTypeId> condition2) {
        if (condition2 == null) {
            Condition<SdkTypeId> condition3 = NOT_SIMPLE_JAVA_TYPE;
            if (condition3 == null) {
                SimpleJavaSdkType.$$$reportNull$$$0(14);
            }
            return condition3;
        }
        Condition<SdkTypeId> condition4 = sdkTypeId -> NOT_SIMPLE_JAVA_TYPE.value((SdkTypeId)sdkTypeId) && condition2.value((SdkTypeId)sdkTypeId);
        if (condition4 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(15);
        }
        return condition4;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkTypeIfAlternativeExists() {
        boolean hasNotSimple = Stream.of(SdkType.getAllTypes()).filter(SimpleJavaSdkType.notSimpleJavaSdkType()::value).anyMatch(it -> it instanceof JavaSdkType && it.getDependencyType() == null && !((JavaSdkType)((Object)it)).isDependent());
        if (hasNotSimple) {
            Condition<SdkTypeId> condition2 = NOT_SIMPLE_JAVA_TYPE;
            if (condition2 == null) {
                SimpleJavaSdkType.$$$reportNull$$$0(16);
            }
            return condition2;
        }
        Condition<SdkTypeId> condition3 = TRUE;
        if (condition3 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(17);
        }
        return condition3;
    }

    @NotNull
    public static Condition<SdkTypeId> notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType() {
        Condition<SdkTypeId> preferablyNotSimple = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists();
        Condition<SdkTypeId> condition2 = sdkType -> sdkType instanceof JavaSdkType && NOT_DEPENDENT_TYPE.value((SdkTypeId)sdkType) && preferablyNotSimple.value((SdkTypeId)sdkType);
        if (condition2 == null) {
            SimpleJavaSdkType.$$$reportNull$$$0(18);
        }
        return condition2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SimpleJavaSdkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SimpleJavaSdkType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "versionStringComparator";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkTypeIfAlternativeExists";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

