/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHomeFinderBasic {
    private final Logger LOG = Logger.getInstance(this.getClass());
    private final List<Supplier<Set<String>>> myFinders = new ArrayList<Supplier<Set<String>>>();

    JavaHomeFinderBasic(boolean forceEmbeddedJava, String ... paths) {
        this.myFinders.add(this::checkDefaultLocations);
        this.myFinders.add(this::findInPATH);
        this.myFinders.add(() -> this.findInSpecifiedPaths(paths));
        this.myFinders.add(this::findJavaInstalledBySdkMan);
        if (forceEmbeddedJava || Registry.is("java.detector.include.embedded", false)) {
            this.myFinders.add(() -> this.scanAll(JavaHomeFinderBasic.getJavaHome(), false));
        }
    }

    @NotNull
    private Set<String> findInSpecifiedPaths(String[] paths) {
        Set<String> set = this.scanAll(Stream.of(paths).map(it -> new File((String)it)).collect(Collectors.toList()), true);
        if (set == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(0);
        }
        return set;
    }

    protected void registerFinder(@NotNull Supplier<Set<String>> finder) {
        if (finder == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(1);
        }
        this.myFinders.add(finder);
    }

    @NotNull
    public final Set<String> findExistingJdks() {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Supplier<Set<String>> action2 : this.myFinders) {
            try {
                result2.addAll((Collection<String>)action2.get());
            }
            catch (Exception e) {
                this.LOG.warn("Failed to find Java Home. " + e.getMessage(), e);
            }
        }
        TreeSet<String> treeSet = result2;
        if (treeSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(2);
        }
        return treeSet;
    }

    @NotNull
    private Set<String> findInPATH() {
        Set<String> set;
        String pathVarString;
        block7: {
            pathVarString = EnvironmentUtil.getValue("PATH");
            if (pathVarString != null && !pathVarString.isEmpty()) break block7;
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(3);
            }
            return set2;
        }
        try {
            HashSet<File> dirsToCheck = new HashSet<File>();
            for (String p : pathVarString.split(File.pathSeparator)) {
                File parentFile;
                File dir = new File(p);
                if (!StringUtilRt.equal(dir.getName(), "bin", SystemInfo.isFileSystemCaseSensitive) || (parentFile = dir.getParentFile()) == null) continue;
                dirsToCheck.addAll(this.listPossibleJdkInstallRootsFromHomes(parentFile));
            }
            set = this.scanAll(dirsToCheck, false);
        }
        catch (Exception e) {
            this.LOG.warn("Failed to scan PATH for JDKs. " + e.getMessage(), e);
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(5);
            }
            return set3;
        }
        if (set == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private Set<String> checkDefaultLocations() {
        if (ApplicationManager.getApplication() == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(6);
            }
            return set;
        }
        HashSet<File> paths = new HashSet<File>();
        paths.add(JdkInstaller.getInstance().defaultInstallDir());
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            String homePath;
            if (!(jdk.getSdkType() instanceof JavaSdkType) || jdk.getSdkType() instanceof DependentSdkType || (homePath = jdk.getHomePath()) == null) continue;
            paths.addAll(this.listPossibleJdkInstallRootsFromHomes(new File(homePath)));
        }
        Set<String> set = this.scanAll(paths, true);
        if (set == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    protected Set<String> scanAll(@Nullable File file2, boolean includeNestDirs) {
        if (file2 == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<String> set = this.scanAll(Collections.singleton(file2), includeNestDirs);
        if (set == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    protected Set<String> scanAll(@NotNull Collection<File> files2, boolean includeNestDirs) {
        if (files2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(10);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (File root : new HashSet<File>(files2)) {
            this.scanFolder(root, includeNestDirs, result2);
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private void scanFolder(@NotNull File folder, boolean includeNestDirs, @NotNull Collection<? super String> result2) {
        if (folder == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(13);
        }
        if (JdkUtil.checkForJdk(folder)) {
            result2.add(folder.getAbsolutePath());
            return;
        }
        if (!includeNestDirs) {
            return;
        }
        File[] files2 = folder.listFiles();
        if (files2 == null) {
            return;
        }
        for (File candidate : files2) {
            for (File adjusted : this.listPossibleJdkHomesFromInstallRoot(candidate)) {
                this.scanFolder(adjusted, false, result2);
            }
        }
    }

    @NotNull
    protected List<File> listPossibleJdkHomesFromInstallRoot(@NotNull File file2) {
        if (file2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(14);
        }
        List<File> list2 = Collections.singletonList(file2);
        if (list2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    protected List<File> listPossibleJdkInstallRootsFromHomes(@NotNull File file2) {
        if (file2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(16);
        }
        List<File> list2 = Collections.singletonList(file2);
        if (list2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Nullable
    protected static File getJavaHome() {
        String property = SystemProperties.getJavaHome();
        if (property == null) {
            return null;
        }
        File javaHome = new File(property).getParentFile();
        return javaHome == null || !javaHome.isDirectory() ? null : javaHome;
    }

    @NotNull
    private Set<String> findJavaInstalledBySdkMan() {
        File candidatesDir = JavaHomeFinderBasic.findSdkManCandidatesDir();
        if (candidatesDir == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(18);
            }
            return set;
        }
        File javasDir = new File(candidatesDir, "java");
        if (javasDir.isDirectory()) {
            Set<String> set = this.scanAll(javasDir, true);
            if (set == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(19);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(20);
        }
        return set;
    }

    @Nullable
    private static File findSdkManCandidatesDir() {
        File homeDir;
        File primaryDir;
        File candidatesDir;
        String homePath;
        File candidatesDir2;
        File primaryDir2;
        File candidatesDir3;
        String candidatesPath = EnvironmentUtil.getValue("SDKMAN_CANDIDATES_DIR");
        if (candidatesPath != null && (candidatesDir3 = new File(candidatesPath)).isDirectory()) {
            return candidatesDir3;
        }
        String primaryPath = EnvironmentUtil.getValue("SDKMAN_DIR");
        if (primaryPath != null && (primaryDir2 = new File(primaryPath)).isDirectory() && (candidatesDir2 = new File(primaryDir2, "candidates")).isDirectory()) {
            return candidatesDir2;
        }
        if (!SystemInfo.isWindows && (homePath = System.getProperty("user.home")) != null && (candidatesDir = new File(primaryDir = new File(homeDir = new File(homePath), ".sdkman"), "candidates")).isDirectory()) {
            return candidatesDir;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findInSpecifiedPaths";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findExistingJdks";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInPATH";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDefaultLocations";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "scanAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledBySdkMan";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFinder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scanAll";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanFolder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

