/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAuto;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHint;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHintService;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHints;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirements;
import com.intellij.openapi.roots.ui.configuration.SdkDetector;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderBase;", "()V", "createResolver", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver$UnknownSdkLookup;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createResolverImpl", "supportsResolution", "", "sdkTypeId", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "JavaLocalSdkFix", "intellij.platform.lang.impl"})
public final class JdkAuto
implements UnknownSdkResolver,
JdkDownloaderBase {
    @Override
    public boolean supportsResolution(@NotNull SdkTypeId sdkTypeId) {
        Intrinsics.checkParameterIsNotNull((Object)sdkTypeId, (String)"sdkTypeId");
        return SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType().value(sdkTypeId);
    }

    @Override
    @Nullable
    public UnknownSdkResolver.UnknownSdkLookup createResolver(@Nullable Project project2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        if (!Registry.is("jdk.auto.setup")) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return null;
        }
        return this.createResolverImpl(project2, indicator);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UnknownSdkResolver.UnknownSdkLookup createResolverImpl(@Nullable Project project2, @NotNull ProgressIndicator indicator) {
        Object v1;
        block3: {
            void $this$singleOrNull$iv;
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            SdkType[] sdkTypeArray = SdkType.getAllTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkTypeArray, (String)"SdkType.getAllTypes()");
            SdkType[] sdkTypeArray2 = sdkTypeArray;
            Condition<SdkTypeId> condition2 = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                SdkTypeId p1 = (SdkTypeId)element$iv;
                boolean bl = false;
                if (!condition2.value(p1)) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        if (v1 == null) {
            return null;
        }
        Object sdkType = v1;
        return new UnknownSdkResolver.UnknownSdkLookup(this, sdkType, project2, indicator){
            @NotNull
            private final Lazy lazyDownloadModel$delegate;
            @NotNull
            private final Lazy lazyLocalJdks$delegate;
            final /* synthetic */ JdkAuto this$0;
            final /* synthetic */ SdkType $sdkType;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;

            @NotNull
            public final List<JdkItem> getLazyDownloadModel() {
                Lazy lazy = this.lazyDownloadModel$delegate;
                createResolverImpl.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (List)lazy.getValue();
            }

            private final JdkAutoHint resolveHint(UnknownSdk sdk2) {
                Object v1;
                block5: {
                    if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType) ^ true) {
                        return null;
                    }
                    if (this.$project == null) {
                        return null;
                    }
                    String string = sdk2.getSdkName();
                    if (string == null) {
                        return null;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdk.sdkName ?: return null");
                    String sdkName = string;
                    Iterable $this$singleOrNull$iv = ((JdkAutoHints)JdkAutoHintService.Companion.getInstance(this.$project).getState()).getJdks();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        JdkAutoHint it = (JdkAutoHint)element$iv;
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getName(), (String)sdkName, (boolean)true)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                return v1;
            }

            private final JdkRequirement parseSdkRequirement(UnknownSdk sdk2) {
                Object object;
                block6: {
                    block5: {
                        JdkAutoHint hint = this.resolveHint(sdk2);
                        object = hint;
                        if (object == null || (object = ((JdkAutoHint)object).getVersion()) == null) break block5;
                        Object object2 = object;
                        boolean bl = false;
                        Object object3 = object2;
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
                        if (object == null) break block5;
                        object2 = object;
                        bl = false;
                        Object object4 = object2;
                        if (object4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)object4).toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                        object = string;
                        if (string != null && (object = StringKt.nullize((String)object, true)) != null) break block6;
                    }
                    object = sdk2.getSdkName();
                }
                Object namePredicate = object;
                return JdkRequirements.INSTANCE.parseRequirement((String)namePredicate, sdk2.getSdkVersionStringPredicate(), sdk2.getSdkHomePredicate());
            }

            private final UnknownSdkLocalSdkFix resolveHintPath(UnknownSdk sdk2, ProgressIndicator indicator) {
                Object object;
                JdkAutoHint hint = this.resolveHint(sdk2);
                Object object2 = hint;
                if (object2 == null || (object2 = ((JdkAutoHint)object2).getPath()) == null) {
                    return null;
                }
                Object path2 = object2;
                indicator.setText(ProjectBundle.message("progress.text.resolving.hint.path", path2));
                if (!new File((String)path2).isDirectory()) {
                    return null;
                }
                createResolverImpl.1 var6_5 = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    createResolverImpl.1 $this$runCatching = var6_5;
                    boolean bl2 = false;
                    String string = this.$sdkType.getVersionString(hint.getPath());
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)string);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                var6_5 = object;
                bl = false;
                String string = (String)((Object)(Result.isFailure-impl((Object)var6_5) ? null : var6_5));
                if (string == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"runCatching {\n          \u2026etOrNull() ?: return null");
                String version2 = string;
                return new UnknownSdkLocalSdkFix(this, (String)path2, version2, hint){
                    final /* synthetic */ createResolverImpl.1 this$0;
                    final /* synthetic */ String $path;
                    final /* synthetic */ String $version;
                    final /* synthetic */ JdkAutoHint $hint;

                    @NotNull
                    public String getExistingSdkHome() {
                        return this.$path;
                    }

                    @NotNull
                    public String getVersionString() {
                        return this.$version;
                    }

                    @NotNull
                    public String getSuggestedSdkName() {
                        String string = this.this$0.$sdkType.suggestSdkName(null, this.$hint.getPath());
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdkType.suggestSdkName(null, hint.path)");
                        return string;
                    }

                    @NotNull
                    public String toString() {
                        return "resolved to hint " + this.$version + ", " + this.$path;
                    }
                    {
                        this.this$0 = $outer;
                        this.$path = $captured_local_variable$1;
                        this.$version = $captured_local_variable$2;
                        this.$hint = $captured_local_variable$3;
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public UnknownSdkDownloadableSdkFix proposeDownload(@NotNull UnknownSdk sdk2, @NotNull ProgressIndicator indicator) {
                Object object;
                Object v4;
                void $this$mapNotNullTo$iv$iv;
                Object it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)sdk2, (String)"sdk");
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType) ^ true) {
                    return null;
                }
                JdkRequirement jdkRequirement = this.parseSdkRequirement(sdk2);
                if (jdkRequirement == null) {
                    return null;
                }
                JdkRequirement req = jdkRequirement;
                Logger logger = JdkAutoKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("Looking for a possible download for ");
                SdkType sdkType = sdk2.getSdkType();
                Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"sdk.sdkType");
                logger.info(stringBuilder.append(sdkType.getPresentableName()).append(" with name ").append(sdk2).toString());
                Iterable $this$filter$iv = this.getLazyDownloadModel();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (JdkItem)element$iv$iv;
                    boolean bl = false;
                    if (!req.matches((JdkItem)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    Pair pair;
                    E element$iv$iv$iv;
                    E element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    JdkItem it2 = (JdkItem)element$iv$iv;
                    boolean bl2 = false;
                    JavaVersion v = JavaVersion.tryParse(it2.getVersionString());
                    if ((v != null ? TuplesKt.to((Object)it2, (Object)v) : null) == null) continue;
                    pair = pair;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Pair it$iv$iv = pair;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$maxBy$iv = (List)destination$iv$iv;
                boolean $i$f$maxBy = false;
                Iterator<T> iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v4 = null;
                } else {
                    T maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v4 = maxElem$iv;
                    } else {
                        Pair it3 = (Pair)maxElem$iv;
                        boolean bl = false;
                        Comparable maxValue$iv = (JavaVersion)it3.getSecond();
                        do {
                            T e$iv = iterator$iv.next();
                            Pair it4 = (Pair)e$iv;
                            $i$a$-maxBy-JdkAuto$createResolverImpl$1$proposeDownload$jdkToDownload$3 = false;
                            Comparable v$iv = (JavaVersion)it4.getSecond();
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v4 = maxElem$iv;
                    }
                }
                if ((object = (Pair)v4) == null || (object = (JdkItem)object.getFirst()) == null) {
                    return null;
                }
                Object jdkToDownload = object;
                return new UnknownSdkDownloadableSdkFix(this, (JdkItem)jdkToDownload){
                    final /* synthetic */ createResolverImpl.1 this$0;
                    final /* synthetic */ JdkItem $jdkToDownload;

                    @NotNull
                    public String getVersionString() {
                        return this.$jdkToDownload.getVersionString();
                    }

                    @NotNull
                    public String getDownloadDescription() {
                        return this.$jdkToDownload.getFullPresentationText();
                    }

                    @NotNull
                    public SdkDownloadTask createTask(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
                        File homeDir = jdkInstaller.defaultInstallDir(this.$jdkToDownload);
                        JdkInstallRequest request2 = jdkInstaller.prepareJdkInstallation(this.$jdkToDownload, homeDir);
                        return this.this$0.this$0.newDownloadTask(request2, this.this$0.$project);
                    }
                    {
                        this.this$0 = $outer;
                        this.$jdkToDownload = $captured_local_variable$1;
                    }
                };
            }

            @NotNull
            public final List<JavaLocalSdkFix> getLazyLocalJdks() {
                Lazy lazy = this.lazyLocalJdks$delegate;
                createResolverImpl.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (List)lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public UnknownSdkLocalSdkFix proposeLocalFix(@NotNull UnknownSdk sdk2, @NotNull ProgressIndicator indicator) {
                UnknownSdkLocalSdkFix unknownSdkLocalSdkFix;
                Intrinsics.checkParameterIsNotNull((Object)sdk2, (String)"sdk");
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType) ^ true) {
                    return null;
                }
                UnknownSdkLocalSdkFix hintMatch = this.resolveHintPath(sdk2, indicator);
                if (hintMatch != null) {
                    return hintMatch;
                }
                JdkRequirement jdkRequirement = this.parseSdkRequirement(sdk2);
                if (jdkRequirement == null) {
                    return null;
                }
                JdkRequirement req = jdkRequirement;
                Logger logger = JdkAutoKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("Looking for a local SDK for ");
                SdkType sdkType = sdk2.getSdkType();
                Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"sdk.sdkType");
                logger.info(stringBuilder.append(sdkType.getPresentableName()).append(" with name ").append(sdk2).toString());
                createResolverImpl.proposeLocalFix.1 $fun$pickBestMatch$1 = createResolverImpl.proposeLocalFix.1.INSTANCE;
                SdkType sdkType2 = sdk2.getSdkType();
                Intrinsics.checkExpressionValueIsNotNull((Object)sdkType2, (String)"sdk.sdkType");
                JavaLocalSdkFix javaLocalSdkFix = $fun$pickBestMatch$1.invoke(this.tryUsingExistingSdk(req, sdkType2, indicator));
                if (javaLocalSdkFix != null) {
                    unknownSdkLocalSdkFix = javaLocalSdkFix;
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = this.getLazyLocalJdks();
                    createResolverImpl.proposeLocalFix.1 var15_7 = $fun$pickBestMatch$1;
                    boolean $i$f$filter = false;
                    void var8_9 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        JavaLocalSdkFix it = (JavaLocalSdkFix)element$iv$iv;
                        boolean bl = false;
                        if (!req.matches(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    unknownSdkLocalSdkFix = var15_7.invoke(list2);
                }
                return unknownSdkLocalSdkFix;
            }

            private final List<JavaLocalSdkFix> tryUsingExistingSdk(JdkRequirement req, SdkType sdkType, ProgressIndicator indicator) {
                indicator.setText(ProjectBundle.message("progress.text.checking.existing.jdks", new Object[0]));
                boolean bl = false;
                List result2 = new ArrayList<E>();
                boolean $i$f$runReadAction = false;
                Sdk[] sdkArray = (Sdk[])ApplicationManager.getApplication().runReadAction(new Computable<T>(){

                    public final T compute() {
                        boolean bl = false;
                        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
                        return (T)projectJdkTable.getAllJdks();
                    }
                });
                int n = sdkArray.length;
                for (int i = 0; i < n; ++i) {
                    String suggestedName;
                    boolean bl2;
                    Object $this$runCatching5;
                    JavaVersion version2;
                    Object object;
                    String versionString;
                    Object object2;
                    String homeDir;
                    Object object3;
                    Object object4;
                    Sdk it;
                    Sdk sdk2 = it = sdkArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)sdk2, (String)"it");
                    if (Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)sdkType) ^ true) continue;
                    createResolverImpl.1 var10_11 = this;
                    boolean bl3 = false;
                    try {
                        object4 = Result.Companion;
                        createResolverImpl.1 $this$runCatching2 = var10_11;
                        boolean bl4 = false;
                        object3 = it.getHomePath();
                        bl4 = false;
                        object4 = Result.constructor-impl((Object)object3);
                    }
                    catch (Throwable throwable) {
                        Result.Companion bl4 = Result.Companion;
                        boolean bl5 = false;
                        object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    var10_11 = object4;
                    bl3 = false;
                    if ((String)((Object)(Result.isFailure-impl((Object)var10_11) ? null : var10_11)) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)homeDir, (String)"runCatching { it.homePat\u2026}.getOrNull() ?: continue");
                    Object object5 = this;
                    boolean bl6 = false;
                    try {
                        object3 = Result.Companion;
                        createResolverImpl.1 $this$runCatching3 = object5;
                        boolean bl7 = false;
                        object2 = it.getVersionString();
                        bl7 = false;
                        object3 = Result.constructor-impl((Object)object2);
                    }
                    catch (Throwable throwable) {
                        Result.Companion bl7 = Result.Companion;
                        boolean bl8 = false;
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object5 = object3;
                    bl6 = false;
                    if ((String)(Result.isFailure-impl((Object)object5) ? null : object5) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)versionString, (String)"runCatching { it.version\u2026}.getOrNull() ?: continue");
                    Object object6 = this;
                    boolean bl9 = false;
                    try {
                        object2 = Result.Companion;
                        createResolverImpl.1 $this$runCatching4 = object6;
                        boolean bl10 = false;
                        object = JavaVersion.tryParse(versionString);
                        bl10 = false;
                        object2 = Result.constructor-impl((Object)object);
                    }
                    catch (Throwable throwable) {
                        Result.Companion bl10 = Result.Companion;
                        boolean bl11 = false;
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object6 = object2;
                    bl9 = false;
                    if ((JavaVersion)(Result.isFailure-impl((Object)object6) ? null : object6) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"runCatching { JavaVersio\u2026}.getOrNull() ?: continue");
                    Object object7 = this;
                    boolean bl12 = false;
                    try {
                        object = Result.Companion;
                        $this$runCatching5 = object7;
                        boolean bl13 = false;
                        $this$runCatching5 = JdkUtil.suggestJdkName(versionString);
                        bl13 = false;
                        object = Result.constructor-impl((Object)$this$runCatching5);
                    }
                    catch (Throwable $this$runCatching5) {
                        Result.Companion bl13 = Result.Companion;
                        bl2 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching5));
                    }
                    object7 = object;
                    bl12 = false;
                    if ((String)(Result.isFailure-impl((Object)object7) ? null : object7) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)suggestedName, (String)"runCatching { JdkUtil.su\u2026}.getOrNull() ?: continue");
                    if (!(it instanceof MockSdk)) {
                        object7 = this;
                        bl12 = false;
                        try {
                            object = Result.Companion;
                            $this$runCatching5 = object7;
                            boolean bl14 = false;
                            $this$runCatching5 = sdkType.isValidSdkHome(it.getHomePath());
                            bl14 = false;
                            object = Result.constructor-impl((Object)$this$runCatching5);
                        }
                        catch (Throwable $this$runCatching6) {
                            Result.Companion bl14 = Result.Companion;
                            bl2 = false;
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching6));
                        }
                        object7 = object;
                        bl12 = false;
                        if (Intrinsics.areEqual((Object)((Boolean)(Result.isFailure-impl((Object)object7) ? null : object7)), (Object)true) ^ true) continue;
                    }
                    object7 = this;
                    bl12 = false;
                    try {
                        object = Result.Companion;
                        $this$runCatching5 = object7;
                        boolean bl15 = false;
                        Boolean bl16 = req.matches(it);
                        boolean bl17 = false;
                        object = Result.constructor-impl((Object)bl16);
                    }
                    catch (Throwable throwable) {
                        Result.Companion companion = Result.Companion;
                        bl2 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object7 = object;
                    bl12 = false;
                    if (Intrinsics.areEqual((Object)((Boolean)(Result.isFailure-impl((Object)object7) ? null : object7)), (Object)true) ^ true) continue;
                    object7 = result2;
                    JavaLocalSdkFix javaLocalSdkFix = new JavaLocalSdkFix(homeDir, version2, suggestedName);
                    boolean bl18 = false;
                    object7.add(javaLocalSdkFix);
                }
                return result2;
            }
            {
                this.this$0 = $outer;
                this.$sdkType = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$indicator = $captured_local_variable$3;
                this.lazyDownloadModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JdkItem>>(this){
                    final /* synthetic */ createResolverImpl.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final List<JdkItem> invoke() {
                        List list2;
                        this.this$0.$indicator.pushState();
                        this.this$0.$indicator.setText(ProjectBundle.message("progress.title.downloading.jdk.list", new Object[0]));
                        try {
                            list2 = JdkListDownloader.Companion.getInstance().downloadModelForJdkInstaller(this.this$0.$indicator);
                        }
                        catch (ProcessCanceledException e) {
                            throw (Throwable)e;
                        }
                        catch (Throwable t) {
                            JdkAutoKt.access$getLOG$p().warn("JdkAuto has failed to download the list of available JDKs. " + t.getMessage(), t);
                            boolean bl = false;
                            list2 = CollectionsKt.emptyList();
                        }
                        finally {
                            this.this$0.$indicator.popState();
                        }
                        return list2;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.lazyLocalJdks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<JavaLocalSdkFix>>(this){
                    final /* synthetic */ createResolverImpl.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<JavaLocalSdkFix> invoke() {
                        void var1_2;
                        this.this$0.$indicator.setText(ProjectBundle.message("progress.text.detecting.local.jdks", new Object[0]));
                        boolean bl = false;
                        List result2 = new ArrayList<E>();
                        SdkDetector.getInstance().detectSdks(this.this$0.$sdkType, this.this$0.$indicator, new SdkDetector.DetectedSdkListener(result2){
                            final /* synthetic */ List $result;

                            public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home) {
                                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                                Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
                                Intrinsics.checkParameterIsNotNull((Object)home, (String)"home");
                                JavaVersion javaVersion = JavaVersion.tryParse(version2);
                                if (javaVersion == null) {
                                    return;
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return");
                                JavaVersion javaVersion2 = javaVersion;
                                String string = JdkUtil.suggestJdkName(version2);
                                if (string == null) {
                                    return;
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JdkUtil.suggestJdkName(version) ?: return");
                                String suggestedName = string;
                                Collection collection = this.$result;
                                JavaLocalSdkFix javaLocalSdkFix = new JavaLocalSdkFix(home, javaVersion2, suggestedName);
                                boolean bl = false;
                                collection.add(javaLocalSdkFix);
                            }
                            {
                                this.$result = $captured_local_variable$0;
                            }
                        });
                        return var1_2;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
        };
    }

    @Override
    @NotNull
    public SdkDownloadTask newDownloadTask(@NotNull JdkInstallRequest request2, @Nullable Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        return JdkDownloaderBase.DefaultImpls.newDownloadTask(this, request2, project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\r\u0010\u000f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto$JavaLocalSdkFix;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "homeDir", "", "version", "Lcom/intellij/util/lang/JavaVersion;", "suggestedName", "(Ljava/lang/String;Lcom/intellij/util/lang/JavaVersion;Ljava/lang/String;)V", "getHomeDir", "()Ljava/lang/String;", "getSuggestedName", "getVersion", "()Lcom/intellij/util/lang/JavaVersion;", "getExistingSdkHome", "getSuggestedSdkName", "getVersionString", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    private static final class JavaLocalSdkFix
    implements UnknownSdkLocalSdkFix {
        @NotNull
        private final String homeDir;
        @NotNull
        private final JavaVersion version;
        @NotNull
        private final String suggestedName;

        @Override
        @NotNull
        public String getExistingSdkHome() {
            return this.homeDir;
        }

        @Override
        @NotNull
        public String getVersionString() {
            String string = JdkVersionDetector.formatVersionString(this.version);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JdkVersionDetector.formatVersionString(version)");
            return string;
        }

        @Override
        @NotNull
        public String getSuggestedSdkName() {
            return this.suggestedName;
        }

        @NotNull
        public final String getHomeDir() {
            return this.homeDir;
        }

        @NotNull
        public final JavaVersion getVersion() {
            return this.version;
        }

        @NotNull
        public final String getSuggestedName() {
            return this.suggestedName;
        }

        public JavaLocalSdkFix(@NotNull String homeDir, @NotNull JavaVersion version2, @NotNull String suggestedName) {
            Intrinsics.checkParameterIsNotNull((Object)homeDir, (String)"homeDir");
            Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
            Intrinsics.checkParameterIsNotNull((Object)suggestedName, (String)"suggestedName");
            this.homeDir = homeDir;
            this.version = version2;
            this.suggestedName = suggestedName;
        }
    }
}

