/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0007J#\u0010\u0015\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u000b\u0012\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\u00070\u0007*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0017H\u0082\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultInstallDir", "Ljava/io/File;", "newVersion", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "installJdk", "", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "prepareJdkInstallation", "jdkItem", "targetPath", "validateInstallDir", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/Nls;", "selectedPath", "writeMarkerFile", "div", "kotlin.jvm.PlatformType", "path", "Companion", "intellij.platform.lang.impl"})
public final class JdkInstaller {
    private final Logger LOG;
    public static final Companion Companion = new Companion(null);

    private final File div(@NotNull File $this$div, String path2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$div, (String)"$this$div");
        return new File($this$div, path2).getAbsoluteFile();
    }

    @NotNull
    public final File defaultInstallDir() {
        File file2;
        String string = System.getProperty("user.home");
        if (string == null) {
            string = ".";
        }
        File home = new File(FileUtil.toCanonicalPath(string));
        if (SystemInfo.isLinux) {
            File file3 = this.div(home, ".jdks");
            file2 = file3;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"home / \".jdks\"");
        } else if (SystemInfo.isMac) {
            File file4 = this.div(home, "Library");
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"home / \"Library\"");
            File file5 = this.div(file4, "Java");
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"home / \"Library\" / \"Java\"");
            File file6 = this.div(file5, "JavaVirtualMachines");
            file2 = file6;
            Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"home / \"Library\" / \"Java\" / \"JavaVirtualMachines\"");
        } else if (SystemInfo.isWindows) {
            File file7 = this.div(home, ".jdks");
            file2 = file7;
            Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"home / \".jdks\"");
        } else {
            String string2 = "Unsupported OS: " + SystemInfo.getOsNameAndVersion();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return file2;
    }

    @NotNull
    public final File defaultInstallDir(@NotNull JdkItem newVersion) {
        Intrinsics.checkParameterIsNotNull((Object)newVersion, (String)"newVersion");
        File targetDir = this.div(this.defaultInstallDir(), newVersion.getInstallFolderName());
        int count = 1;
        File uniqueDir = targetDir;
        while (uniqueDir.exists()) {
            StringBuilder stringBuilder = new StringBuilder();
            File file2 = targetDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"targetDir");
            uniqueDir = new File(stringBuilder.append(file2.getPath()).append("-").append(count++).toString());
        }
        File file3 = uniqueDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"uniqueDir");
        File file4 = file3.getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"uniqueDir.absoluteFile");
        return file4;
    }

    @NotNull
    public final Pair<File, String> validateInstallDir(@NotNull String selectedPath) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)selectedPath, (String)"selectedPath");
        if (StringsKt.isBlank((CharSequence)selectedPath)) {
            return TuplesKt.to(null, (Object)ProjectBundle.message("dialog.message.error.target.path.empty", new Object[0]));
        }
        File[] fileArray = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = fileArray;
            boolean bl2 = false;
            $this$runCatching = new File(FileUtil.expandUserHome(selectedPath));
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        fileArray = object;
        bl = false;
        boolean bl4 = false;
        File[] fileArray2 = Result.exceptionOrNull-impl((Object)fileArray);
        if (fileArray2 != null) {
            File[] t = fileArray2;
            boolean bl5 = false;
            this.LOG.warn("Failed to resolve user path: " + selectedPath + ". " + t.getMessage(), (Throwable)t);
            return TuplesKt.to(null, (Object)ProjectBundle.message("dialog.message.error.resolving.path", new Object[0]));
        }
        File targetDir = (File)fileArray;
        if (targetDir.isFile()) {
            return TuplesKt.to(null, (Object)ProjectBundle.message("dialog.message.error.target.path.exists.file", new Object[0]));
        }
        if (targetDir.isDirectory()) {
            File[] fileArray3 = targetDir.listFiles();
            if (fileArray3 != null) {
                fileArray = fileArray3;
                bl = false;
                fileArray2 = fileArray;
                boolean bl6 = false;
                if (!(fileArray2.length == 0)) {
                    return TuplesKt.to(null, (Object)ProjectBundle.message("dialog.message.error.target.path.exists.nonEmpty.dir", new Object[0]));
                }
            }
        }
        return TuplesKt.to((Object)targetDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void installJdk(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        T[] TArray = JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().getExtensions();
        Intrinsics.checkExpressionValueIsNotNull(TArray, (String)"JDK_INSTALL_LISTENER_EP_NAME.extensions");
        T[] $this$forEach$iv = TArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdkInstallerListener it = (JdkInstallerListener)element$iv;
            boolean bl = false;
            it.onJdkDownloadStarted(request2, project2);
        }
        JdkItem item = request2.getItem();
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(ProjectBundle.message("progress.text.installing.jdk.1", item.getFullPresentationText()));
        }
        File targetDir = request2.getInstallDir();
        Url url = Urls.parse((String)item.getUrl(), (boolean)false);
        if (url == null) {
            String string = "Cannot parse download URL: " + item.getUrl();
            n = 0;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Url url2 = url;
        if (!StringsKt.equals((String)url2.getScheme(), (String)"https", (boolean)true)) {
            String string = "URL must use https:// protocol, but was: " + url2;
            n = 0;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText2(ProjectBundle.message("progress.text2.downloading.jdk", new Object[0]));
        }
        File downloadFile = new File(PathManager.getTempPath(), "jdk-" + item.getArchiveFileName());
        try {
            try {
                HttpRequests.request(item.getUrl()).productNameAsUserAgent().saveToFile(downloadFile, indicator);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                throw (Throwable)new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + url2 + ". " + t.getMessage(), t);
            }
            long sizeDiff = downloadFile.length() - item.getArchiveSize();
            if (sizeDiff != 0L) {
                long it = sizeDiff;
                StringBuilder stringBuilder = new StringBuilder().append("The downloaded ").append(item.getFullPresentationText()).append(" has incorrect file size,\n").append("the difference is ");
                boolean bl = false;
                long l = Math.abs(it);
                String string = stringBuilder.append(l).append(" bytes.\n").append("Check your internet connection and try again later").toString();
                throw (Throwable)new RuntimeException(string);
            }
            T[] TArray2 = Files.asByteSource((File)downloadFile).hash(Hashing.sha256()).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)TArray2, (String)"Files.asByteSource(downl\u2026hing.sha256()).toString()");
            T[] actualHashCode = TArray2;
            if (!StringsKt.equals((String)actualHashCode, (String)item.getSha256(), (boolean)true)) {
                throw (Throwable)new RuntimeException("Failed to verify SHA-256 checksum for " + item.getFullPresentationText() + "\n\n" + "The actual value is " + (String)actualHashCode + ",\n" + "but expected " + item.getSha256() + " was expected\n" + "Check your internet connection and try again later");
            }
            ProgressIndicator progressIndicator4 = indicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator5 = indicator;
            if (progressIndicator5 != null) {
                progressIndicator5.setText2(ProjectBundle.message("progress.text2.unpacking.jdk", new Object[0]));
            }
            try {
                Decompressor decompressor = item.getPackageType().openDecompressor(downloadFile);
                decompressor.postprocessor((Consumer<? super File>)new Consumer<File>(indicator){
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final void consume(File it) {
                        block0: {
                            ProgressIndicator progressIndicator2 = this.$indicator;
                            if (progressIndicator2 == null) break block0;
                            progressIndicator2.checkCanceled();
                        }
                    }
                    {
                        this.$indicator = progressIndicator2;
                    }
                });
                String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])new char[]{'/'});
                if (!StringsKt.isBlank((CharSequence)fullMatchPath)) {
                    decompressor.removePrefixPath(fullMatchPath);
                }
                decompressor.extract(targetDir);
                this.writeMarkerFile(request2);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                throw (Throwable)new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
            }
        }
        catch (Throwable t) {
            FileUtil.delete(targetDir);
            throw t;
        }
        finally {
            FileUtil.delete(downloadFile);
            T[] TArray3 = JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().getExtensions();
            Intrinsics.checkExpressionValueIsNotNull(TArray3, (String)"JDK_INSTALL_LISTENER_EP_NAME.extensions");
            T[] $this$forEach$iv2 = TArray3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                JdkInstallerListener it = (JdkInstallerListener)element$iv;
                boolean bl = false;
                it.onJdkDownloadFinished(request2, project2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JdkInstallRequest prepareJdkInstallation(@NotNull JdkItem jdkItem, @NotNull File targetPath) {
        void home;
        Intrinsics.checkParameterIsNotNull((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        String string = targetPath.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetPath.path");
        Pair<File, String> pair = this.validateInstallDir(string);
        File file2 = (File)pair.component1();
        String error = (String)pair.component2();
        if (home == null || error != null) {
            String string2 = error;
            if (string2 == null) {
                string2 = "Invalid Target Directory";
            }
            throw (Throwable)new RuntimeException(string2);
        }
        FileUtil.createDirectory((File)home);
        if (!home.isDirectory()) {
            throw (Throwable)new IOException("Failed to create home directory: " + home);
        }
        File javaHome = StringsKt.isBlank((CharSequence)jdkItem.getPackageToBinJavaPrefix()) ? targetPath : new File(targetPath, jdkItem.getPackageToBinJavaPrefix()).getAbsoluteFile();
        FileUtil.createDirectory(javaHome);
        File file3 = javaHome;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"javaHome");
        if (!file3.isDirectory()) {
            throw (Throwable)new IOException("Failed to create home directory: " + javaHome);
        }
        JdkInstallRequest request2 = new JdkInstallRequest(jdkItem, targetPath, javaHome){
            @NotNull
            private final JdkItem item;
            @NotNull
            private final File installDir;
            private final File javaHome;
            final /* synthetic */ JdkItem $jdkItem;
            final /* synthetic */ File $targetPath;
            final /* synthetic */ File $javaHome;

            @NotNull
            public JdkItem getItem() {
                return this.item;
            }

            @NotNull
            public File getInstallDir() {
                return this.installDir;
            }

            public File getJavaHome() {
                return this.javaHome;
            }
            {
                this.$jdkItem = $captured_local_variable$0;
                this.$targetPath = $captured_local_variable$1;
                this.$javaHome = $captured_local_variable$2;
                this.item = $captured_local_variable$0;
                this.installDir = $captured_local_variable$1;
                this.javaHome = $captured_local_variable$2;
            }
        };
        this.writeMarkerFile(request2);
        return request2;
    }

    private final void writeMarkerFile(JdkInstallRequest request2) {
        File markerFile = new File(request2.getInstallDir().getPath() + "-intellij-downloader-info.txt");
        FilesKt.writeText$default((File)markerFile, (String)("Download started on " + new Date() + '\n' + request2.getItem()), null, (int)2, null);
    }

    public JdkInstaller() {
        Logger logger;
        JdkInstaller jdkInstaller = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(JdkInstaller.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        jdkInstaller.LOG = logger = logger2;
    }

    @JvmStatic
    @NotNull
    public static final JdkInstaller getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JdkInstaller getInstance() {
            boolean $i$f$service = false;
            JdkInstaller jdkInstaller = ApplicationManager.getApplication().getService(JdkInstaller.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jdkInstaller, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return jdkInstaller;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

