/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;

public class Util {
    public static VirtualFile showSpecifyJavadocUrlDialog(JComponent parent) {
        return Util.showSpecifyJavadocUrlDialog(parent, "");
    }

    public static VirtualFile showSpecifyJavadocUrlDialog(JComponent parent, String initialValue) {
        String url = Messages.showInputDialog(parent, ProjectBundle.message("sdk.configure.javadoc.url.prompt", new Object[0]), ProjectBundle.message("sdk.configure.javadoc.url.title", new Object[0]), Messages.getQuestionIcon(), initialValue, new InputValidator(){

            @Override
            public boolean checkInput(String inputString) {
                return true;
            }

            @Override
            public boolean canClose(String inputString) {
                try {
                    new URL(inputString);
                    return true;
                }
                catch (MalformedURLException e1) {
                    Messages.showErrorDialog(e1.getMessage(), ProjectBundle.message("sdk.configure.javadoc.url.title", new Object[0]));
                    return false;
                }
            }
        });
        if (url == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }
}

