/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ContentFolderBaseImpl
extends RootModelComponentBase
implements ContentFolder,
Comparable<ContentFolderBaseImpl> {
    @NonNls
    public static final String URL_ATTRIBUTE = "url";
    private static final Logger LOG = Logger.getInstance(ContentFolderBaseImpl.class);
    private final VirtualFilePointer myFilePointer;
    protected final ContentEntryImpl myContentEntry;

    ContentFolderBaseImpl(@NotNull VirtualFile file2, @NotNull ContentEntryImpl contentEntry) {
        if (file2 == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(0);
        }
        if (contentEntry == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(1);
        }
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(file2, (Disposable)this, this.getRootModel().getRootsChangedListener());
    }

    ContentFolderBaseImpl(@NotNull String url, @NotNull ContentEntryImpl contentEntry) {
        if (url == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(2);
        }
        if (contentEntry == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(3);
        }
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, this.getRootModel().getRootsChangedListener());
    }

    protected ContentFolderBaseImpl(@NotNull ContentFolderBaseImpl that, @NotNull ContentEntryImpl contentEntry) {
        if (that == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(4);
        }
        if (contentEntry == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(5);
        }
        this(that.myFilePointer, contentEntry);
    }

    ContentFolderBaseImpl(@NotNull Element element2, @NotNull ContentEntryImpl contentEntry) throws InvalidDataException {
        if (element2 == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(6);
        }
        if (contentEntry == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(7);
        }
        this(ContentFolderBaseImpl.getUrlFrom(element2), contentEntry);
    }

    protected ContentFolderBaseImpl(@NotNull VirtualFilePointer filePointer, @NotNull ContentEntryImpl contentEntry) {
        if (filePointer == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(8);
        }
        if (contentEntry == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(9);
        }
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().duplicate(filePointer, this, this.getRootModel().getRootsChangedListener());
    }

    @NotNull
    private static String getUrlFrom(@NotNull Element element2) throws InvalidDataException {
        String url;
        if (element2 == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(10);
        }
        if ((url = element2.getAttributeValue(URL_ATTRIBUTE)) == null) {
            throw new InvalidDataException();
        }
        String string = url;
        if (string == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public VirtualFile getFile() {
        if (!this.myFilePointer.isValid()) {
            return null;
        }
        return this.myFilePointer.getFile();
    }

    @Override
    @NotNull
    public ContentEntry getContentEntry() {
        ContentEntryImpl contentEntryImpl = this.myContentEntry;
        if (contentEntryImpl == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(12);
        }
        return contentEntryImpl;
    }

    protected void writeFolder(@NotNull Element element2, @NotNull String elementName) {
        if (element2 == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(13);
        }
        if (elementName == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(element2.getName().equals(elementName));
        element2.setAttribute(URL_ATTRIBUTE, this.myFilePointer.getUrl());
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myFilePointer.getUrl();
        if (string == null) {
            ContentFolderBaseImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        return this.getUrl().compareTo(folder.getUrl());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContentFolderBaseImpl)) {
            return false;
        }
        return this.compareTo((ContentFolderBaseImpl)obj) == 0;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @Nullable
    public String toString() {
        return this.myFilePointer == null ? null : this.getUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTRIBUTE;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ContentFolderBaseImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ContentFolderBaseImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlFrom";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentEntry";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUrlFrom";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

