/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

abstract class FileIndexBase
implements FileIndex {
    private final FileTypeRegistry myFileTypeRegistry;
    final DirectoryIndex myDirectoryIndex;

    FileIndexBase(@NotNull DirectoryIndex directoryIndex) {
        if (directoryIndex == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
    }

    protected abstract boolean isScopeDisposed();

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor2) {
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        return this.iterateContent(processor2, null);
    }

    @Override
    public boolean iterateContentUnderDirectory(final @NotNull VirtualFile dir, final @NotNull ContentIterator processor2, final @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryInfo info = ReadAction.compute(() -> FileIndexBase.this.getInfoForFileOrDirectory(file2));
                if (file2.isDirectory()) {
                    if (info.isExcluded(file2)) {
                        if (!info.processContentBeneathExcluded(file2, content2 -> FileIndexBase.this.iterateContentUnderDirectory((VirtualFile)content2, processor2, customFilter))) {
                            VirtualFileVisitor.Result result2 = 1.skipTo(dir);
                            if (result2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result2;
                        }
                        VirtualFileVisitor.Result result3 = SKIP_CHILDREN;
                        if (result3 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result3;
                    }
                    if (info.isIgnored()) {
                        VirtualFileVisitor.Result result4 = SKIP_CHILDREN;
                        if (result4 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result4;
                    }
                }
                boolean accepted = ReadAction.compute(() -> !FileIndexBase.this.isScopeDisposed() && FileIndexBase.this.isInContent(file2, info)) != false && (customFilter == null || customFilter.accept(file2));
                VirtualFileVisitor.Result result5 = !accepted || processor2.processFile(file2) ? CONTINUE : 1.skipTo(dir);
                if (result5 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return result5;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal(result2.skipToParent, dir);
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(5);
        }
        return this.iterateContentUnderDirectory(dir, processor2, null);
    }

    boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType;
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return (rootType = this.myDirectoryIndex.getSourceRootType(info)) != null && rootType.isForTests();
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        file2 = BackedVirtualFile.getOriginFileIfBacked(file2);
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        return directoryInfo;
    }

    @Override
    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourcesRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isContentSourceFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

