/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements ProjectComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerComponent.class);
    private static final boolean LOG_CACHES_UPDATE = ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    private final ExecutorService myExecutor;
    @NotNull
    private Future<?> myCollectWatchRootsFuture;
    private boolean myPointerChangesDetected;
    private int myInsideRefresh;
    @NotNull
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch;
    private Disposable myRootPointersDisposable;
    private final VirtualFilePointerListener myRootsChangedListener;

    public ProjectRootManagerComponent(@NotNull Project project2) {
        if (project2 == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myExecutor = ApplicationManager.getApplication().isUnitTestMode() ? ConcurrencyUtil.newSameThreadExecutorService() : AppExecutorUtil.createBoundedApplicationPoolExecutor("Project Root Manager", 1);
        this.myCollectWatchRootsFuture = CompletableFuture.completedFuture(null);
        this.myRootsToWatch = new THashSet<LocalFileSystem.WatchRequest>();
        this.myRootPointersDisposable = Disposer.newDisposable();
        this.myRootsChangedListener = new VirtualFilePointerListener(){

            @Override
            public void beforeValidityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                    return;
                }
                if (ProjectRootManagerComponent.this.myInsideRefresh == 0) {
                    ProjectRootManagerComponent.this.beforeRootsChange(false);
                    if (LOG_CACHES_UPDATE || LOG.isTraceEnabled()) {
                        LOG.trace(new Throwable(pointers2.length > 0 ? pointers2[0].getPresentableUrl() : ""));
                    }
                } else if (!ProjectRootManagerComponent.this.myPointerChangesDetected) {
                    ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                    ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS).beforeRootsChange(new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                    if (LOG_CACHES_UPDATE || LOG.isTraceEnabled()) {
                        LOG.trace(new Throwable(pointers2.length > 0 ? pointers2[0].getPresentableUrl() : ""));
                    }
                }
            }

            @Override
            public void validityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                    return;
                }
                if (ProjectRootManagerComponent.this.myInsideRefresh > 0) {
                    ProjectRootManagerComponent.this.clearScopesCaches();
                } else {
                    ProjectRootManagerComponent.this.rootsChanged(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pointers";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeValidityChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validityChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        MessageBusConnection connection = project2.getMessageBus().connect(this);
        connection.subscribe(FileTypeManager.TOPIC, new FileTypeListener(){

            @Override
            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectRootManagerComponent.this.beforeRootsChange(true);
            }

            @Override
            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProjectRootManagerComponent.this.rootsChanged(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileTypesChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        VirtualFileManager.getInstance().addVirtualFileManagerListener(new VirtualFileManagerListener(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                ProjectRootManagerComponent.this.doUpdateOnRefresh();
            }
        }, project2);
        if (!this.myProject.isDefault()) {
            StartupManager.getInstance(project2).registerStartupActivity(() -> {
                this.myStartupActivityPerformed = true;
            });
        }
        connection.subscribe(BatchUpdateListener.TOPIC, new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        });
        AdditionalLibraryRootsProvider.EP_NAME.addExtensionPointListener(new ExtensionPointChangeListener(){

            @Override
            public void extensionListChanged() {
                ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> ProjectRootManagerComponent.this.makeRootsChange(EmptyRunnable.getInstance(), false, true)));
            }
        }, (Disposable)project2);
    }

    @Override
    public void projectOpened() {
        this.addRootsToWatch();
        ApplicationManager.getApplication().addApplicationListener(new AppListener(), this.myProject);
    }

    @Override
    public void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    private void addRootsToWatch() {
        if (this.myProject.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        Disposable oldDisposable = this.myRootPointersDisposable;
        Disposable newDisposable = Disposer.newDisposable();
        this.myCollectWatchRootsFuture.cancel(false);
        this.myCollectWatchRootsFuture = this.myExecutor.submit(() -> {
            Pair watchRoots = ReadAction.compute(() -> this.myProject.isDisposed() ? null : this.collectWatchRoots(newDisposable));
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myRootPointersDisposable = newDisposable;
                Disposer.dispose(oldDisposable);
                this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)watchRoots.first, (Collection)watchRoots.second);
            }, ModalityState.any());
        });
    }

    private void beforeRootsChange(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.getBatchSession(fileTypes).beforeRootsChanged();
    }

    private void rootsChanged(boolean fileTypes) {
        this.getBatchSession(fileTypes).rootsChanged();
    }

    private void doUpdateOnRefresh() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (!this.myStartupActivityPerformed || this.myProject.isDisposed())) {
            return;
        }
        if (this.myProject.isDefault() || LightEdit.owns(this.myProject)) {
            return;
        }
        if (LOG_CACHES_UPDATE || LOG.isDebugEnabled()) {
            LOG.debug("refresh");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        DumbModeTask task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task2 != null) {
            dumbService.queueTask(task2);
        }
    }

    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS).beforeRootsChange(new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    @Override
    protected void fireRootsChangedEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS).rootsChanged(new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
        this.synchronizeRoots();
        this.addRootsToWatch();
    }

    @NotNull
    private Pair<Set<String>, Set<String>> collectWatchRoots(@NotNull Disposable disposable2) {
        Collection<VirtualFile> toWatch;
        if (disposable2 == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        THashSet<String> recursivePaths = new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY);
        THashSet<String> flatPaths = new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY);
        String projectFilePath = this.myProject.getProjectFilePath();
        if (projectFilePath != null && !".idea".equals(new File(projectFilePath).getParentFile().getName())) {
            flatPaths.add(FileUtil.toSystemIndependentName(projectFilePath));
            String string = ProjectKt.getStateStore(this.myProject).getWorkspaceFilePath();
            if (string != null) {
                flatPaths.add(FileUtil.toSystemIndependentName(string));
            }
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : AdditionalLibraryRootsProvider.EP_NAME.getExtensions()) {
            toWatch = additionalLibraryRootsProvider.getRootsToWatch(this.myProject);
            if (toWatch.isEmpty()) continue;
            recursivePaths.addAll(ContainerUtil.map(toWatch, VirtualFile::getPath));
        }
        for (WatchedRootsProvider watchedRootsProvider : WatchedRootsProvider.EP_NAME.getExtensions(this.myProject)) {
            toWatch = watchedRootsProvider.getRootsToWatch();
            if (toWatch.isEmpty()) continue;
            recursivePaths.addAll(ContainerUtil.map(toWatch, FileUtil::toSystemIndependentName));
        }
        List<String> list2 = ContainerUtil.map(recursivePaths, VfsUtilCore::pathToUrl);
        THashSet<String> excludedUrls = new THashSet<String>();
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(this.myProject)) {
            Collections.addAll(excludedUrls, excludePolicy.getExcludeUrlsForProject());
        }
        if (!(list2.isEmpty() && flatPaths.isEmpty() && excludedUrls.isEmpty())) {
            Disposer.register(this, disposable2);
            VirtualFilePointerContainer container2 = VirtualFilePointerManager.getInstance().createContainer(disposable2, this.getRootsValidityChangedListener());
            ((VirtualFilePointerContainerImpl)container2).addAllJarDirectories(list2, true);
            flatPaths.forEach(path2 -> container2.add(VfsUtilCore.pathToUrl(path2)));
            ((VirtualFilePointerContainerImpl)container2).addAll(excludedUrls);
        }
        this.collectModuleWatchRoots(recursivePaths, flatPaths);
        Pair<Set<String>, Set<String>> pair = Pair.create(recursivePaths, flatPaths);
        if (pair == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(2);
        }
        return pair;
    }

    private void collectModuleWatchRoots(@NotNull Set<? super String> recursivePaths, @NotNull Set<? super String> flatPaths) {
        if (recursivePaths == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(3);
        }
        if (flatPaths == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(4);
        }
        THashSet<String> urls = new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY);
        for (Module module2 : ModuleManager.getInstance(this.myProject).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module2);
            ContainerUtil.addAll(urls, rootManager.getContentRootUrls());
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(entry -> {
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    ContainerUtil.addAll(urls, entry.getUrls(type));
                }
                return true;
            });
        }
        for (String url : urls) {
            String protocol = VirtualFileManager.extractProtocol(url);
            if (protocol == null || "file".equals(protocol)) {
                recursivePaths.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if ("jar".equals(protocol)) {
                flatPaths.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jrt".equals(protocol)) continue;
            recursivePaths.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    private void synchronizeRoots() {
        if (!this.myStartupActivityPerformed) {
            return;
        }
        if (LOG_CACHES_UPDATE || LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("sync roots"));
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("project roots have changed");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        if (FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
            dumbService.queueTask(new UnindexedFilesUpdater(this.myProject));
        }
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache libraryScopeCache = this.myProject.getServiceIfCreated(LibraryScopeCache.class);
        if (libraryScopeCache != null) {
            libraryScopeCache.clear();
        }
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        super.clearScopesCachesForModules();
        for (Module module2 : modules = ModuleManager.getInstance(this.myProject).getModules()) {
            ((ModuleEx)module2).clearScopesCache();
        }
    }

    @Override
    public void markRootsForRefresh() {
        THashSet<String> paths = new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY);
        this.collectModuleWatchRoots(paths, paths);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path2 : paths) {
            VirtualFile root = fs.findFileByPath(path2);
            if (!(root instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)root).markDirtyRecursively();
        }
    }

    @Override
    public void dispose() {
        this.myCollectWatchRootsFuture.cancel(false);
        this.myExecutor.shutdownNow();
    }

    @Override
    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myRootsChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(5);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursivePaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWatchRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectWatchRoots";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleWatchRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppListener
    implements ApplicationListener {
        private AppListener() {
        }

        @Override
        public void beforeWriteActionStart(@NotNull Object action2) {
            if (action2 == null) {
                AppListener.$$$reportNull$$$0(0);
            }
            ProjectRootManagerComponent.this.myInsideRefresh++;
        }

        @Override
        public void writeActionFinished(@NotNull Object action2) {
            if (action2 == null) {
                AppListener.$$$reportNull$$$0(1);
            }
            if (--ProjectRootManagerComponent.this.myInsideRefresh == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ProjectRootManagerComponent.this.incModificationCount();
                ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS).rootsChanged(new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                ProjectRootManagerComponent.this.synchronizeRoots();
                ProjectRootManagerComponent.this.addRootsToWatch();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$AppListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

