/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryRootsComponentDescriptor {
    @Nullable
    public abstract OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType var1);

    @NotNull
    public abstract List<? extends RootDetector> getRootDetectors();

    @NotNull
    public LibraryRootsDetector getRootsDetector() {
        List<? extends RootDetector> detectors = this.getRootDetectors();
        if (detectors.isEmpty()) {
            throw new IllegalStateException("Detectors list is empty for " + this);
        }
        return new LibraryRootsDetectorImpl(detectors);
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
        descriptor2.setTitle(StringUtil.isEmpty(libraryName) ? ProjectBundle.message("library.attach.files.action", new Object[0]) : ProjectBundle.message("library.attach.files.to.library.action", libraryName));
        descriptor2.setDescription(ProjectBundle.message("library.attach.files.description", new Object[0]));
        FileChooserDescriptor fileChooserDescriptor2 = descriptor2;
        if (fileChooserDescriptor2 == null) {
            LibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor2;
    }

    @NotNull
    public RootRemovalHandler createRootRemovalHandler() {
        return new RootRemovalHandler(){

            @Override
            public void onRootRemoved(@NotNull String rootUrl, @NotNull OrderRootType rootType, @NotNull LibraryEditor libraryEditor) {
                if (rootUrl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (libraryEditor == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootUrl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "libraryEditor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/libraries/ui/LibraryRootsComponentDescriptor$1";
                objectArray[2] = "onRootRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public abstract List<? extends AttachRootButtonDescriptor> createAttachButtons();

    public OrderRootType[] getRootTypes() {
        return OrderRootType.getAllTypes();
    }

    public String getAttachFilesActionName() {
        return ProjectBundle.message("button.text.attach.files", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/LibraryRootsComponentDescriptor", "createAttachFilesChooserDescriptor"));
    }

    public static interface RootRemovalHandler {
        public void onRootRemoved(@NotNull String var1, @NotNull OrderRootType var2, @NotNull LibraryEditor var3);
    }
}

