/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TitlePanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeTable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxCellEditor;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DetectedRootsChooserDialog
extends DialogWrapper {
    private static final ColumnInfo ROOT_COLUMN = new TreeColumnInfo("");
    private static final ColumnInfo<VirtualFileCheckedTreeNode, String> ROOT_TYPE_COLUMN = new ColumnInfo<VirtualFileCheckedTreeNode, String>(""){

        @Override
        public String valueOf(VirtualFileCheckedTreeNode node) {
            SuggestedChildRootInfo rootInfo = node.getRootInfo();
            return rootInfo != null ? rootInfo.getRootTypeName(rootInfo.getSelectedRootType()) : "";
        }

        @Override
        public TableCellRenderer getRenderer(VirtualFileCheckedTreeNode node) {
            SuggestedChildRootInfo rootInfo = node.getRootInfo();
            if (rootInfo != null && this.isCellEditable(node)) {
                return new ComboBoxTableRenderer<String>(rootInfo.getRootTypeNames());
            }
            return new DefaultTableCellRenderer();
        }

        @Override
        public TableCellEditor getEditor(VirtualFileCheckedTreeNode o) {
            final SuggestedChildRootInfo rootInfo = o.getRootInfo();
            if (rootInfo == null) {
                return null;
            }
            ComboBoxCellEditor editor = new ComboBoxCellEditor(){

                @Override
                protected List<String> getComboBoxItems() {
                    return Arrays.asList(rootInfo.getRootTypeNames());
                }
            };
            editor.setClickCountToStart(1);
            return editor;
        }

        @Override
        public boolean isCellEditable(VirtualFileCheckedTreeNode node) {
            SuggestedChildRootInfo rootInfo = node.getRootInfo();
            return rootInfo != null && rootInfo.getDetectedRoot().getTypes().size() > 1;
        }

        @Override
        public void setValue(VirtualFileCheckedTreeNode node, String value2) {
            SuggestedChildRootInfo rootInfo = node.getRootInfo();
            if (rootInfo != null) {
                rootInfo.setSelectedRootType(value2);
            }
        }
    };
    private CheckboxTreeTable myTreeTable;
    private JScrollPane myPane;
    private String myDescription;

    public DetectedRootsChooserDialog(Component component2, Collection<SuggestedChildRootInfo> suggestedRoots) {
        super(component2, true);
        this.init(suggestedRoots);
    }

    public DetectedRootsChooserDialog(Project project2, Collection<SuggestedChildRootInfo> suggestedRoots) {
        super(project2, true);
        this.init(suggestedRoots);
    }

    private void init(Collection<SuggestedChildRootInfo> suggestedRoots) {
        this.myDescription = XmlStringUtil.wrapInHtml(ApplicationNamesInfo.getInstance().getFullProductName() + " just scanned files and detected the following " + StringUtil.pluralize("root", suggestedRoots.size()) + ".<br>Select items in the tree below or press Cancel to cancel operation.");
        this.myTreeTable = DetectedRootsChooserDialog.createTreeTable(suggestedRoots);
        this.myPane = ScrollPaneFactory.createScrollPane(this.myTreeTable);
        this.setTitle(ProjectBundle.message("dialog.title.detected.roots", new Object[0]));
        this.init();
    }

    private static CheckboxTreeTable createTreeTable(Collection<SuggestedChildRootInfo> suggestedRoots) {
        CheckedTreeNode root = DetectedRootsChooserDialog.createRoot(suggestedRoots);
        CheckboxTreeTable treeTable = new CheckboxTreeTable(root, new CheckboxTree.CheckboxTreeCellRenderer(true){

            @Override
            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                SimpleTextAttributes attributes;
                String text2;
                if (!(value2 instanceof VirtualFileCheckedTreeNode)) {
                    return;
                }
                VirtualFileCheckedTreeNode node = (VirtualFileCheckedTreeNode)value2;
                VirtualFile file2 = node.getFile();
                boolean isValid = true;
                if (leaf) {
                    VirtualFile ancestor = ((VirtualFileCheckedTreeNode)node.getParent()).getFile();
                    if (ancestor != null) {
                        text2 = VfsUtilCore.getRelativePath(file2, ancestor, File.separatorChar);
                        if (StringUtil.isEmpty(text2)) {
                            text2 = File.separator;
                        }
                    } else {
                        text2 = file2.getPresentableUrl();
                    }
                    if (text2 == null) {
                        isValid = false;
                        text2 = file2.getPresentableUrl();
                    }
                    attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                } else {
                    text2 = file2.getPresentableUrl();
                    attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                textRenderer.setIcon(PlatformIcons.FOLDER_ICON);
                if (!isValid) {
                    textRenderer.append("[INVALID] ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
                textRenderer.append(text2, attributes);
            }
        }, new ColumnInfo[]{ROOT_COLUMN, ROOT_TYPE_COLUMN});
        int max = 0;
        for (SuggestedChildRootInfo info : suggestedRoots) {
            for (String s : info.getRootTypeNames()) {
                max = Math.max(max, treeTable.getFontMetrics(treeTable.getFont()).stringWidth(s));
            }
        }
        TableColumn column = treeTable.getColumnModel().getColumn(1);
        int width = max + 20;
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        treeTable.setRootVisible(false);
        new TreeTableSpeedSearch(treeTable, o -> {
            Object node = o.getLastPathComponent();
            if (!(node instanceof VirtualFileCheckedTreeNode)) {
                return "";
            }
            return ((VirtualFileCheckedTreeNode)node).getFile().getPresentableUrl();
        });
        TreeUtil.expandAll(treeTable.getTree());
        return treeTable;
    }

    private static CheckedTreeNode createRoot(Collection<SuggestedChildRootInfo> suggestedRoots) {
        SuggestedChildRootInfo[] sortedRoots = suggestedRoots.toArray(new SuggestedChildRootInfo[0]);
        Arrays.sort(sortedRoots, (o1, o2) -> o1.getDetectedRoot().getFile().getPresentableUrl().compareTo(o2.getDetectedRoot().getFile().getPresentableUrl()));
        CheckedTreeNode root = new CheckedTreeNode(null);
        HashMap<VirtualFile, CheckedTreeNode> rootCandidateNodes = new HashMap<VirtualFile, CheckedTreeNode>();
        for (SuggestedChildRootInfo rootInfo : sortedRoots) {
            VirtualFile rootCandidate = rootInfo.getRootCandidate();
            CheckedTreeNode parent = (CheckedTreeNode)rootCandidateNodes.get(rootCandidate);
            if (parent == null) {
                parent = new VirtualFileCheckedTreeNode(rootCandidate);
                rootCandidateNodes.put(rootCandidate, parent);
                root.add(parent);
            }
            parent.add(new VirtualFileCheckedTreeNode(rootInfo));
        }
        return root;
    }

    @Override
    protected JComponent createTitlePane() {
        return new TitlePanel(ProjectBundle.message("section.title.choose.roots", new Object[0]), this.myDescription);
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    public SuggestedChildRootInfo[] getChosenRoots() {
        return this.myTreeTable.getCheckedNodes(SuggestedChildRootInfo.class);
    }

    @Override
    @NonNls
    protected String getDimensionServiceKey() {
        return "DetectedRootsChooserDialog";
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private static class VirtualFileCheckedTreeNode
    extends CheckedTreeNode {
        private final VirtualFile myFile;

        private VirtualFileCheckedTreeNode(VirtualFile file2) {
            super(file2);
            this.myFile = file2;
        }

        VirtualFileCheckedTreeNode(SuggestedChildRootInfo rootInfo) {
            super(rootInfo);
            this.myFile = rootInfo.getDetectedRoot().getFile();
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @Nullable
        private SuggestedChildRootInfo getRootInfo() {
            return this.userObject instanceof SuggestedChildRootInfo ? (SuggestedChildRootInfo)this.userObject : null;
        }
    }
}

