/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PlatformContentEntriesConfigurable
implements Configurable {
    private final Module myModule;
    private final JpsModuleSourceRootType<?>[] myRootTypes;
    private final JPanel myTopPanel = new JPanel(new BorderLayout());
    private ModifiableRootModel myModifiableModel;
    private CommonContentEntriesEditor myEditor;

    public PlatformContentEntriesConfigurable(Module module2, JpsModuleSourceRootType<?> ... rootTypes) {
        this.myModule = module2;
        this.myRootTypes = rootTypes;
    }

    @Override
    public String getDisplayName() {
        return ProjectBundle.message("configurable.PlatformContentEntriesConfigurable.display.name", new Object[0]);
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    @Override
    public JComponent createComponent() {
        this.createEditor();
        return this.myTopPanel;
    }

    private void createEditor() {
        this.myModifiableModel = ReadAction.compute(() -> ModuleRootManager.getInstance(this.myModule).getModifiableModel());
        ModuleConfigurationStateImpl moduleConfigurationState = new ModuleConfigurationStateImpl(this.myModule.getProject(), new DefaultModulesProvider(this.myModule.getProject())){

            @Override
            public ModifiableRootModel getRootModel() {
                return PlatformContentEntriesConfigurable.this.myModifiableModel;
            }
        };
        this.myEditor = new CommonContentEntriesEditor(this.myModule.getName(), moduleConfigurationState, true, (JpsModuleSourceRootType[])this.myRootTypes){

            @Override
            protected List<ContentEntry> addContentEntries(VirtualFile[] files2) {
                List<ContentEntry> entries = super.addContentEntries(files2);
                this.addContentEntryPanels(entries.toArray(new ContentEntry[0]));
                return entries;
            }
        };
        JComponent component2 = ReadAction.compute(() -> this.myEditor.createComponent());
        this.myTopPanel.add((Component)component2, "Center");
    }

    @Override
    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    @Override
    public void apply() throws ConfigurationException {
        this.myEditor.apply();
        if (this.myModifiableModel.isChanged()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
            this.myEditor.disposeUIResources();
            this.myTopPanel.remove(this.myEditor.getComponent());
            this.createEditor();
        }
    }

    @Override
    public void reset() {
        this.myEditor.reset();
    }

    @Override
    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myTopPanel.remove(this.myEditor.getComponent());
            this.myEditor = null;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
            this.myModifiableModel = null;
        }
    }
}

