/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkListItem {
    private SdkListItem() {
    }

    public static final class GroupItem
    extends SdkListItem {
        final Icon myIcon;
        final String myCaption;
        final List<? extends SdkListItem> mySubItems;

        GroupItem(@NotNull Icon icon2, @NotNull String caption, @NotNull List<ActionItem> subItems) {
            if (icon2 == null) {
                GroupItem.$$$reportNull$$$0(0);
            }
            if (caption == null) {
                GroupItem.$$$reportNull$$$0(1);
            }
            if (subItems == null) {
                GroupItem.$$$reportNull$$$0(2);
            }
            this.myIcon = icon2;
            this.myCaption = caption;
            this.mySubItems = ImmutableList.copyOf(ContainerUtil.map(subItems, it -> it.withGroup(this)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caption";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "subItems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$GroupItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ActionItem
    extends SdkListItem {
        @Nullable
        final GroupItem myGroup;
        @NotNull
        final ActionRole myRole;
        @NotNull
        final ProjectSdksModel.NewSdkAction myAction;

        ActionItem(@NotNull ActionRole role, @NotNull ProjectSdksModel.NewSdkAction action2, @Nullable GroupItem group) {
            if (role == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            this.myRole = role;
            this.myAction = action2;
            this.myGroup = group;
        }

        @NotNull
        public ActionRole getRole() {
            ActionRole actionRole = this.myRole;
            if (actionRole == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            return actionRole;
        }

        @NotNull
        public ProjectSdksModel.NewSdkAction getAction() {
            ProjectSdksModel.NewSdkAction newSdkAction = this.myAction;
            if (newSdkAction == null) {
                ActionItem.$$$reportNull$$$0(3);
            }
            return newSdkAction;
        }

        @NotNull
        ActionItem withGroup(@NotNull GroupItem group) {
            if (group == null) {
                ActionItem.$$$reportNull$$$0(4);
            }
            return new ActionItem(this.myRole, this.myAction, group);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "role";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$ActionItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$ActionItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRole";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withGroup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ActionRole {
        DOWNLOAD,
        ADD;

    }

    public static final class SuggestedItem
    extends SdkListItem {
        private final SdkType mySdkType;
        private final String myHomePath;
        private final String myVersion;

        SuggestedItem(@NotNull SdkType sdkType, @NotNull String version2, @NotNull String homePath) {
            if (sdkType == null) {
                SuggestedItem.$$$reportNull$$$0(0);
            }
            if (version2 == null) {
                SuggestedItem.$$$reportNull$$$0(1);
            }
            if (homePath == null) {
                SuggestedItem.$$$reportNull$$$0(2);
            }
            this.mySdkType = sdkType;
            this.myHomePath = homePath;
            this.myVersion = version2;
        }

        @NotNull
        public SdkType getSdkType() {
            SdkType sdkType = this.mySdkType;
            if (sdkType == null) {
                SuggestedItem.$$$reportNull$$$0(3);
            }
            return sdkType;
        }

        @NotNull
        public String getHomePath() {
            String string = this.myHomePath;
            if (string == null) {
                SuggestedItem.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getVersion() {
            String string = this.myVersion;
            if (string == null) {
                SuggestedItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "homePath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SuggestedItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SuggestedItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHomePath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class InvalidSdkItem
    extends SdkListItem {
        private final String mySdkName;

        InvalidSdkItem(@NotNull String name) {
            if (name == null) {
                InvalidSdkItem.$$$reportNull$$$0(0);
            }
            this.mySdkName = name;
        }

        @NotNull
        public String getSdkName() {
            String string = this.mySdkName;
            if (string == null) {
                InvalidSdkItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InvalidSdkItem)) {
                return false;
            }
            InvalidSdkItem item = (InvalidSdkItem)o;
            return this.mySdkName.equals(item.mySdkName);
        }

        public int hashCode() {
            return Objects.hash(this.mySdkName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$InvalidSdkItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$InvalidSdkItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class NoneSdkItem
    extends SdkListItem {
        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof NoneSdkItem;
        }
    }

    public static final class ProjectSdkItem
    extends SdkListItem {
        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectSdkItem;
        }
    }

    public static abstract class SdkItem
    extends SdkListItem {
        private final Sdk mySdk;

        SdkItem(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                SdkItem.$$$reportNull$$$0(0);
            }
            this.mySdk = sdk2;
        }

        @NotNull
        public final Sdk getSdk() {
            Sdk sdk2 = this.mySdk;
            if (sdk2 == null) {
                SdkItem.$$$reportNull$$$0(1);
            }
            return sdk2;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SdkItem)) {
                return false;
            }
            SdkItem item = (SdkItem)o;
            return this.mySdk.equals(item.mySdk);
        }

        public final int hashCode() {
            return Objects.hash(this.mySdk);
        }

        abstract boolean hasSameSdk(@NotNull Sdk var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class SdkReferenceItem
    extends SdkListItem {
        private final SdkType mySdkType;
        private final String myName;
        private final String myVersionString;
        private final boolean myHasValidPath;

        SdkReferenceItem(@NotNull SdkType sdkType, @NotNull String name, @Nullable String versionString, boolean hasValidPath) {
            if (sdkType == null) {
                SdkReferenceItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                SdkReferenceItem.$$$reportNull$$$0(1);
            }
            this.mySdkType = sdkType;
            this.myName = name;
            this.myVersionString = versionString;
            this.myHasValidPath = hasValidPath;
        }

        @NotNull
        public SdkType getSdkType() {
            SdkType sdkType = this.mySdkType;
            if (sdkType == null) {
                SdkReferenceItem.$$$reportNull$$$0(2);
            }
            return sdkType;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SdkReferenceItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public String getVersionString() {
            return this.myVersionString;
        }

        public boolean isValid() {
            return this.myHasValidPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SdkReferenceItem)) {
                return false;
            }
            SdkReferenceItem item = (SdkReferenceItem)o;
            return this.mySdkType.equals(item.mySdkType) && this.myName.equals(item.myName);
        }

        public int hashCode() {
            return Objects.hash(this.mySdkType, this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkReferenceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkReferenceItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

