/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BrowseFolderRunnable<T extends JComponent>
implements Runnable {
    private final String myTitle;
    private final String myDescription;
    protected final TextComponentAccessor<? super T> myAccessor;
    protected final FileChooserDescriptor myFileChooserDescriptor;
    protected T myTextComponent;
    private Project myProject;

    public BrowseFolderRunnable(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project2, FileChooserDescriptor fileChooserDescriptor2, @Nullable T component2, TextComponentAccessor<? super T> accessor) {
        if (fileChooserDescriptor2 != null && fileChooserDescriptor2.isChooseMultiple()) {
            fileChooserDescriptor2 = new FileChooserDescriptor(fileChooserDescriptor2){

                @Override
                public boolean isChooseMultiple() {
                    return false;
                }
            };
        }
        this.myTitle = title;
        this.myDescription = description;
        this.myTextComponent = component2;
        this.myProject = project2;
        this.myFileChooserDescriptor = fileChooserDescriptor2;
        this.myAccessor = accessor;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected void setProject(@Nullable Project project2) {
        this.myProject = project2;
    }

    @Override
    public void run() {
        FileChooserDescriptor fileChooserDescriptor2 = this.myFileChooserDescriptor;
        if (this.myTitle != null || this.myDescription != null) {
            fileChooserDescriptor2 = (FileChooserDescriptor)this.myFileChooserDescriptor.clone();
            if (this.myTitle != null) {
                fileChooserDescriptor2.setTitle(this.myTitle);
            }
            if (this.myDescription != null) {
                fileChooserDescriptor2.setDescription(this.myDescription);
            }
        }
        FileChooser.chooseFile(fileChooserDescriptor2, this.getProject(), this.myTextComponent, this.getInitialFile(), this::onFileChosen);
    }

    @Nullable
    protected VirtualFile getInitialFile() {
        int pos;
        String directoryName = this.myAccessor.getText(this.myTextComponent).trim();
        if (StringUtil.isEmptyOrSpaces(directoryName)) {
            return null;
        }
        directoryName = FileUtil.toSystemIndependentName(directoryName);
        VirtualFile path2 = LocalFileSystem.getInstance().findFileByPath(this.expandPath(directoryName));
        while (path2 == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
            directoryName = directoryName.substring(0, pos);
            path2 = LocalFileSystem.getInstance().findFileByPath(directoryName);
        }
        return path2;
    }

    @NotNull
    protected String expandPath(@NotNull String path2) {
        if (path2 == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(0);
        }
        String string = path2;
        if (string == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
        if (chosenFile == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(2);
        }
        String string = chosenFile.getPresentableUrl();
        if (string == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected String getComponentText() {
        return this.myAccessor.getText(this.myTextComponent).trim();
    }

    protected void onFileChosen(@NotNull VirtualFile chosenFile) {
        if (chosenFile == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(4);
        }
        this.myAccessor.setText(this.myTextComponent, this.chosenFileToResultingText(chosenFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/BrowseFolderRunnable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/BrowseFolderRunnable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "chosenFileToResultingText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "chosenFileToResultingText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onFileChosen";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

