/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBox<E>
extends ComboBoxWithWidePopup<E>
implements AWTEventListener {
    public static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    private int myMinimumAndPreferredWidth;
    protected boolean myPaintingNow;

    public ComboBox() {
        this.init(-1);
    }

    public ComboBox(int width) {
        this.init(width);
    }

    public ComboBox(@NotNull ComboBoxModel<E> model) {
        if (model == null) {
            ComboBox.$$$reportNull$$$0(0);
        }
        super(model);
        this.init(-1);
    }

    public ComboBox(E @NotNull [] items) {
        if (items == null) {
            ComboBox.$$$reportNull$$$0(1);
        }
        super(items);
        this.init(-1);
    }

    public ComboBox(E @NotNull [] items, int width) {
        if (items == null) {
            ComboBox.$$$reportNull$$$0(2);
        }
        super(items);
        this.init(width);
    }

    public ComboBox(@NotNull ComboBoxModel<E> model, int width) {
        if (model == null) {
            ComboBox.$$$reportNull$$$0(3);
        }
        super(model);
        this.init(width);
    }

    private void init(int width) {
        this.myMinimumAndPreferredWidth = width;
        this.registerCancelOnEscape();
        ComboBox.installComboBoxCopyAction(this);
    }

    private static void installComboBoxCopyAction(@NotNull JComboBox comboBox2) {
        ComboBoxEditor editor;
        Component editorComponent;
        if (comboBox2 == null) {
            ComboBox.$$$reportNull$$$0(4);
        }
        Component component2 = editorComponent = (editor = comboBox2.getEditor()) != null ? editor.getEditorComponent() : null;
        if (!(editorComponent instanceof JTextComponent)) {
            return;
        }
        InputMap inputMap = ((JTextComponent)editorComponent).getInputMap();
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            if (!"copy-to-clipboard".equals(inputMap.get(keyStroke))) continue;
            comboBox2.getInputMap().put(keyStroke, "copy-to-clipboard");
        }
        comboBox2.getActionMap().put("copy-to-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str;
                Component component2;
                if (!(e.getSource() instanceof JComboBox)) {
                    return;
                }
                JComboBox comboBox2 = (JComboBox)e.getSource();
                Object selectedItem = comboBox2.getSelectedItem();
                String text2 = selectedItem instanceof String ? (String)selectedItem : ((component2 = comboBox2.getRenderer().getListCellRendererComponent(new JList(), selectedItem, 0, false, false)) instanceof JLabel ? ((JLabel)component2).getText() : (component2 != null ? ((str = component2.toString()) == null || str.startsWith(component2.getClass().getName() + "[") ? null : str) : null));
                if (text2 != null) {
                    JTextField textField2 = new JTextField(text2);
                    textField2.selectAll();
                    textField2.copy();
                }
            }
        });
    }

    public static void registerTableCellEditor(@NotNull JComboBox comboBox2, @NotNull TableCellEditor cellEditor) {
        if (comboBox2 == null) {
            ComboBox.$$$reportNull$$$0(5);
        }
        if (cellEditor == null) {
            ComboBox.$$$reportNull$$$0(6);
        }
        comboBox2.putClientProperty(TABLE_CELL_EDITOR_PROPERTY, cellEditor);
        comboBox2.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public void registerTableCellEditor(@NotNull TableCellEditor cellEditor) {
        if (cellEditor == null) {
            ComboBox.$$$reportNull$$$0(7);
        }
        ComboBox.registerTableCellEditor(this, cellEditor);
    }

    @Override
    public void setPopupVisible(boolean visible) {
        JBPopupFactory jbPopupFactory;
        if (this.getModel().getSize() == 0 && visible) {
            return;
        }
        if (visible && (jbPopupFactory = ComboBox.getPopupFactory()) != null && jbPopupFactory.getChildFocusedPopup(this) != null) {
            return;
        }
        boolean wasShown = this.isPopupVisible();
        super.setPopupVisible(visible);
        if (!wasShown && visible && this.isEditable() && !UIManager.getBoolean("ComboBox.isEnterSelectablePopup")) {
            ComboBoxEditor editor = this.getEditor();
            Object item = editor.getItem();
            Object selectedItem = this.getSelectedItem();
            if (item == null || item != selectedItem) {
                this.configureEditor(editor, selectedItem);
            }
        }
    }

    @Nullable
    private static JBPopupFactory getPopupFactory() {
        if (ApplicationManager.getApplication() == null) {
            return null;
        }
        return JBPopupFactory.getInstance();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() != 200) {
            return;
        }
        JBPopupFactory jbPopupFactory = ComboBox.getPopupFactory();
        if (jbPopupFactory == null) {
            return;
        }
        WindowEvent we = (WindowEvent)event;
        for (JBPopup each : jbPopupFactory.getChildPopups(this)) {
            if (each.isDisposed() || !SwingUtilities.isDescendingFrom(each.getContent(), we.getWindow())) continue;
            super.setPopupVisible(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JTable) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Nullable
    public ComboPopup getPopup() {
        return UIUtil.getComboBoxPopup(this);
    }

    public void setSwingPopup(boolean swingPopup) {
        this.putClientProperty("ComboBox.jbPopup", swingPopup ? null : Boolean.valueOf(true));
        super.setEditor(null);
        this.updateUI();
    }

    public boolean isSwingPopup() {
        return this.getClientProperty("ComboBox.jbPopup") == null;
    }

    @Override
    public void setKeySelectionManager(JComboBox.KeySelectionManager aManager) {
        super.setKeySelectionManager(aManager == null || this.isSwingPopup() ? aManager : new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                ComboBox.this.showPopup();
                return -1;
            }
        });
    }

    public void setMinimumAndPreferredWidth(int minimumAndPreferredWidth) {
        this.myMinimumAndPreferredWidth = minimumAndPreferredWidth;
    }

    private void registerCancelOnEscape() {
        this.registerKeyboardAction(e -> {
            DialogWrapper dialogWrapper2 = DialogWrapper.findInstance(this);
            if (this.isPopupVisible()) {
                this.setPopupVisible(false);
            } else {
                Object clientProperty = this.getClientProperty(TABLE_CELL_EDITOR_PROPERTY);
                if (clientProperty instanceof CellEditor) {
                    ((CellEditor)clientProperty).cancelCellEditing();
                } else if (dialogWrapper2 != null) {
                    dialogWrapper2.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    @Override
    public final void setEditor(ComboBoxEditor editor) {
        super.setEditor(new MyEditor(this, editor));
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.myMinimumAndPreferredWidth;
        Dimension preferredSize = super.getPreferredSize();
        if (width < 0) {
            width = preferredSize.width;
        }
        return new Dimension(width, preferredSize.height);
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.myPaintingNow = true;
            super.paint(g);
        }
        finally {
            this.myPaintingNow = false;
        }
    }

    @ApiStatus.Experimental
    public void initBrowsableEditor(final @NotNull Runnable browseAction, final @Nullable Disposable parentDisposable) {
        if (browseAction == null) {
            ComboBox.$$$reportNull$$$0(8);
        }
        BasicComboBoxEditor editor = new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                ExtendableTextField editor = new ExtendableTextField().addBrowseExtension(browseAction, parentDisposable);
                editor.setBorder(null);
                return editor;
            }
        };
        this.setEditor(editor);
        this.setEditable(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellEditor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browseAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/ComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installComboBoxCopyAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTableCellEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initBrowsableEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyEditor
    implements ComboBoxEditor {
        private final JComboBox myComboBox;
        private final ComboBoxEditor myDelegate;

        MyEditor(JComboBox comboBox2, ComboBoxEditor delegate) {
            this.myComboBox = comboBox2;
            this.myDelegate = delegate;
            if (this.myDelegate != null) {
                this.myDelegate.addActionListener(e -> {
                    if (this.myComboBox.isPopupVisible()) {
                        this.myComboBox.setPopupVisible(false);
                    } else {
                        Object clientProperty = this.myComboBox.getClientProperty(ComboBox.TABLE_CELL_EDITOR_PROPERTY);
                        if (clientProperty instanceof CellEditor) {
                            ((CellEditor)clientProperty).stopCellEditing();
                        } else {
                            JButton button2;
                            this.myComboBox.setSelectedItem(this.getItem());
                            JRootPane rootPane = this.myComboBox.getRootPane();
                            if (rootPane != null && (button2 = rootPane.getDefaultButton()) != null) {
                                button2.doClick();
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return this.myDelegate == null ? null : this.myDelegate.getEditorComponent();
        }

        @Override
        public Object getItem() {
            return this.myDelegate == null ? null : this.myDelegate.getItem();
        }

        @Override
        public void selectAll() {
            if (this.myDelegate != null) {
                this.myDelegate.selectAll();
            }
        }

        @Override
        public void setItem(Object obj) {
            if (this.myDelegate != null) {
                this.myDelegate.setItem(obj);
            }
        }
    }
}

