/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxTableRenderer<T>
extends JLabel
implements TableCellRenderer,
TableCellEditor,
JBPopupListener {
    private final T[] myValues;
    private WeakReference<ListPopup> myPopupRef;
    private ChangeEvent myChangeEvent = null;
    private T myValue;
    private int myClickCount = 2;
    protected EventListenerList myListenerList = new EventListenerList();
    private Runnable myFinalRunnable;

    public ComboBoxTableRenderer(T[] values2) {
        this.myValues = values2;
        this.setFont(UIUtil.getButtonFont());
        this.setBorder(JBUI.Borders.empty(0, 5));
    }

    public ComboBoxTableRenderer withClickCount(int clickCount) {
        this.myClickCount = clickCount;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
        if (this.myValues != null) {
            String oldText = this.getText();
            Icon oldIcon = this.getIcon();
            for (T v : this.myValues) {
                this.setText(this.getTextFor(v));
                this.setIcon(this.getIconFor(v));
                Dimension vSize = ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
                size.width = Math.max(size.width, vSize.width);
                size.height = Math.max(size.height, vSize.height);
            }
            this.setText(oldText);
            this.setIcon(oldIcon);
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private static Dimension addIconSize(Dimension d) {
        return new Dimension(d.width + AllIcons.General.ArrowDown.getIconWidth() + JBUIScale.scale(2), Math.max(d.height, AllIcons.General.ArrowDown.getIconHeight()));
    }

    protected String getTextFor(@NotNull T value2) {
        if (value2 == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(0);
        }
        return value2.toString();
    }

    protected Icon getIconFor(@NotNull T value2) {
        if (value2 == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(1);
        }
        return null;
    }

    protected ListSeparator getSeparatorAbove(T value2) {
        return null;
    }

    protected Runnable onChosen(@NotNull T value2) {
        if (value2 == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(2);
        }
        this.stopCellEditing(value2);
        return () -> this.stopCellEditing(value2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!StringUtil.isEmpty(this.getText())) {
            Rectangle r = this.getBounds();
            Insets i = this.getInsets();
            int x = r.width - i.right - AllIcons.General.ArrowDown.getIconWidth();
            int y = i.top + (r.height - i.top - i.bottom - AllIcons.General.ArrowDown.getIconHeight()) / 2;
            AllIcons.General.ArrowDown.paintIcon(this, g, x, y);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Object t = value2;
        this.customizeComponent(t, table, isSelected);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        Object t = value2;
        this.myValue = t;
        this.customizeComponent(t, table, true);
        SwingUtilities.invokeLater(() -> this.showPopup(t, row));
        return this;
    }

    protected boolean isApplicable(T value2, int row) {
        return true;
    }

    private void showPopup(T value2, int row) {
        List<Object> filtered2 = ContainerUtil.findAll(this.myValues, t -> this.isApplicable(t, row));
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup(new ListStep<T>(filtered2, value2){

            @Override
            @NotNull
            public String getTextFor(T value2) {
                String string = ComboBoxTableRenderer.this.getTextFor(value2);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public Icon getIconFor(T value2) {
                return ComboBoxTableRenderer.this.getIconFor(value2);
            }

            @Override
            @Nullable
            public ListSeparator getSeparatorAbove(T value2) {
                return ComboBoxTableRenderer.this.getSeparatorAbove(value2);
            }

            public PopupStep onChosen(T selectedValue, boolean finalChoice) {
                ComboBoxTableRenderer.this.myFinalRunnable = ComboBoxTableRenderer.this.onChosen(selectedValue);
                return FINAL_CHOICE;
            }

            public void canceled() {
                ComboBoxTableRenderer.this.cancelCellEditing();
            }

            public Runnable getFinalRunnable() {
                return ComboBoxTableRenderer.this.myFinalRunnable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ComboBoxTableRenderer$1", "getTextFor"));
            }
        });
        popup2.addListener(this);
        popup2.setRequestFocus(false);
        this.myPopupRef = new WeakReference<ListPopup>(popup2);
        popup2.showUnderneathOf(this);
    }

    @Override
    public void beforeShown(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void onClosed(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(4);
        }
        event.asPopup().removeListener(this);
        this.fireEditingCanceled();
    }

    protected void customizeComponent(T value2, JTable table, boolean isSelected) {
        this.setOpaque(true);
        this.setText(value2 == null ? "" : this.getTextFor(value2));
        this.setIcon(value2 == null ? null : this.getIconFor(value2));
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
    }

    @Override
    public Object getCellEditorValue() {
        return this.myValue;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= this.myClickCount;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    private void stopCellEditing(T value2) {
        this.myValue = value2;
        this.stopCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.hidePopup();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.hidePopup();
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.myListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.myChangeEvent == null) {
                this.myChangeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.myChangeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.myListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.myChangeEvent == null) {
                this.myChangeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.myChangeEvent);
        }
    }

    private void hidePopup() {
        if (this.myPopupRef != null) {
            ListPopup popup2 = (ListPopup)this.myPopupRef.get();
            if (popup2 != null && popup2.isVisible()) {
                popup2.cancel();
            }
            this.myPopupRef = null;
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myListenerList.remove(CellEditorListener.class, l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/ComboBoxTableRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onChosen";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeShown";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class ListStep<T>
    implements ListPopupStep<T>,
    SpeedSearchFilter<T> {
        private final List<T> myValues;
        private final T mySelected;

        protected ListStep(List<T> values2, T selected2) {
            this.myValues = values2;
            this.mySelected = selected2;
        }

        public String getTitle() {
            return null;
        }

        public boolean hasSubstep(T selectedValue) {
            return false;
        }

        public boolean isMnemonicsNavigationEnabled() {
            return false;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @Override
        @NotNull
        public List<T> getValues() {
            List<T> list2 = this.myValues;
            if (list2 == null) {
                ListStep.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        public boolean isSelectable(T value2) {
            return true;
        }

        @Override
        public Icon getIconFor(T aValue) {
            return null;
        }

        @Override
        public int getDefaultOptionIndex() {
            return this.mySelected == null ? 0 : this.myValues.indexOf(this.mySelected);
        }

        public MnemonicNavigationFilter<T> getMnemonicNavigationFilter() {
            return null;
        }

        public SpeedSearchFilter<T> getSpeedSearchFilter() {
            return this;
        }

        public String getIndexedString(T value2) {
            return this.getTextFor(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ComboBoxTableRenderer$ListStep", "getValues"));
        }
    }
}

