/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWithBrowseButton<Comp extends JComponent>
extends JPanel
implements Disposable {
    private final Comp myComponent;
    private final FixedSizeButton myBrowseButton;
    private boolean myButtonEnabled;
    private KeyEvent myCurrentEvent;

    @ApiStatus.Internal
    public static boolean isUseInlineBrowserButton() {
        return !LoadingState.COMPONENTS_REGISTERED.isOccurred() || Experiments.getInstance().isFeatureEnabled("inline.browse.button");
    }

    public ComponentWithBrowseButton(@NotNull Comp component2, @Nullable ActionListener browseActionListener) {
        boolean inlineBrowseButton;
        if (component2 == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(0);
        }
        super(new BorderLayout(SystemInfo.isMac || StartupUiUtil.isUnderDarcula() ? 0 : 2, 0));
        this.myButtonEnabled = true;
        this.myCurrentEvent = null;
        this.myComponent = component2;
        this.setFocusable(false);
        boolean bl = inlineBrowseButton = this.myComponent instanceof ExtendableTextComponent && ComponentWithBrowseButton.isUseInlineBrowserButton();
        if (inlineBrowseButton) {
            ((ExtendableTextComponent)this.myComponent).addExtension(ExtendableTextComponent.Extension.create(this.getDefaultIcon(), this.getHoveredIcon(), this.getIconTooltip(), this::notifyActionListeners));
            new DumbAwareAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ComponentWithBrowseButton.this.notifyActionListeners();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ComponentWithBrowseButton$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)this.myComponent);
        }
        this.add((Component)this.myComponent, "Center");
        this.myBrowseButton = new FixedSizeButton((JComponent)this.myComponent);
        if (browseActionListener != null) {
            this.myBrowseButton.addActionListener(browseActionListener);
        }
        if (!inlineBrowseButton) {
            this.add((Component)this.myBrowseButton, "East");
        }
        this.myBrowseButton.setToolTipText(this.getIconTooltip());
        if (ApplicationManager.getApplication() != null) {
            new MyDoClickAction(this.myBrowseButton).registerShortcut((JComponent)this.myComponent);
        }
        if (ScreenReader.isActive()) {
            this.myBrowseButton.setFocusable(true);
            this.myBrowseButton.getAccessibleContext().setAccessibleName("Browse");
        }
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon2 = AllIcons.General.OpenDisk;
        if (icon2 == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        Icon icon2 = AllIcons.General.OpenDiskHover;
        if (icon2 == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(2);
        }
        return icon2;
    }

    @NotNull
    protected String getIconTooltip() {
        String string = UIBundle.message("component.with.browse.button.browse.button.tooltip.text", new Object[0]) + " (" + KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(10, 64)) + ")";
        if (string == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void notifyActionListeners() {
        ActionEvent event = new ActionEvent(this.myComponent, 1001, "action");
        for (ActionListener listener2 : this.myBrowseButton.getActionListeners()) {
            listener2.actionPerformed(event);
        }
    }

    @NotNull
    public final Comp getChildComponent() {
        Comp Comp = this.myComponent;
        if (Comp == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(4);
        }
        return Comp;
    }

    public void setTextFieldPreferredWidth(int charCount) {
        Comp comp = this.getChildComponent();
        Dimension size = GuiUtils.getSizeByChars(charCount, comp);
        ((JComponent)comp).setPreferredSize(size);
        Dimension preferredSize = this.myBrowseButton.getPreferredSize();
        boolean keepHeight = UIUtil.isUnderWin10LookAndFeel();
        preferredSize.setSize(size.width + preferredSize.width + 2, keepHeight ? preferredSize.height : preferredSize.height + 2);
        this.setPreferredSize(preferredSize);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBrowseButton.setEnabled(enabled && this.myButtonEnabled);
        ((JComponent)this.myComponent).setEnabled(enabled);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.myButtonEnabled = buttonEnabled;
        this.setEnabled(this.isEnabled());
    }

    public void setButtonIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(5);
        }
        this.myBrowseButton.setIcon(icon2);
        this.myBrowseButton.setDisabledIcon(IconLoader.getDisabledIcon(icon2));
    }

    public void addActionListener(ActionListener listener2) {
        this.myBrowseButton.addActionListener(listener2);
    }

    public void removeActionListener(ActionListener listener2) {
        this.myBrowseButton.removeActionListener(listener2);
    }

    public void addBrowseFolderListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project2, FileChooserDescriptor fileChooserDescriptor2, TextComponentAccessor<? super Comp> accessor) {
        this.addActionListener(new BrowseFolderActionListener<Comp>(title, description, this, project2, fileChooserDescriptor2, accessor));
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project2, FileChooserDescriptor fileChooserDescriptor2, TextComponentAccessor<? super Comp> accessor, boolean autoRemoveOnHide) {
        this.addBrowseFolderListener(title, description, project2, fileChooserDescriptor2, accessor);
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable Project project2, BrowseFolderActionListener<Comp> actionListener) {
        this.addActionListener(actionListener);
    }

    @Override
    public void dispose() {
        ActionListener[] listeners;
        for (ActionListener listener2 : listeners = this.myBrowseButton.getActionListeners()) {
            this.myBrowseButton.removeActionListener(listener2);
        }
    }

    public FixedSizeButton getButton() {
        return this.myBrowseButton;
    }

    @Override
    public final void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myComponent, true));
    }

    @Override
    public final void setNextFocusableComponent(Component aComponent) {
        super.setNextFocusableComponent(aComponent);
        ((JComponent)this.myComponent).setNextFocusableComponent(aComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition2, boolean pressed) {
        if (condition2 == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                ((Component)this.myComponent).dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition2, pressed);
    }

    @Deprecated
    public void addBrowseFolderListener(@Nullable Project project2, BrowseFolderActionListener<Comp> actionListener, boolean autoRemoveOnHide) {
        this.addActionListener(actionListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/ComponentWithBrowseButton";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/ComponentWithBrowseButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setButtonIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BrowseFolderActionListener<T extends JComponent>
    extends BrowseFolderRunnable<T>
    implements ActionListener {
        public BrowseFolderActionListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable ComponentWithBrowseButton<T> textField2, @Nullable Project project2, FileChooserDescriptor fileChooserDescriptor2, TextComponentAccessor<? super T> accessor) {
            super(title, description, project2, fileChooserDescriptor2, textField2 != null ? (Object)textField2.getChildComponent() : null, accessor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    public static final class MyDoClickAction
    extends DumbAwareAction {
        private final FixedSizeButton myBrowseButton;

        public MyDoClickAction(FixedSizeButton browseButton) {
            this.myBrowseButton = browseButton;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDoClickAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(this.myBrowseButton.isVisible() && this.myBrowseButton.isEnabled());
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDoClickAction.$$$reportNull$$$0(1);
            }
            this.myBrowseButton.doClick();
        }

        public void registerShortcut(JComponent textField2) {
            CustomShortcutSet shiftEnter = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64));
            this.registerCustomShortcutSet(shiftEnter, textField2);
            this.myBrowseButton.setToolTipText(KeymapUtil.getShortcutsText(shiftEnter.getShortcuts()));
        }

        public static void addTo(FixedSizeButton browseButton, JComponent aComponent) {
            new MyDoClickAction(browseButton).registerShortcut(aComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/ui/ComponentWithBrowseButton$MyDoClickAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

