/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Banner;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;

public class DetailsComponent {
    private final JPanel myComponent;
    private JComponent myContent;
    private final Banner myBannerLabel;
    private final JLabel myEmptyContentLabel;
    private final NonOpaquePanel myBanner;
    private String[] myBannerText;
    private boolean myDetailsEnabled;
    private String[] myPrefix;
    private String[] myText;
    private final Wrapper myContentGutter = new Wrapper();
    private boolean myPaintBorder;

    public DetailsComponent() {
        this(true, true);
    }

    public DetailsComponent(boolean detailsEnabled, boolean paintBorder2) {
        this.myDetailsEnabled = detailsEnabled;
        this.myPaintBorder = paintBorder2;
        this.myComponent = new NonOpaquePanel(new BorderLayout());
        this.myComponent.setOpaque(false);
        this.myContentGutter.setOpaque(false);
        this.myContentGutter.setBorder(null);
        this.myBanner = new NonOpaquePanel(new BorderLayout());
        this.myBannerLabel = new Banner();
        if (this.myDetailsEnabled) {
            this.myBanner.add((Component)this.myBannerLabel, "Center");
        }
        this.myEmptyContentLabel = new JLabel("", 0);
        this.revalidateDetailsMode();
    }

    private void revalidateDetailsMode() {
        this.myComponent.removeAll();
        this.myComponent.add((Component)this.myContentGutter, "Center");
        if (this.myDetailsEnabled) {
            this.myComponent.add((Component)this.myBanner, "North");
        }
        if (this.myContent != null) {
            this.myContentGutter.add((Component)this.myContent, "Center");
            this.invalidateContentBorder();
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setBannerActions(Action[] actions) {
        this.myBannerLabel.clearActions();
        for (Action each : actions) {
            this.myBannerLabel.addAction(each);
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setContent(@Nullable JComponent c) {
        if (this.myContent != null) {
            this.myContentGutter.remove(this.myContent);
        }
        this.myContent = new MyWrapper(c);
        this.myContent.setOpaque(false);
        this.invalidateContentBorder();
        this.myContentGutter.add((Component)this.myContent, "Center");
        this.updateBanner();
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    private void invalidateContentBorder() {
        if (this.myDetailsEnabled) {
            this.myContent.setBorder(new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        } else {
            this.myContent.setBorder(null);
        }
    }

    public void forProject(Project project2) {
        this.myBannerLabel.forProject(project2);
    }

    public void setPrefix(String ... prefix) {
        this.myPrefix = prefix;
        if (this.myText != null) {
            this.setText(this.myText);
        }
    }

    public void setText(String ... text2) {
        this.myText = text2;
        this.update();
    }

    public void update() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.myPrefix != null) {
            ContainerUtil.addAll(strings, this.myPrefix);
        }
        if (this.myText != null) {
            ContainerUtil.addAll(strings, this.myText);
        }
        this.myBannerText = ArrayUtilRt.toStringArray(strings);
        this.updateBanner();
    }

    private void updateBanner() {
        this.myBannerLabel.setText(NullableComponent.Check.isNull(this.myContent) || this.myBannerText == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : this.myBannerText);
        this.myBannerLabel.revalidate();
        this.myBannerLabel.repaint();
    }

    public void setPaintBorder(boolean paintBorder2) {
        this.myPaintBorder = paintBorder2;
    }

    public DetailsComponent setEmptyContentText(@Nullable String emptyContentText) {
        String s = XmlStringUtil.wrapInHtml("<center>" + (emptyContentText != null ? emptyContentText : "") + "</center>");
        this.myEmptyContentLabel.setText(s);
        return this;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getContentGutter() {
        return this.myContentGutter;
    }

    public void setBannerMinHeight(int height) {
        this.myBannerLabel.setMinHeight(height);
    }

    public void disposeUIResources() {
        this.setContent(null);
    }

    public void updateBannerActions() {
        this.myBannerLabel.updateActions();
    }

    public void setDetailsModeEnabled(boolean enabled) {
        if (this.myDetailsEnabled == enabled) {
            return;
        }
        this.myDetailsEnabled = enabled;
        this.revalidateDetailsMode();
    }

    private class MyWrapper
    extends Wrapper
    implements NullableComponent {
        MyWrapper(JComponent c) {
            super(c == null || NullableComponent.Check.isNull(c) ? DetailsComponent.this.myEmptyContentLabel : c);
        }

        @Override
        public boolean isNull() {
            return this.getTargetComponent() == DetailsComponent.this.myEmptyContentLabel;
        }
    }

    public static interface Facade {
        public DetailsComponent getDetailsComponent();
    }
}

