/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MacOtherAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DialogWrapper {
    private static final Logger LOG = Logger.getInstance(DialogWrapper.class);
    @ApiStatus.Internal
    @NotNull
    public static final String IS_VISUAL_PADDING_COMPENSATED_ON_COMPONENT_LEVEL_KEY = "isVisualPaddingCompensatedOnComponentLevel";
    public static final int OK_EXIT_CODE = 0;
    public static final int CANCEL_EXIT_CODE = 1;
    public static final int CLOSE_EXIT_CODE = 1;
    public static final int NEXT_USER_EXIT_CODE = 2;
    public static final String DEFAULT_ACTION = "DefaultAction";
    public static final String FOCUSED_ACTION = "FocusedAction";
    public static final Object DIALOG_CONTENT_PANEL_PROPERTY = new Object();
    public static final Color ERROR_FOREGROUND_COLOR = JBColor.namedColor("Label.errorForeground", new JBColor(new Color(13050413), JBColor.RED));
    private static final String NO_AUTO_RESIZE = "NoAutoResizeAndFit";
    @NotNull
    protected final Disposable myDisposable;
    @NotNull
    private final DialogWrapperPeer myPeer;
    private final Map<Action, JButton> myButtonMap;
    private final boolean myCreateSouthSection;
    private final List<JBOptionButton> myOptionsButtons;
    private final List<Function0<ValidationInfo>> myValidateCallbacks;
    private final Alarm myValidationAlarm;
    private final Alarm myErrorTextAlarm;
    private boolean myClosed;
    private boolean myDisposed;
    private int myExitCode;
    private float myHorizontalStretch;
    private float myVerticalStretch;
    private int myButtonAlignment;
    private boolean myCrossClosesWindow;
    private JComponent myPreferredFocusedComponentFromPanel;
    private Computable<? extends Point> myInitialLocationCallback;
    private Dimension myActualSize;
    @NotNull
    private List<ValidationInfo> myInfo;
    @Nullable
    private DoNotAskOption myDoNotAsk;
    private Action myYesAction;
    private Action myNoAction;
    private int myCurrentOptionsButtonIndex;
    private boolean myResizeInProgress;
    private ComponentAdapter myResizeListener;
    private DialogPanel myDialogPanel;
    private ErrorText myErrorText;
    private int myValidationDelay;
    private boolean myValidationStarted;
    private final ErrorPainter myErrorPainter;
    private boolean myErrorPainterInstalled;
    protected Action myOKAction;
    protected Action myCancelAction;
    protected Action myHelpAction;
    protected boolean myPerformAction;
    protected JCheckBox myCheckBoxDoNotShowDialog;
    protected JComponent myPreferredFocusedComponent;
    private static final JBValue BASE_BUTTON_GAP = new JBValue.Float(UIUtil.isUnderWin10LookAndFeel() ? 8.0f : 12.0f);
    private final PropertyChangeListener myRepaintOnNameChangeListener;

    @NotNull
    public static Border createDefaultBorder() {
        return new JBEmptyBorder(UIUtil.getRegularPanelInsets());
    }

    protected DialogWrapper(@Nullable Project project2, boolean canBeParent) {
        this(project2, canBeParent, IdeModalityType.IDE);
    }

    protected DialogWrapper(@Nullable Project project2, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(0);
        }
        this(project2, null, canBeParent, ideModalityType);
    }

    protected DialogWrapper(@Nullable Project project2, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(1);
        }
        this(project2, parentComponent, canBeParent, ideModalityType, true);
    }

    protected DialogWrapper(@Nullable Project project2, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType, boolean createSouth) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(2);
        }
        this.myDisposable = new Disposable(){

            public String toString() {
                return DialogWrapper.this.toString();
            }

            @Override
            public void dispose() {
                DialogWrapper.this.dispose();
            }
        };
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myValidateCallbacks = new ArrayList<Function0<ValidationInfo>>();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myErrorTextAlarm = new Alarm();
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myInfo = Collections.emptyList();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.myErrorPainter = new ErrorPainter();
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        this.myPeer = parentComponent == null ? this.createPeer(project2, canBeParent, project2 == null ? IdeModalityType.IDE : ideModalityType) : this.createPeer(parentComponent, canBeParent);
        this.myCreateSouthSection = createSouth;
        Window window = this.myPeer.getWindow();
        if (window != null) {
            this.myResizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!DialogWrapper.this.myResizeInProgress) {
                        DialogWrapper.this.myActualSize = DialogWrapper.this.myPeer.getSize();
                        if (DialogWrapper.this.myErrorText != null && DialogWrapper.this.myErrorText.isVisible()) {
                            ((DialogWrapper)DialogWrapper.this).myActualSize.height -= ((DialogWrapper)DialogWrapper.this).myErrorText.getMinimumSize().height;
                        }
                    }
                }
            };
            window.addComponentListener(this.myResizeListener);
        }
        this.createDefaultActions();
    }

    protected DialogWrapper(@Nullable Project project2) {
        this(project2, true);
    }

    protected DialogWrapper(boolean canBeParent) {
        this((Project)null, canBeParent);
    }

    @Deprecated
    protected DialogWrapper(boolean canBeParent, boolean applicationModalIfPossible) {
        this(null, canBeParent, applicationModalIfPossible);
    }

    protected DialogWrapper(Project project2, boolean canBeParent, boolean applicationModalIfPossible) {
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myValidateCallbacks = new ArrayList<Function0<ValidationInfo>>();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myErrorTextAlarm = new Alarm();
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myInfo = Collections.emptyList();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.myErrorPainter = new ErrorPainter();
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        DialogWrapper.ensureEventDispatchThread();
        Window owner = null;
        if (ApplicationManager.getApplication() != null) {
            owner = project2 != null ? WindowManager.getInstance().suggestParentWindow(project2) : WindowManager.getInstance().findVisibleFrame();
        }
        this.myPeer = this.createPeer(owner, canBeParent, applicationModalIfPossible);
        this.myCreateSouthSection = true;
        this.createDefaultActions();
    }

    protected DialogWrapper(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            DialogWrapper.$$$reportNull$$$0(3);
        }
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.myOptionsButtons = new ArrayList<JBOptionButton>();
        this.myValidateCallbacks = new ArrayList<Function0<ValidationInfo>>();
        this.myValidationAlarm = new Alarm(this.getValidationThreadToUse(), this.myDisposable);
        this.myErrorTextAlarm = new Alarm();
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myInfo = Collections.emptyList();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.myErrorPainter = new ErrorPainter();
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        DialogWrapper.ensureEventDispatchThread();
        this.myCreateSouthSection = true;
        this.myPeer = this.createPeer(parent, canBeParent);
        this.createDefaultActions();
    }

    @NotNull
    protected String getDoNotShowMessage() {
        String string = UIBundle.message("dialog.options.do.not.show", new Object[0]);
        if (string == null) {
            DialogWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setDoNotAskOption(@Nullable DoNotAskOption doNotAsk) {
        this.myDoNotAsk = doNotAsk;
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        if (threadToUse == null) {
            DialogWrapper.$$$reportNull$$$0(5);
        }
        return threadToUse;
    }

    protected boolean postponeValidation() {
        return true;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return null;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo vi = this.doValidate();
        if (!this.myValidateCallbacks.isEmpty()) {
            ArrayList<ValidationInfo> result2 = new ArrayList<ValidationInfo>();
            if (vi != null) {
                result2.add(vi);
            }
            for (Function0<ValidationInfo> callback2 : this.myValidateCallbacks) {
                ValidationInfo callbackInfo = (ValidationInfo)callback2.invoke();
                if (callbackInfo == null) continue;
                result2.add(callbackInfo);
            }
            ArrayList<ValidationInfo> arrayList = result2;
            if (arrayList == null) {
                DialogWrapper.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<ValidationInfo> list2 = vi != null ? Collections.singletonList(vi) : Collections.emptyList();
        if (list2 == null) {
            DialogWrapper.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public void setValidationDelay(int delay) {
        this.myValidationDelay = delay;
    }

    private void installErrorPainter() {
        if (this.myErrorPainterInstalled) {
            return;
        }
        this.myErrorPainterInstalled = true;
        UIUtil.invokeLaterIfNeeded(() -> IdeGlassPaneUtil.installPainter(this.getContentPanel(), this.myErrorPainter, this.myDisposable));
    }

    protected void updateErrorInfo(@NotNull List<ValidationInfo> info) {
        boolean updateNeeded;
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(8);
        }
        boolean bl = Registry.is("ide.inplace.validation.tooltip") ? !this.myInfo.equals(info) : (updateNeeded = !this.myErrorText.isTextSet(info));
        if (updateNeeded) {
            SwingUtilities.invokeLater(() -> {
                if (this.myDisposed) {
                    return;
                }
                this.setErrorInfoAll(info);
                this.myPeer.getRootPane().getGlassPane().repaint();
                this.getOKAction().setEnabled(info.isEmpty() || info.stream().allMatch(info1 -> info1.okEnabled));
            });
        }
    }

    protected void createDefaultActions() {
        this.myOKAction = new OkAction();
        this.myCancelAction = new CancelAction();
        this.myHelpAction = new HelpAction();
    }

    public void setUndecorated(boolean undecorated) {
        this.myPeer.setUndecorated(undecorated);
    }

    public final void addMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            DialogWrapper.$$$reportNull$$$0(9);
        }
        this.myPeer.addMouseListener(listener2);
    }

    public final void addMouseListener(@NotNull MouseMotionListener listener2) {
        if (listener2 == null) {
            DialogWrapper.$$$reportNull$$$0(10);
        }
        this.myPeer.addMouseListener(listener2);
    }

    public final void addKeyListener(@NotNull KeyListener listener2) {
        if (listener2 == null) {
            DialogWrapper.$$$reportNull$$$0(11);
        }
        this.myPeer.addKeyListener(listener2);
    }

    public final void close(int exitCode, boolean isOk) {
        DialogWrapper.ensureEventDispatchThread();
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myExitCode = exitCode;
        Window window = this.getWindow();
        if (window != null && this.myResizeListener != null) {
            window.removeComponentListener(this.myResizeListener);
            this.myResizeListener = null;
        }
        if (isOk) {
            this.processDoNotAskOnOk(exitCode);
        } else {
            this.processDoNotAskOnCancel();
        }
        Disposer.dispose(this.myDisposable);
    }

    public final void close(int exitCode) {
        this.logCloseDialogEvent(exitCode);
        this.close(exitCode, exitCode != 1);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        if (this.getStyle() == DialogStyle.COMPACT) {
            return JBUI.Borders.empty();
        }
        return DialogWrapper.createDefaultBorder();
    }

    protected static boolean isMoveHelpButtonLeft() {
        return true;
    }

    private static boolean isRemoveHelpButton() {
        return !ApplicationInfo.contextHelpAvailable() || Registry.is("ide.remove.help.button.from.dialogs");
    }

    protected JComponent createSouthPanel() {
        List<Action> actions = ContainerUtil.filter(this.createActions(), Conditions.notNull());
        List<Action> leftSideActions = ContainerUtil.filter(this.createLeftSideActions(), Conditions.notNull());
        Action helpAction = this.getHelpAction();
        boolean addHelpToLeftSide = false;
        if (DialogWrapper.isRemoveHelpButton()) {
            actions.remove(helpAction);
        } else if (!actions.contains(helpAction) && this.getHelpId() == null) {
            helpAction.setEnabled(false);
        } else if (DialogWrapper.isMoveHelpButtonLeft() && actions.remove(helpAction) && !leftSideActions.contains(helpAction)) {
            addHelpToLeftSide = true;
        }
        if (SystemInfo.isMac) {
            int cancelNdx;
            int okNdx;
            Action macOtherAction = (Action)((Object)ContainerUtil.find(actions, MacOtherAction.class::isInstance));
            if (macOtherAction != null) {
                leftSideActions.add(macOtherAction);
                actions.remove(macOtherAction);
            }
            if ((okNdx = actions.indexOf(this.getOKAction())) >= 0 && okNdx != actions.size() - 1) {
                actions.remove(this.getOKAction());
                actions.add(this.getOKAction());
            }
            if ((cancelNdx = actions.indexOf(this.getCancelAction())) > 0) {
                actions.remove(this.getCancelAction());
                actions.add(okNdx < 0 ? 0 : actions.size() - 1, this.getCancelAction());
            }
        }
        if (!UISettings.getShadowInstance().getAllowMergeButtons()) {
            actions = DialogWrapper.flattenOptionsActions(actions);
            leftSideActions = DialogWrapper.flattenOptionsActions(leftSideActions);
        }
        List<JButton> leftSideButtons = this.createButtons(leftSideActions);
        List<JButton> rightSideButtons = this.createButtons(actions);
        this.myButtonMap.clear();
        int index = 0;
        for (JButton button2 : ContainerUtil.concat(leftSideButtons, rightSideButtons)) {
            this.myButtonMap.put(button2.getAction(), button2);
            if (button2 instanceof JBOptionButton) {
                this.myOptionsButtons.add((JBOptionButton)button2);
            }
            TouchbarDataKeys.putDialogButtonDescriptor(button2, index++).setMainGroup(index >= leftSideButtons.size());
        }
        return this.createSouthPanel(leftSideButtons, rightSideButtons, addHelpToLeftSide);
    }

    @NotNull
    protected JButton createHelpButton(@NotNull Insets insets) {
        if (insets == null) {
            DialogWrapper.$$$reportNull$$$0(12);
        }
        JButton helpButton = new JButton(this.getHelpAction());
        helpButton.putClientProperty("JButton.buttonType", "help");
        helpButton.setText("");
        helpButton.setMargin(insets);
        this.setHelpTooltip(helpButton);
        helpButton.addPropertyChangeListener("ancestor", evt -> {
            if (evt.getNewValue() == null) {
                HelpTooltip.dispose((JComponent)evt.getSource());
            }
        });
        JButton jButton = helpButton;
        if (jButton == null) {
            DialogWrapper.$$$reportNull$$$0(13);
        }
        return jButton;
    }

    protected void setHelpTooltip(@NotNull JButton helpButton) {
        if (helpButton == null) {
            DialogWrapper.$$$reportNull$$$0(14);
        }
        helpButton.setToolTipText(ActionsBundle.actionDescription("HelpTopics"));
    }

    @NotNull
    private static List<Action> flattenOptionsActions(@NotNull List<? extends Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(15);
        }
        ArrayList<Action> newActions = new ArrayList<Action>();
        for (Action action2 : actions) {
            newActions.add(action2);
            if (!(action2 instanceof OptionAction)) continue;
            ContainerUtil.addAll(newActions, ((OptionAction)action2).getOptions());
        }
        ArrayList<Action> arrayList = newActions;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    protected boolean shouldAddErrorNearButtons() {
        return false;
    }

    @NotNull
    protected DialogStyle getStyle() {
        DialogStyle dialogStyle = DialogStyle.NO_STYLE;
        if (dialogStyle == null) {
            DialogWrapper.$$$reportNull$$$0(17);
        }
        return dialogStyle;
    }

    protected boolean toBeShown() {
        return !this.myCheckBoxDoNotShowDialog.isSelected();
    }

    @Deprecated
    public boolean isTypeAheadEnabled() {
        return false;
    }

    @NotNull
    private List<JButton> createButtons(@NotNull List<? extends Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(18);
        }
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (Action action2 : actions) {
            buttons.add(this.createJButtonForAction(action2));
        }
        ArrayList<JButton> arrayList = buttons;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private JPanel createSouthPanel(@NotNull List<? extends JButton> leftSideButtons, @NotNull List<? extends JButton> rightSideButtons, boolean addHelpToLeftSide) {
        JBInsets insets;
        if (leftSideButtons == null) {
            DialogWrapper.$$$reportNull$$$0(20);
        }
        if (rightSideButtons == null) {
            DialogWrapper.$$$reportNull$$$0(21);
        }
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                Color bg = UIManager.getColor("DialogWrapper.southPanelBackground");
                if (DialogWrapper.this.getStyle() == DialogStyle.COMPACT && bg != null) {
                    return bg;
                }
                return super.getBackground();
            }
        };
        if (this.myDoNotAsk != null) {
            this.myCheckBoxDoNotShowDialog = new JCheckBox(this.myDoNotAsk.getDoNotShowMessage());
            this.myCheckBoxDoNotShowDialog.setVisible(this.myDoNotAsk.canBeHidden());
            this.myCheckBoxDoNotShowDialog.setSelected(!this.myDoNotAsk.isToBeShown());
            DialogUtil.registerMnemonic(this.myCheckBoxDoNotShowDialog, '&');
        }
        JComponent doNotAskCheckbox = this.createDoNotAskCheckbox();
        NonOpaquePanel lrButtonsPanel = new NonOpaquePanel(new GridBagLayout());
        JBInsets jBInsets = insets = SystemInfo.isMacOSLeopard && UIUtil.isUnderIntelliJLaF() ? JBInsets.create(0, 8) : JBUI.emptyInsets();
        if (!rightSideButtons.isEmpty() || !leftSideButtons.isEmpty()) {
            JPanel buttonsPanel;
            GridBag bag = new GridBag().setDefaultInsets(insets);
            if (!leftSideButtons.isEmpty()) {
                buttonsPanel = this.createButtonsPanel(leftSideButtons);
                if (!rightSideButtons.isEmpty()) {
                    buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            if (!rightSideButtons.isEmpty()) {
                buttonsPanel = this.createButtonsPanel(rightSideButtons);
                if (this.shouldAddErrorNearButtons()) {
                    lrButtonsPanel.add((Component)this.myErrorText, bag.next());
                    lrButtonsPanel.add(Box.createHorizontalStrut(10), bag.next());
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            if (0 == this.myButtonAlignment && doNotAskCheckbox == null) {
                lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            }
        }
        JButton helpButton = null;
        if (addHelpToLeftSide) {
            helpButton = this.createHelpButton(insets);
        }
        JPanel eastPanel = this.createSouthAdditionalPanel();
        if (helpButton != null || doNotAskCheckbox != null || eastPanel != null) {
            JPanel leftPanel = new JPanel(new BorderLayout());
            if (helpButton != null) {
                leftPanel.add((Component)helpButton, "West");
            }
            if (doNotAskCheckbox != null) {
                doNotAskCheckbox.setBorder(JBUI.Borders.emptyRight(20));
                leftPanel.add((Component)doNotAskCheckbox, "Center");
            }
            if (eastPanel != null) {
                leftPanel.add((Component)eastPanel, "East");
            }
            panel2.add((Component)leftPanel, "West");
        }
        panel2.add((Component)lrButtonsPanel, "Center");
        if (this.getStyle() == DialogStyle.COMPACT) {
            Color color = UIManager.getColor("DialogWrapper.southPanelDivider");
            CustomLineBorder line = new CustomLineBorder(color != null ? color : OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel2.setBorder(new CompoundBorder(line, JBUI.Borders.empty(8, 12)));
        } else {
            panel2.setBorder(JBUI.Borders.emptyTop(8));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DialogWrapper.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return this.myCheckBoxDoNotShowDialog != null && this.myCheckBoxDoNotShowDialog.isVisible() ? this.myCheckBoxDoNotShowDialog : null;
    }

    @NotNull
    protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
        if (buttons == null) {
            DialogWrapper.$$$reportNull$$$0(23);
        }
        return DialogWrapper.layoutButtonsPanel(buttons);
    }

    @NotNull
    public static JPanel layoutButtonsPanel(@NotNull List<? extends JButton> buttons) {
        if (buttons == null) {
            DialogWrapper.$$$reportNull$$$0(24);
        }
        NonOpaquePanel buttonsPanel = new NonOpaquePanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        for (int i = 0; i < buttons.size(); ++i) {
            JComponent button2 = buttons.get(i);
            Insets insets = button2.getInsets();
            buttonsPanel.add(button2);
            if (i >= buttons.size() - 1) continue;
            int gap = StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() ? BASE_BUTTON_GAP.get() - insets.left - insets.right : JBUIScale.scale(8);
            buttonsPanel.add(Box.createRigidArea(new Dimension(gap, 0)));
        }
        NonOpaquePanel nonOpaquePanel = buttonsPanel;
        if (nonOpaquePanel == null) {
            DialogWrapper.$$$reportNull$$$0(25);
        }
        return nonOpaquePanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return null;
    }

    @Nullable
    protected JButton getButton(@NotNull Action action2) {
        if (action2 == null) {
            DialogWrapper.$$$reportNull$$$0(26);
        }
        return this.myButtonMap.get(action2);
    }

    protected JButton createJButtonForAction(Action action2) {
        JButton button2 = DialogWrapper.createJButtonForAction(action2, this.getRootPane());
        int mnemonic = button2.getMnemonic();
        Object name = action2.getValue("Name");
        if (mnemonic == 89 && "Yes".equals(name)) {
            this.myYesAction = action2;
        } else if (mnemonic == 78 && "No".equals(name)) {
            this.myNoAction = action2;
        }
        if (action2.getValue(FOCUSED_ACTION) != null) {
            this.myPreferredFocusedComponent = button2;
        }
        return button2;
    }

    @NotNull
    public static JButton createJButtonForAction(@NotNull Action action2, @Nullable JRootPane rootPane) {
        if (action2 == null) {
            DialogWrapper.$$$reportNull$$$0(27);
        }
        JButton button2 = action2 instanceof OptionAction && UISettings.getShadowInstance().getAllowMergeButtons() ? DialogWrapper.createJOptionsButton((OptionAction)action2) : new JButton(action2);
        if (SystemInfo.isMac) {
            button2.putClientProperty("JButton.buttonType", "text");
        }
        Pair<Integer, String> pair = DialogWrapper.extractMnemonic(button2.getText());
        button2.setText((String)pair.second);
        int mnemonic = (Integer)pair.first;
        Object value2 = action2.getValue("MnemonicKey");
        if (value2 instanceof Integer) {
            mnemonic = (Integer)value2;
        }
        button2.setMnemonic(mnemonic);
        if (action2.getValue(DEFAULT_ACTION) != null && rootPane != null) {
            rootPane.setDefaultButton(button2);
        }
        JButton jButton = button2;
        if (jButton == null) {
            DialogWrapper.$$$reportNull$$$0(28);
        }
        return jButton;
    }

    @NotNull
    private static JButton createJOptionsButton(@NotNull OptionAction action2) {
        if (action2 == null) {
            DialogWrapper.$$$reportNull$$$0(29);
        }
        JBOptionButton optionButton = new JBOptionButton(action2, action2.getOptions());
        optionButton.setOptionTooltipText(JBOptionButton.getDefaultTooltip());
        optionButton.setOkToProcessDefaultMnemonics(false);
        JBOptionButton jBOptionButton = optionButton;
        if (jBOptionButton == null) {
            DialogWrapper.$$$reportNull$$$0(30);
        }
        return jBOptionButton;
    }

    @NotNull
    public static Pair<Integer, String> extractMnemonic(@Nullable String text2) {
        if (text2 == null) {
            Pair<Integer, Object> pair = Pair.pair(0, null);
            if (pair == null) {
                DialogWrapper.$$$reportNull$$$0(31);
            }
            return pair;
        }
        int mnemonic = 0;
        StringBuilder plainText = new StringBuilder();
        for (int i = 0; i < text2.length(); ++i) {
            int ch = text2.charAt(i);
            if (ch == 95 || ch == 38) {
                if (++i >= text2.length()) break;
                ch = text2.charAt(i);
                if (ch != 95 && ch != 38) {
                    int vk = ch;
                    if (vk >= 97 && vk <= 122) {
                        vk -= 32;
                    }
                    mnemonic = vk;
                }
            }
            plainText.append((char)ch);
        }
        Pair<Integer, String> pair = Pair.pair(mnemonic, plainText.toString());
        if (pair == null) {
            DialogWrapper.$$$reportNull$$$0(32);
        }
        return pair;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            DialogWrapper.$$$reportNull$$$0(33);
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, parent, canBeParent);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(34);
        }
        return dialogWrapperPeer;
    }

    @Deprecated
    @NotNull
    protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = this.createPeer(null, canBeParent, applicationModalIfPossible);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(35);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, IdeModalityType ideModalityType) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, owner, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(36);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = this.createPeer(owner, canBeParent, applicationModalIfPossible ? IdeModalityType.IDE : IdeModalityType.PROJECT);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(37);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project2, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(38);
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project2, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(39);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project2, boolean canBeParent) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project2, canBeParent);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(40);
        }
        return dialogWrapperPeer;
    }

    @Nullable
    protected JComponent createTitlePane() {
        return null;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected abstract JComponent createCenterPanel();

    public void toFront() {
        this.myPeer.toFront();
    }

    public void toBack() {
        this.myPeer.toBack();
    }

    protected boolean setAutoAdjustable(boolean autoAdjustable) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return false;
        }
        rootPane.putClientProperty(NO_AUTO_RESIZE, autoAdjustable ? null : Boolean.TRUE);
        return true;
    }

    public boolean isAutoAdjustable() {
        JRootPane rootPane = this.getRootPane();
        return rootPane == null || rootPane.getClientProperty(NO_AUTO_RESIZE) == null;
    }

    protected void dispose() {
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorTextAlarm.cancelAllRequests();
        this.myValidationAlarm.cancelAllRequests();
        this.myDisposed = true;
        for (JButton button2 : this.myButtonMap.values()) {
            button2.setAction(null);
        }
        this.myButtonMap.clear();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            DialogWrapper.unregisterKeyboardActions(rootPane);
            if (this.myActualSize != null && this.isAutoAdjustable()) {
                this.setSize(this.myActualSize.width, this.myActualSize.height);
            }
            this.myPeer.dispose();
        }
    }

    public static void cleanupRootPane(@Nullable JRootPane rootPane) {
        if (rootPane == null) {
            return;
        }
        RepaintManager.currentManager(rootPane).removeInvalidComponent(rootPane);
        DialogWrapper.unregisterKeyboardActions(rootPane);
        Container contentPane = rootPane.getContentPane();
        if (contentPane != null) {
            contentPane.removeAll();
        }
        DialogWrapper.clearOwnFields(rootPane, field -> {
            String clazz = field.getDeclaringClass().getName();
            if (!clazz.startsWith("java.") && !clazz.startsWith("javax.")) {
                return true;
            }
            String name = field.getName();
            return "clientProperties".equals(name);
        });
    }

    public static void unregisterKeyboardActions(@Nullable Component rootPane) {
        int[] flags = new int[]{0, 1, 2};
        for (JComponent eachComp : UIUtil.uiTraverser(rootPane).traverse().filter(JComponent.class)) {
            ActionMap actionMap = eachComp.getActionMap();
            if (actionMap == null) continue;
            for (KeyStroke eachStroke : eachComp.getRegisteredKeyStrokes()) {
                boolean remove2 = true;
                for (int i : flags) {
                    Action action2;
                    Object key = eachComp.getInputMap(i).get(eachStroke);
                    Action action3 = action2 = key == null ? null : actionMap.get(key);
                    if (!(action2 instanceof UIResource)) continue;
                    remove2 = false;
                }
                if (!remove2) continue;
                eachComp.unregisterKeyboardAction(eachStroke);
            }
        }
    }

    public static void cleanupWindowListeners(@Nullable Window window) {
        if (window == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            for (WindowListener listener2 : window.getWindowListeners()) {
                if (!listener2.getClass().getName().startsWith("com.intellij.")) continue;
                window.removeWindowListener(listener2);
            }
        });
    }

    public void doCancelAction() {
        if (this.getCancelAction().isEnabled()) {
            this.close(1);
        }
    }

    private void processDoNotAskOnCancel() {
        if (this.myDoNotAsk != null && this.myDoNotAsk.shouldSaveOptionsOnCancel() && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), 1);
        }
    }

    public void doCancelAction(AWTEvent source) {
        this.recordAction("DialogCancelAction", source);
        this.doCancelAction();
    }

    public void clickDefaultButton() {
        JButton button2 = this.getRootPane().getDefaultButton();
        if (button2 != null) {
            button2.doClick();
        }
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            if (this.myDialogPanel != null) {
                this.myDialogPanel.apply();
            }
            this.close(0);
        }
    }

    protected void processDoNotAskOnOk(int exitCode) {
        if (this.myDoNotAsk != null && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), exitCode);
        }
    }

    public boolean shouldCloseOnCross() {
        return this.myCrossClosesWindow;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray;
        Action helpAction = this.getHelpAction();
        if (helpAction == this.myHelpAction && this.getHelpId() == null) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = this.getOKAction();
            actionArray = actionArray2;
            actionArray2[1] = this.getCancelAction();
        } else {
            Action[] actionArray3 = new Action[3];
            actionArray3[0] = this.getOKAction();
            actionArray3[1] = this.getCancelAction();
            actionArray = actionArray3;
            actionArray3[2] = helpAction;
        }
        if (actionArray == null) {
            DialogWrapper.$$$reportNull$$$0(41);
        }
        return actionArray;
    }

    protected Action @NotNull [] createLeftSideActions() {
        return new Action[0];
    }

    @NotNull
    protected Action getOKAction() {
        Action action2 = this.myOKAction;
        if (action2 == null) {
            DialogWrapper.$$$reportNull$$$0(42);
        }
        return action2;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action2 = this.myCancelAction;
        if (action2 == null) {
            DialogWrapper.$$$reportNull$$$0(43);
        }
        return action2;
    }

    @NotNull
    protected Action getHelpAction() {
        Action action2 = this.myHelpAction;
        if (action2 == null) {
            DialogWrapper.$$$reportNull$$$0(44);
        }
        return action2;
    }

    protected boolean isProgressDialog() {
        return false;
    }

    public final boolean isModalProgress() {
        return this.isProgressDialog();
    }

    public Container getContentPane() {
        return this.myPeer.getContentPane();
    }

    public void validate() {
        this.myPeer.validate();
    }

    public void repaint() {
        this.myPeer.repaint();
    }

    @Nullable
    @NonNls
    protected String getDimensionServiceKey() {
        return null;
    }

    @Nullable
    public final String getDimensionKey() {
        return this.getDimensionServiceKey();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myPreferredFocusedComponentFromPanel != null) {
            return this.myPreferredFocusedComponentFromPanel;
        }
        return SystemInfo.isMac ? this.myPreferredFocusedComponent : null;
    }

    public final float getHorizontalStretch() {
        return this.myHorizontalStretch;
    }

    public final float getVerticalStretch() {
        return this.myVerticalStretch;
    }

    protected final void setHorizontalStretch(float hStretch) {
        this.myHorizontalStretch = hStretch;
    }

    protected final void setVerticalStretch(float vStretch) {
        this.myVerticalStretch = vStretch;
    }

    public Window getOwner() {
        return this.myPeer.getOwner();
    }

    public Window getWindow() {
        return this.myPeer.getWindow();
    }

    public JComponent getContentPanel() {
        return (JComponent)this.myPeer.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.myPeer.getRootPane();
    }

    public Dimension getSize() {
        return this.myPeer.getSize();
    }

    public String getTitle() {
        return this.myPeer.getTitle();
    }

    protected void init() {
        boolean isVisualPaddingCompensatedOnComponentLevel;
        JComponent centerPanel2;
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorText = new ErrorText(this.getErrorTextAlignment());
        this.myErrorText.setVisible(false);
        ComponentAdapter resizeListener = new ComponentAdapter(){
            private int myHeight;

            @Override
            public void componentResized(ComponentEvent event) {
                int height;
                int n = height = !DialogWrapper.this.myErrorText.isVisible() ? 0 : event.getComponent().getHeight();
                if (height != this.myHeight) {
                    this.myHeight = height;
                    DialogWrapper.this.myResizeInProgress = true;
                    DialogWrapper.this.myErrorText.setMinimumSize(new Dimension(0, height));
                    JRootPane root = DialogWrapper.this.myPeer.getRootPane();
                    if (root != null) {
                        root.validate();
                    }
                    if (DialogWrapper.this.myActualSize != null && !DialogWrapper.this.shouldAddErrorNearButtons()) {
                        DialogWrapper.this.myPeer.setSize(((DialogWrapper)DialogWrapper.this).myActualSize.width, ((DialogWrapper)DialogWrapper.this).myActualSize.height + height);
                    }
                    DialogWrapper.this.myErrorText.revalidate();
                    DialogWrapper.this.myResizeInProgress = false;
                }
            }
        };
        this.myErrorText.myLabel.addComponentListener(resizeListener);
        Disposer.register(this.myDisposable, () -> this.myErrorText.myLabel.removeComponentListener(resizeListener));
        JPanel root = new JPanel(this.createRootLayout());
        this.myPeer.setContentPane(root);
        DumbAwareAction toggleShowOptions = DumbAwareAction.create(e -> this.expandNextOptionButton());
        toggleShowOptions.registerCustomShortcutSet(JBOptionButton.getDefaultShowPopupShortcut(), root, this.myDisposable);
        JComponent titlePane = this.createTitlePane();
        if (titlePane != null) {
            JPanel northSection = new JPanel(new BorderLayout());
            root.add((Component)northSection, "North");
            northSection.add((Component)titlePane, "Center");
        }
        JPanel centerSection = new JPanel(new BorderLayout());
        root.add((Component)centerSection, "Center");
        JComponent n = this.createNorthPanel();
        if (n != null) {
            centerSection.add((Component)n, "North");
        }
        if ((centerPanel2 = this.createCenterPanel()) != null) {
            centerPanel2.putClientProperty(DIALOG_CONTENT_PANEL_PROPERTY, true);
            centerSection.add((Component)centerPanel2, "Center");
            if (centerPanel2 instanceof DialogPanel) {
                DialogPanel dialogPanel = (DialogPanel)centerPanel2;
                this.myPreferredFocusedComponentFromPanel = dialogPanel.getPreferredFocusedComponent();
                this.myValidateCallbacks.addAll(dialogPanel.getValidateCallbacks());
                dialogPanel.registerValidators(this.myDisposable, (Function1<? super Map<JComponent, ValidationInfo>, Unit>)((Function1)map2 -> {
                    this.setOKActionEnabled(map2.isEmpty());
                    return Unit.INSTANCE;
                }));
                this.myDialogPanel = dialogPanel;
            }
        }
        boolean bl = isVisualPaddingCompensatedOnComponentLevel = centerPanel2 == null || centerPanel2.getClientProperty(IS_VISUAL_PADDING_COMPENSATED_ON_COMPONENT_LEVEL_KEY) == null;
        if (isVisualPaddingCompensatedOnComponentLevel) {
            root.setBorder(this.createContentPaneBorder());
        }
        if (this.myCreateSouthSection) {
            JPanel southSection = new JPanel(new BorderLayout());
            if (!isVisualPaddingCompensatedOnComponentLevel) {
                southSection.setBorder(JBUI.Borders.empty(0, 12, 8, 12));
            }
            root.add((Component)southSection, "South");
            southSection.add((Component)this.myErrorText, "Center");
            JComponent south = this.createSouthPanel();
            if (south != null) {
                southSection.add((Component)south, "South");
            }
        }
        MnemonicHelper.init(root);
        if (!this.postponeValidation()) {
            this.startTrackingValidation();
        }
        if (SystemInfo.isWindows) {
            DialogWrapper.installEnterHook(root, this.myDisposable);
        }
        this.myErrorTextAlarm.setActivationComponent(root);
    }

    protected int getErrorTextAlignment() {
        return 10;
    }

    @NotNull
    protected LayoutManager createRootLayout() {
        return new BorderLayout();
    }

    private static void installEnterHook(JComponent root, Disposable disposable2) {
        new DumbAwareAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                Component owner;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JButton && owner.isEnabled()) {
                    ((JButton)owner).doClick();
                }
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                e.getPresentation().setEnabled(owner instanceof JButton && owner.isEnabled());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/ui/DialogWrapper$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("ENTER"), root, disposable2);
    }

    private void expandNextOptionButton() {
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).closePopup();
        }
        this.myCurrentOptionsButtonIndex = DialogWrapper.getEnabledIndexCyclic(this.myOptionsButtons, this.myCurrentOptionsButtonIndex, true).orElse(-1);
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.myOptionsButtons.get(this.myCurrentOptionsButtonIndex).showPopup(null, true);
        }
    }

    protected void startTrackingValidation() {
        SwingUtilities.invokeLater(() -> {
            if (!this.myValidationStarted && !this.myDisposed) {
                this.myValidationStarted = true;
                this.initValidation();
            }
        });
    }

    protected final void initValidation() {
        this.myValidationAlarm.cancelAllRequests();
        Runnable validateRequest = () -> {
            if (this.myDisposed) {
                return;
            }
            List<ValidationInfo> result2 = this.doValidateAll();
            if (!result2.isEmpty()) {
                this.installErrorPainter();
            }
            this.myErrorPainter.setValidationInfo(result2);
            this.updateErrorInfo(result2);
            if (!this.myDisposed) {
                this.initValidation();
            }
        };
        if (this.getValidationThreadToUse() == Alarm.ThreadToUse.SWING_THREAD) {
            JRootPane rootPane = this.getRootPane();
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay, ApplicationManager.getApplication() == null ? null : (rootPane == null ? ModalityState.current() : ModalityState.stateForComponent(rootPane)));
        } else {
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay);
        }
    }

    @NotNull
    protected JComponent createContentPane() {
        return new JPanel();
    }

    public void pack() {
        this.myPeer.pack();
    }

    public Dimension getPreferredSize() {
        return this.myPeer.getPreferredSize();
    }

    protected final void setButtonsAlignment(int alignment) {
        if (0 != alignment && 4 != alignment) {
            throw new IllegalArgumentException("unknown alignment: " + alignment);
        }
        this.myButtonAlignment = alignment;
    }

    @Deprecated
    public final void setButtonsMargin(Insets insets) {
    }

    public final void setCrossClosesWindow(boolean crossClosesWindow) {
        this.myCrossClosesWindow = crossClosesWindow;
    }

    @Deprecated
    protected final void setCancelButtonIcon(Icon icon2) {
    }

    protected final void setCancelButtonText(@Nls @NotNull String text2) {
        if (text2 == null) {
            DialogWrapper.$$$reportNull$$$0(45);
        }
        this.myCancelAction.putValue("Name", text2);
    }

    public void setModal(boolean modal) {
        this.myPeer.setModal(modal);
    }

    public boolean isModal() {
        return this.myPeer.isModal();
    }

    public boolean isOKActionEnabled() {
        return this.myOKAction.isEnabled();
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.myOKAction.setEnabled(isEnabled);
    }

    protected final void setOKButtonIcon(Icon icon2) {
        this.myOKAction.putValue("SmallIcon", icon2);
    }

    protected final void setOKButtonText(@Nls @NotNull String text2) {
        if (text2 == null) {
            DialogWrapper.$$$reportNull$$$0(46);
        }
        this.myOKAction.putValue("Name", text2);
    }

    protected final void setOKButtonMnemonic(int c) {
        this.myOKAction.putValue("MnemonicKey", c);
    }

    protected final void setOKButtonTooltip(@Nls String text2) {
        this.myOKAction.putValue("ShortDescription", text2);
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return null;
    }

    protected void doHelpAction() {
        if (this.myHelpAction.isEnabled()) {
            this.logClickOnHelpDialogEvent();
            String helpId = this.getHelpId();
            if (helpId != null) {
                HelpManager.getInstance().invokeHelp(helpId);
            } else {
                LOG.error("null topic; dialog=" + this.getClass() + "; action=" + this.getHelpAction().getClass());
            }
        }
    }

    public boolean isOK() {
        return this.getExitCode() == 0;
    }

    public boolean isVisible() {
        return this.myPeer.isVisible();
    }

    public boolean isShowing() {
        return this.myPeer.isShowing();
    }

    public void setSize(int width, int height) {
        this.myPeer.setSize(width, height);
    }

    public void setTitle(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        this.myPeer.setTitle(title);
    }

    public void isResizable() {
        this.myPeer.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myPeer.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myPeer.getLocation();
        if (point == null) {
            DialogWrapper.$$$reportNull$$$0(47);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            DialogWrapper.$$$reportNull$$$0(48);
        }
        this.myPeer.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myPeer.setLocation(x, y);
    }

    public void centerRelativeToParent() {
        this.myPeer.centerInParent();
    }

    public void show() {
        this.logShowDialogEvent();
        this.doShow();
    }

    public boolean showAndGet() {
        if (!this.isModal()) {
            throw new IllegalStateException("The showAndGet() method is for modal dialogs only");
        }
        this.show();
        return this.isOK();
    }

    @Deprecated
    @NotNull
    public AsyncResult<Boolean> showAndGetOk() {
        if (this.isModal()) {
            throw new IllegalStateException("The showAndGetOk() method is for modeless dialogs only");
        }
        AsyncResult result2 = new AsyncResult();
        Disposer.register(this.myDisposable, () -> result2.setDone((Object)this.isOK()));
        this.doShow();
        AsyncResult asyncResult = result2;
        if (asyncResult == null) {
            DialogWrapper.$$$reportNull$$$0(49);
        }
        return asyncResult;
    }

    private void doShow() {
        DialogWrapper.ensureEventDispatchThread();
        this.registerKeyboardShortcuts();
        Disposable uiParent = Disposer.get("ui");
        if (uiParent != null) {
            Disposer.register(uiParent, this.myDisposable);
        }
        this.myPeer.show();
    }

    @Nullable
    public Point getInitialLocation() {
        return this.myInitialLocationCallback == null ? null : this.myInitialLocationCallback.compute();
    }

    public void setInitialLocationCallback(@NotNull Computable<? extends Point> callback2) {
        if (callback2 == null) {
            DialogWrapper.$$$reportNull$$$0(50);
        }
        this.myInitialLocationCallback = callback2;
    }

    private void registerKeyboardShortcuts() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        ActionListener cancelKeyboardAction = this.createCancelAction();
        if (cancelKeyboardAction != null) {
            rootPane.registerKeyboardAction(cancelKeyboardAction, KeyStroke.getKeyStroke(27, 0), 2);
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), cancelKeyboardAction, CommonShortcuts.getCloseActiveWindow());
        }
        if (!DialogWrapper.isRemoveHelpButton() && !this.isProgressDialog()) {
            ActionListener helpAction = e -> this.doHelpAction();
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), helpAction, CommonShortcuts.getContextHelp());
            rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        }
        rootPane.registerKeyboardAction(e -> this.focusButton(false), KeyStroke.getKeyStroke(37, 0), 1);
        rootPane.registerKeyboardAction(e -> this.focusButton(true), KeyStroke.getKeyStroke(39, 0), 1);
        if (this.myYesAction != null) {
            rootPane.registerKeyboardAction(this.myYesAction, KeyStroke.getKeyStroke(89, 0), 2);
        }
        if (this.myNoAction != null) {
            rootPane.registerKeyboardAction(this.myNoAction, KeyStroke.getKeyStroke(78, 0), 2);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return e -> {
            if (!PopupUtil.handleEscKeyEvent()) {
                this.doCancelAction(e);
            }
        };
    }

    private void focusButton(boolean next) {
        ArrayList<JButton> buttons = new ArrayList<JButton>(this.myButtonMap.values());
        int focusedIndex = ContainerUtil.indexOf(buttons, Component::hasFocus);
        if (focusedIndex >= 0) {
            DialogWrapper.getEnabledIndexCyclic(buttons, focusedIndex, next).ifPresent(i -> ((JButton)buttons.get(i)).requestFocus());
        }
    }

    @NotNull
    private static OptionalInt getEnabledIndexCyclic(@NotNull List<? extends Component> components, int currentIndex, boolean next) {
        if (components == null) {
            DialogWrapper.$$$reportNull$$$0(51);
        }
        assert (-1 <= currentIndex && currentIndex <= components.size());
        int start2 = !next && currentIndex == -1 ? components.size() : currentIndex;
        OptionalInt optionalInt = IntStream.range(0, components.size()).map(i -> (next ? start2 + i + 1 : start2 + components.size() - i - 1) % components.size()).filter(i -> ((Component)components.get(i)).isEnabled()).findFirst();
        if (optionalInt == null) {
            DialogWrapper.$$$reportNull$$$0(52);
        }
        return optionalInt;
    }

    private void logCloseDialogEvent(int exitCode) {
        String dialogId;
        boolean canRecord = this.canRecordDialogId();
        if (canRecord && StringUtil.isNotEmpty(dialogId = this.getClass().getName())) {
            FeatureUsageUiEventsKt.getUiEventLogger().logCloseDialog(dialogId, exitCode, this.getClass());
        }
    }

    private void logShowDialogEvent() {
        String dialogId;
        boolean canRecord = this.canRecordDialogId();
        if (canRecord && StringUtil.isNotEmpty(dialogId = this.getClass().getName())) {
            FeatureUsageUiEventsKt.getUiEventLogger().logShowDialog(dialogId, this.getClass());
        }
    }

    private void logClickOnHelpDialogEvent() {
        if (!this.canRecordDialogId()) {
            return;
        }
        String dialogId = this.getClass().getName();
        if (StringUtil.isNotEmpty(dialogId)) {
            FeatureUsageUiEventsKt.getUiEventLogger().logClickOnHelpDialog(dialogId, this.getClass());
        }
    }

    protected boolean canRecordDialogId() {
        return true;
    }

    private void recordAction(@NonNls String name, AWTEvent event) {
        if (event instanceof KeyEvent && ApplicationManager.getApplication() != null) {
            ActionsCollector.getInstance().record(name, (KeyEvent)event, this.getClass());
        }
    }

    protected void setErrorText(@Nls @Nullable String text2) {
        this.setErrorText(text2, null);
    }

    protected void setErrorText(@Nls @Nullable String text2, @Nullable JComponent component2) {
        this.setErrorInfoAll(text2 == null ? Collections.emptyList() : Collections.singletonList(new ValidationInfo(text2, component2)));
    }

    protected void setErrorInfoAll(@NotNull List<ValidationInfo> info) {
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(53);
        }
        if (this.myInfo.equals(info)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        boolean headless = application != null && application.isHeadlessEnvironment();
        this.myErrorTextAlarm.cancelAllRequests();
        Runnable clearErrorRunnable = () -> {
            if (this.myErrorText != null) {
                this.myErrorText.clearError(info.isEmpty());
            }
        };
        if (headless) {
            clearErrorRunnable.run();
        } else {
            SwingUtilities.invokeLater(clearErrorRunnable);
        }
        List<ValidationInfo> corrected = ContainerUtil.filter(this.myInfo, vi -> !info.contains(vi));
        if (Registry.is("ide.inplace.validation.tooltip")) {
            corrected.stream().filter(vi -> vi.component != null).map(vi -> ComponentValidator.getInstance(vi.component)).forEach(c -> c.ifPresent(vi -> vi.updateInfo(null)));
        }
        this.myInfo = info;
        if (Registry.is("ide.inplace.validation.tooltip") && !this.myInfo.isEmpty()) {
            this.myInfo.forEach(vi -> {
                ComponentValidator v;
                if (vi.component != null && (v = ComponentValidator.getInstance(vi.component).orElseGet(() -> new ComponentValidator(this.getDisposable()).installOn(vi.component))) != null) {
                    v.updateInfo((ValidationInfo)vi);
                    return;
                }
                SwingUtilities.invokeLater(() -> this.myErrorText.appendError(vi));
            });
        } else if (!this.myInfo.isEmpty()) {
            Runnable updateErrorTextRunnable = () -> {
                for (ValidationInfo vi : this.myInfo) {
                    this.myErrorText.appendError(vi);
                }
            };
            if (headless) {
                updateErrorTextRunnable.run();
            } else {
                this.myErrorTextAlarm.addRequest(updateErrorTextRunnable, 300, (ModalityState)null);
            }
        }
    }

    protected boolean hasErrors(@NotNull JComponent component2) {
        if (component2 == null) {
            DialogWrapper.$$$reportNull$$$0(54);
        }
        return this.myInfo.stream().anyMatch(i -> component2.equals(i.component) && !i.warning);
    }

    private void updateSize() {
        if (this.myActualSize == null && !this.myErrorText.isVisible()) {
            this.myActualSize = this.getSize();
        }
    }

    @Nullable
    public static DialogWrapper findInstance(Component c) {
        while (c != null) {
            if (c instanceof DialogWrapperDialog) {
                return ((DialogWrapperDialog)((Object)c)).getDialogWrapper();
            }
            c = c.getParent();
        }
        return null;
    }

    @Nullable
    public static DialogWrapper findInstanceFromFocus() {
        return DialogWrapper.findInstance(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
    }

    @NotNull
    public final DialogWrapperPeer getPeer() {
        DialogWrapperPeer dialogWrapperPeer = this.myPeer;
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(55);
        }
        return dialogWrapperPeer;
    }

    private static void ensureEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("The DialogWrapper can only be used in event dispatch thread. Current thread: " + Thread.currentThread());
        }
    }

    @NotNull
    public final Disposable getDisposable() {
        Disposable disposable2 = this.myDisposable;
        if (disposable2 == null) {
            DialogWrapper.$$$reportNull$$$0(56);
        }
        return disposable2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void disposeIfNeeded() {
        if (this.isDisposed()) {
            return;
        }
        Disposer.dispose(this.getDisposable());
    }

    private static void clearOwnFields(@Nullable Object object, @NotNull Condition<? super Field> selectCondition) {
        if (selectCondition == null) {
            DialogWrapper.$$$reportNull$$$0(57);
        }
        if (object == null) {
            return;
        }
        for (Field each : ReflectionUtil.collectFields(object.getClass())) {
            if ((each.getModifiers() & 0x18) > 0 || !selectCondition.value(each)) continue;
            try {
                ReflectionUtil.resetField(object, each);
            }
            catch (Exception exception) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 3: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/DialogWrapper";
                break;
            }
            case 8: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpButton";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftSideButtons";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightSideButtons";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/DialogWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationThreadToUse";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpButton";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenOptionsActions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutButtonsPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createJButtonForAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createJOptionsButton";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMnemonic";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelAction";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpAction";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndGetOk";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIndexCyclic";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeer";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addKeyListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createHelpButton";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setHelpTooltip";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "flattenOptionsActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createSouthPanel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createButtonsPanel";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "layoutButtonsPanel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getButton";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createJButtonForAction";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createJOptionsButton";
                break;
            }
            case 33: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createPeer";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setCancelButtonText";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setOKButtonText";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setInitialLocationCallback";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledIndexCyclic";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setErrorInfoAll";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "clearOwnFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorPainter
    extends AbstractPainter {
        private List<ValidationInfo> info;

        private ErrorPainter() {
        }

        @Override
        public void executePaint(Component component2, Graphics2D g) {
            for (ValidationInfo i : this.info) {
                if (i.component == null || Registry.is("ide.inplace.errors.outline")) continue;
                int w = i.component.getWidth();
                Point p = SwingUtilities.convertPoint(i.component, w, 0, component2);
                AllIcons.General.Error.paintIcon(component2, g, p.x - 8, p.y - 8);
            }
        }

        @Override
        public boolean needsRepaint() {
            return true;
        }

        private void setValidationInfo(@NotNull List<ValidationInfo> info) {
            if (info == null) {
                ErrorPainter.$$$reportNull$$$0(0);
            }
            this.info = info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/ui/DialogWrapper$ErrorPainter", "setValidationInfo"));
        }
    }

    public static interface DoNotAskOption {
        public boolean isToBeShown();

        public void setToBeShown(boolean var1, int var2);

        public boolean canBeHidden();

        public boolean shouldSaveOptionsOnCancel();

        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDoNotShowMessage();

        public static abstract class Adapter
        implements DoNotAskOption {
            public abstract void rememberChoice(boolean var1, int var2);

            public boolean isSelectedByDefault() {
                return false;
            }

            @Override
            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                String string = UIBundle.message("dialog.options.do.not.ask", new Object[0]);
                if (string == null) {
                    Adapter.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public final boolean isToBeShown() {
                return !this.isSelectedByDefault();
            }

            @Override
            public final void setToBeShown(boolean toBeShown, int exitCode) {
                this.rememberChoice(!toBeShown, exitCode);
            }

            @Override
            public final boolean canBeHidden() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$DoNotAskOption$Adapter", "getDoNotShowMessage"));
            }
        }
    }

    private class ErrorText
    extends JPanel {
        private final JLabel myLabel = new JLabel();
        private final List<ValidationInfo> errors = new ArrayList<ValidationInfo>();

        private ErrorText(int horizontalAlignment) {
            this.setLayout(new BorderLayout());
            this.myLabel.setBorder(this.createErrorTextBorder());
            this.myLabel.setHorizontalAlignment(horizontalAlignment);
            JBScrollPane pane2 = new JBScrollPane(this.myLabel, 21, 31);
            pane2.setBorder(JBUI.Borders.empty());
            pane2.setBackground(null);
            pane2.getViewport().setBackground(null);
            pane2.setOpaque(false);
            this.add((Component)pane2, "Center");
        }

        @NotNull
        private Border createErrorTextBorder() {
            Border border = DialogWrapper.this.createContentPaneBorder();
            JBInsets contentInsets = border != null ? border.getBorderInsets(null) : JBUI.emptyInsets();
            JBInsets baseInsets = JBInsets.create(16, 13);
            return new EmptyBorder(baseInsets.top, baseInsets.left > contentInsets.left ? baseInsets.left - contentInsets.left : 0, baseInsets.bottom > contentInsets.bottom ? baseInsets.bottom - contentInsets.bottom : 0, baseInsets.right > contentInsets.right ? baseInsets.right - contentInsets.right : 0);
        }

        private void clearError(boolean full) {
            this.errors.clear();
            if (full) {
                this.myLabel.setBounds(0, 0, 0, 0);
                this.myLabel.setText("");
                this.setVisible(false);
                DialogWrapper.this.updateSize();
            }
        }

        private void appendError(@NotNull ValidationInfo info) {
            if (info == null) {
                ErrorText.$$$reportNull$$$0(0);
            }
            this.errors.add(info);
            StringBuilder sb = new StringBuilder("<html>");
            this.errors.forEach(vi -> {
                Color color = vi.warning ? MessageType.WARNING.getTitleForeground() : ERROR_FOREGROUND_COLOR;
                sb.append("<font color='#").append(ColorUtil.toHex(color)).append("'>").append("<left>").append(vi.message).append("</left></font><br/>");
            });
            sb.append("</html>");
            this.myLabel.setText(sb.toString());
            this.setVisible(true);
            DialogWrapper.this.updateSize();
        }

        private boolean isTextSet(@NotNull List<ValidationInfo> info) {
            if (info == null) {
                ErrorText.$$$reportNull$$$0(1);
            }
            return this.errors.equals(info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "info";
            objectArray2[1] = "com/intellij/openapi/ui/DialogWrapper$ErrorText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTextSet";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
            super(CommonBundle.getHelpButtonText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogWrapper.this.doHelpAction();
        }
    }

    protected class DialogWrapperExitAction
    extends DialogWrapperAction {
        protected final int myExitCode;

        public DialogWrapperExitAction(String name, int exitCode) {
            super(name);
            this.myExitCode = exitCode;
        }

        @Override
        protected void doAction(ActionEvent e) {
            if (this.isEnabled()) {
                DialogWrapper.this.close(this.myExitCode);
            }
        }
    }

    protected class CancelAction
    extends DialogWrapperAction {
        private CancelAction() {
            super(CommonBundle.getCancelButtonText());
            this.addPropertyChangeListener(DialogWrapper.this.myRepaintOnNameChangeListener);
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.doCancelAction(e);
        }
    }

    protected class OkAction
    extends DialogWrapperAction {
        protected OkAction() {
            super(CommonBundle.getOkButtonText());
            this.addPropertyChangeListener(DialogWrapper.this.myRepaintOnNameChangeListener);
            this.putValue(DialogWrapper.DEFAULT_ACTION, Boolean.TRUE);
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.recordAction("DialogOkAction", EventQueue.getCurrentEvent());
            List<ValidationInfo> infoList = DialogWrapper.this.doValidateAll();
            if (!infoList.isEmpty()) {
                ValidationInfo info = infoList.get(0);
                if (info.component != null && info.component.isVisible()) {
                    IdeFocusManager.getInstance(null).requestFocus(info.component, true);
                }
                if (!Registry.is("ide.inplace.validation.tooltip")) {
                    DialogEarthquakeShaker.shake(DialogWrapper.this.getPeer().getWindow());
                }
                DialogWrapper.this.startTrackingValidation();
                if (infoList.stream().anyMatch(info1 -> !info1.okEnabled)) {
                    return;
                }
            }
            DialogWrapper.this.doOKAction();
        }
    }

    protected abstract class DialogWrapperAction
    extends AbstractAction {
        protected DialogWrapperAction(String name) {
            if (name == null) {
                DialogWrapperAction.$$$reportNull$$$0(0);
            }
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            try {
                DialogWrapper.this.myPerformAction = true;
                this.doAction(e);
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }

        protected abstract void doAction(ActionEvent var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/ui/DialogWrapper$DialogWrapperAction", "<init>"));
        }
    }

    public static enum DialogStyle {
        NO_STYLE,
        COMPACT;

    }

    public static enum IdeModalityType {
        IDE,
        PROJECT,
        MODELESS;


        @NotNull
        public Dialog.ModalityType toAwtModality() {
            switch (this) {
                case IDE: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.APPLICATION_MODAL;
                    if (modalityType == null) {
                        IdeModalityType.$$$reportNull$$$0(0);
                    }
                    return modalityType;
                }
                case PROJECT: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.DOCUMENT_MODAL;
                    if (modalityType == null) {
                        IdeModalityType.$$$reportNull$$$0(1);
                    }
                    return modalityType;
                }
                case MODELESS: {
                    Dialog.ModalityType modalityType = Dialog.ModalityType.MODELESS;
                    if (modalityType == null) {
                        IdeModalityType.$$$reportNull$$$0(2);
                    }
                    return modalityType;
                }
            }
            throw new IllegalStateException(this.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$IdeModalityType", "toAwtModality"));
        }
    }
}

