/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MasterDetailsComponent
implements Configurable,
DetailsComponent.Facade,
MasterDetails {
    protected static final Logger LOG = Logger.getInstance(MasterDetailsComponent.class);
    protected static final Icon COPY_ICON = PlatformIcons.COPY_ICON;
    protected NamedConfigurable myCurrentConfigurable;
    private final JBSplitter mySplitter;
    @NonNls
    public static final String TREE_OBJECT = "treeObject";
    @NonNls
    public static final String TREE_NAME = "treeName";
    protected History myHistory = new History(new Place.Navigator(){

        @Override
        public void setHistory(History history) {
            MasterDetailsComponent.this.myHistory = history;
        }
    });
    private JComponent myMaster;
    protected final MasterDetailsState myState;
    protected final Runnable TREE_UPDATER = new Runnable(){

        @Override
        public void run() {
            TreePath selectionPath = MasterDetailsComponent.this.myTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            if (node == null) {
                return;
            }
            MasterDetailsComponent.this.myState.setLastEditedConfigurable(MasterDetailsComponent.getNodePathString(node));
            NamedConfigurable configurable2 = node.getConfigurable();
            if (configurable2 != null) {
                MasterDetailsComponent.this.myDetails.setText(configurable2.getBannerSlogan());
            }
            node.reloadNode((DefaultTreeModel)MasterDetailsComponent.this.myTree.getModel());
            MasterDetailsComponent.this.fireItemsChangedExternally();
        }
    };
    protected MyNode myRoot = new MyRootNode();
    protected Tree myTree = new Tree();
    private final DetailsComponent myDetails = new DetailsComponent(false, false);
    protected JPanel myWholePanel;
    public JPanel myNorthPanel = new JPanel(new BorderLayout());
    private final List<ItemsChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<NamedConfigurable> myInitializedConfigurables = new HashSet<NamedConfigurable>();
    private boolean myHasDeletedItems;
    protected AutoScrollToSourceHandler myAutoScrollHandler;
    protected boolean myToReInitWholePanel = true;

    public void setHistory(History history) {
        this.myHistory = history;
    }

    protected MasterDetailsComponent() {
        this(new MasterDetailsState());
    }

    protected MasterDetailsComponent(@Nullable MasterDetailsState state) {
        this.myState = state == null ? new MasterDetailsState() : state;
        this.mySplitter = new OnePixelSplitter(false, 0.2f);
        this.mySplitter.setSplitterProportionKey("ProjectStructure.SecondLevelElements");
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.installAutoScroll();
    }

    protected void reInitWholePanelIfNeeded() {
        if (!this.myToReInitWholePanel) {
            return;
        }
        this.myWholePanel = new NonOpaquePanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                MasterDetailsComponent.this.addNotify();
                TreeModel m = MasterDetailsComponent.this.myTree.getModel();
                if (m instanceof DefaultTreeModel) {
                    DefaultTreeModel model = (DefaultTreeModel)m;
                    for (int eachRow = 0; eachRow < MasterDetailsComponent.this.myTree.getRowCount(); ++eachRow) {
                        TreePath eachPath = MasterDetailsComponent.this.myTree.getPathForRow(eachRow);
                        Object component2 = eachPath.getLastPathComponent();
                        if (!(component2 instanceof TreeNode)) continue;
                        model.nodeChanged((TreeNode)component2);
                    }
                }
            }
        };
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.myWholePanel.add((Component)this.mySplitter, "Center");
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTree).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder(JBUI.Borders.empty()).setScrollPaneBorder(JBUI.Borders.empty());
        DefaultActionGroup group = this.createToolbarActionGroup();
        if (group != null) {
            decorator.setActionGroup(group);
        }
        this.myMaster = decorator.createPanel();
        this.myNorthPanel.setVisible(false);
        left.add((Component)this.myMaster, "Center");
        this.mySplitter.setFirstComponent(left);
        NonOpaquePanel right = new NonOpaquePanel(new BorderLayout());
        right.add((Component)this.myDetails.getComponent(), "Center");
        this.mySplitter.setSecondComponent(right);
        GuiUtils.replaceJSplitPaneWithIDEASplitter(this.myWholePanel);
        this.myToReInitWholePanel = false;
    }

    private void installAutoScroll() {
        this.myAutoScrollHandler = new AutoScrollToSourceHandler(){

            @Override
            protected boolean isAutoScrollMode() {
                return MasterDetailsComponent.this.isAutoScrollEnabled();
            }

            @Override
            protected void setAutoScrollMode(boolean state) {
            }

            @Override
            protected void scrollToSource(Component tree) {
                MasterDetailsComponent.this.updateSelectionFromTree();
            }

            @Override
            protected boolean needToCheckFocus() {
                return false;
            }
        };
        this.myAutoScrollHandler.install(this.myTree);
    }

    protected void addNotify() {
        this.updateSelectionFromTree();
    }

    private void updateSelectionFromTree() {
        TreePath path2;
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            ArrayList<NamedConfigurable> selectedConfigurables = new ArrayList<NamedConfigurable>();
            for (TreePath path3 : treePaths) {
                Object lastPathComponent = path3.getLastPathComponent();
                if (!(lastPathComponent instanceof MyNode)) continue;
                selectedConfigurables.add(((MyNode)lastPathComponent).getConfigurable());
            }
            if (selectedConfigurables.size() > 1 && this.updateMultiSelection(selectedConfigurables)) {
                return;
            }
        }
        if ((path2 = this.myTree.getSelectionPath()) != null) {
            Object lastPathComp = path2.getLastPathComponent();
            if (!(lastPathComp instanceof MyNode)) {
                return;
            }
            MyNode node = (MyNode)lastPathComp;
            this.setSelectedNode(node);
        } else {
            this.setSelectedNode(null);
        }
    }

    protected boolean updateMultiSelection(List<? extends NamedConfigurable> selectedConfigurables) {
        return false;
    }

    @Override
    public DetailsComponent getDetailsComponent() {
        return this.myDetails;
    }

    public Splitter getSplitter() {
        return this.mySplitter;
    }

    protected boolean isAutoScrollEnabled() {
        return this.myHistory == null || !this.myHistory.isNavigatingNow();
    }

    protected DefaultActionGroup createToolbarActionGroup() {
        List<AnAction> actions = this.createActions(false);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action2 : actions) {
                if (action2 instanceof ActionGroupWithPreselection) {
                    group.add(new MyActionGroupWrapper((ActionGroupWithPreselection)((Object)action2)));
                    continue;
                }
                group.add(action2);
            }
            return group;
        }
        return null;
    }

    public void addItemsChangeListener(ItemsChangeListener l) {
        this.myListeners.add(l);
    }

    protected Dimension getPanelPreferredSize() {
        return JBUI.size(800, 600);
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        this.myTree.updateUI();
        this.reInitWholePanelIfNeeded();
        this.updateSelectionFromTree();
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return MasterDetailsComponent.this.getPanelPreferredSize();
            }
        };
        panel2.add((Component)this.myWholePanel, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MasterDetailsComponent.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    public boolean isModified() {
        if (this.myHasDeletedItems) {
            return true;
        }
        return TreeUtil.treeNodeTraverser(this.myRoot).traverse().filterMap(node -> node instanceof MyNode ? ((MyNode)node).getConfigurable() : null).filter(configurable2 -> this.isInitialized((NamedConfigurable)configurable2) && configurable2.isModified()).isNotEmpty();
    }

    protected boolean isInitialized(NamedConfigurable configurable2) {
        return this.myInitializedConfigurables.contains(configurable2);
    }

    @Override
    public void apply() throws ConfigurationException {
        this.processRemovedItems();
        for (MyNode node : TreeUtil.treeNodeTraverser(this.myRoot).filter(MyNode.class)) {
            NamedConfigurable configurable2 = node.getConfigurable();
            if (!this.isInitialized(configurable2) || !configurable2.isModified()) continue;
            configurable2.apply();
        }
        this.myHasDeletedItems = false;
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Override
    public void reset() {
        this.loadComponentState();
        this.myHasDeletedItems = false;
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myState.getProportions().restoreSplitterProportions(this.myWholePanel);
        this.restoreLastSelection();
    }

    protected final void restoreLastSelection() {
        Enumeration<TreeNode> enumeration = this.myRoot.breadthFirstEnumeration();
        boolean selected2 = false;
        while (enumeration.hasMoreElements()) {
            MyNode node = (MyNode)enumeration.nextElement();
            if (node instanceof MyRootNode) continue;
            String path2 = MasterDetailsComponent.getNodePathString(node);
            if (selected2 || !Comparing.strEqual(path2, this.myState.getLastEditedConfigurable())) continue;
            TreeUtil.selectInTree(node, false, this.myTree);
            selected2 = true;
        }
        if (!selected2) {
            TreeUtil.promiseSelectFirst(this.myTree);
        }
        if (this.myWholePanel != null && this.myWholePanel.isShowing()) {
            this.updateSelectionFromTree();
        }
    }

    protected void loadComponentState() {
        MasterDetailsState state;
        String key = this.getComponentStateKey();
        MasterDetailsStateService stateService = this.getStateService();
        if (key != null && stateService != null && (state = stateService.getComponentState(key, this.myState.getClass())) != null) {
            this.loadState(state);
        }
    }

    private static String getNodePathString(MyNode node) {
        String displayName;
        Object userObject;
        StringBuilder path2 = new StringBuilder();
        MyNode current2 = node;
        while (current2 != null && (userObject = current2.getUserObject()) instanceof NamedConfigurable && !StringUtil.isEmptyOrSpaces(displayName = current2.getDisplayName())) {
            if (path2.length() > 0) {
                path2.append('|');
            }
            path2.append(displayName);
            TreeNode parent = current2.getParent();
            if (!(parent instanceof MyNode)) break;
            current2 = (MyNode)parent;
        }
        return path2.toString();
    }

    @Nullable
    @NonNls
    protected String getComponentStateKey() {
        return null;
    }

    @Nullable
    protected MasterDetailsStateService getStateService() {
        return null;
    }

    protected MasterDetailsState getState() {
        return this.myState;
    }

    protected void loadState(MasterDetailsState object) {
        XmlSerializerUtil.copyBean(object, this.myState);
    }

    @Override
    public void disposeUIResources() {
        this.myState.getProportions().saveSplitterProportions(this.myWholePanel);
        this.myAutoScrollHandler.cancelAllRequests();
        this.myDetails.disposeUIResources();
        this.myInitializedConfigurables.clear();
        this.clearChildren();
        String key = this.getComponentStateKey();
        MasterDetailsStateService stateService = this.getStateService();
        if (key != null && stateService != null) {
            stateService.setComponentState(key, this.getState());
        }
        this.myCurrentConfigurable = null;
    }

    protected void clearChildren() {
        for (MyNode node : TreeUtil.treeNodeTraverser(this.myRoot).filter(MyNode.class)) {
            node.getConfigurable().disposeUIResources();
            if (node instanceof MyRootNode) continue;
            node.setUserObject(null);
        }
        this.myRoot.removeAllChildren();
    }

    @Nullable
    protected List<AnAction> createActions(boolean fromPopup) {
        return null;
    }

    protected void initTree() {
        ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.myRoot);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        TreeUtil.installActions(this.myTree);
        this.myTree.setCellRenderer(new ColoredTreeCellRenderer(){

            @Override
            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (value2 instanceof MyNode) {
                    MyNode node = (MyNode)value2;
                    this.setIcon(node.getIcon(expanded));
                    Font font = UIUtil.getTreeFont();
                    if (node.isDisplayInBold()) {
                        this.setFont(font.deriveFont(1));
                    } else {
                        this.setFont(font.deriveFont(0));
                    }
                    this.append(node.getDisplayName(), node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/ui/MasterDetailsComponent$7", "customizeCellRenderer"));
            }
        });
        List<AnAction> actions = this.createActions(true);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action2 : actions) {
                group.add(action2);
            }
            actions = this.getAdditionalActions();
            if (actions != null) {
                group.addSeparator();
                for (AnAction action2 : actions) {
                    group.add(action2);
                }
            }
            PopupHandler.installPopupHandler(this.myTree, group, "unknown", ActionManager.getInstance());
        }
    }

    @Nullable
    protected ArrayList<AnAction> getAdditionalActions() {
        return null;
    }

    private void fireItemsChangeListener(Object editableObject) {
        for (ItemsChangeListener listener2 : this.myListeners) {
            listener2.itemChanged(editableObject);
        }
    }

    private void fireItemsChangedExternally() {
        for (ItemsChangeListener listener2 : this.myListeners) {
            listener2.itemsExternallyChanged();
        }
    }

    private void createUIComponents() {
        this.myTree = new Tree(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI(new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    protected void addNode(MyNode nodeToAdd, MyNode parent) {
        int i = TreeUtil.indexedBinarySearch(parent, nodeToAdd, this.getNodeComparator());
        int insertionPoint = i >= 0 ? i : -i - 1;
        ((DefaultTreeModel)this.myTree.getModel()).insertNodeInto(nodeToAdd, parent, insertionPoint);
    }

    protected void sortDescendants(MyNode root) {
        TreeUtil.sortRecursively(root, this.getNodeComparator());
        ((DefaultTreeModel)this.myTree.getModel()).reload(root);
    }

    protected Comparator<MyNode> getNodeComparator() {
        return (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect) {
        return this.selectNodeInTree(nodeToSelect, true, false);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean requestFocus) {
        return this.selectNodeInTree(nodeToSelect, true, requestFocus);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean center, boolean requestFocus) {
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myTree, true));
        }
        if (nodeToSelect != null) {
            return TreeUtil.selectInTree(nodeToSelect, requestFocus, this.myTree, center);
        }
        return TreeUtil.selectFirstNode(this.myTree);
    }

    @Nullable
    public Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MyNode) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable2 = node.getConfigurable();
            LOG.assertTrue(configurable2 != null, "already disposed");
            return configurable2.getEditableObject();
        }
        return null;
    }

    public final MyNode getSelectedNode() {
        TreePath path2 = this.myTree.getSelectionPath();
        return path2 != null ? (MyNode)path2.getLastPathComponent() : null;
    }

    @Nullable
    public NamedConfigurable getSelectedConfigurable() {
        MyNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            NamedConfigurable configurable2 = selectedNode.getConfigurable();
            LOG.assertTrue(configurable2 != null, "already disposed");
            return configurable2;
        }
        return null;
    }

    public void selectNodeInTree(String displayName) {
        MyNode nodeByName = MasterDetailsComponent.findNodeByName(this.myRoot, displayName);
        this.selectNodeInTree(nodeByName, true);
    }

    public void selectNodeInTree(Object object) {
        this.selectNodeInTree(MasterDetailsComponent.findNodeByObject(this.myRoot, object), true);
    }

    @Nullable
    protected static MyNode findNodeByName(TreeNode root, String profileName) {
        if (profileName == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, configurable2 -> Comparing.strEqual(profileName, configurable2.getDisplayName()));
    }

    @Nullable
    public static MyNode findNodeByObject(TreeNode root, Object editableObject) {
        if (editableObject == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, configurable2 -> Comparing.equal(editableObject, configurable2.getEditableObject()));
    }

    protected static MyNode findNodeByCondition(TreeNode root, Condition<? super NamedConfigurable> condition2) {
        return TreeUtil.treeNodeTraverser(root).filter(MyNode.class).filter(node -> condition2.value(node.getConfigurable())).first();
    }

    protected void setSelectedNode(@Nullable MyNode node) {
        if (node != null) {
            this.myState.setLastEditedConfigurable(MasterDetailsComponent.getNodePathString(node));
        }
        this.updateSelection(node != null ? node.getConfigurable() : null);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable2) {
        this.myDetails.setText(configurable2 != null ? configurable2.getBannerSlogan() : null);
        this.myCurrentConfigurable = configurable2;
        if (configurable2 != null) {
            JComponent comp = configurable2.createComponent();
            if (comp == null) {
                this.setEmpty();
                LOG.error("createComponent() returned null. configurable=" + configurable2);
            } else {
                this.myDetails.setContent(comp);
                this.ensureInitialized(configurable2);
                this.myHistory.pushPlaceForElement(TREE_OBJECT, configurable2.getEditableObject());
            }
        } else {
            this.setEmpty();
        }
    }

    public void ensureInitialized(NamedConfigurable configurable2) {
        if (!this.isInitialized(configurable2)) {
            configurable2.reset();
            this.initializeConfigurable(configurable2);
        }
    }

    private void setEmpty() {
        this.myDetails.setContent(null);
        this.myDetails.setEmptyContentText(this.getEmptySelectionString());
    }

    @Override
    public String getHelpTopic() {
        if (this.myCurrentConfigurable != null) {
            return this.myCurrentConfigurable.getHelpTopic();
        }
        return null;
    }

    @Nls
    @Nullable
    protected String getEmptySelectionString() {
        return null;
    }

    protected void initializeConfigurable(NamedConfigurable configurable2) {
        this.myInitializedConfigurables.add(configurable2);
    }

    protected final void checkForEmptyAndDuplicatedNames(String prefix, String title, Class<? extends NamedConfigurable> configurableClass) throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(this.myRoot, prefix, title, configurableClass, true);
    }

    private void checkForEmptyAndDuplicatedNames(MyNode rootNode, String prefix, String title, Class<? extends NamedConfigurable> configurableClass, boolean recursively) throws ConfigurationException {
        HashSet<String> names2 = new HashSet<String>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            MyNode node = (MyNode)rootNode.getChildAt(i);
            NamedConfigurable scopeConfigurable = node.getConfigurable();
            if (configurableClass.isInstance(scopeConfigurable)) {
                String name = scopeConfigurable.getDisplayName();
                if (name.trim().isEmpty()) {
                    this.selectNodeInTree(node);
                    throw new ConfigurationException(UIBundle.message("master.detail.err.empty.name", new Object[0]));
                }
                if (names2.contains(name)) {
                    NamedConfigurable selectedConfigurable = this.getSelectedConfigurable();
                    if (selectedConfigurable == null || !Comparing.strEqual(selectedConfigurable.getDisplayName(), name)) {
                        this.selectNodeInTree(node);
                    }
                    throw new ConfigurationException(UIBundle.message("master.detail.err.duplicate", prefix, name), title);
                }
                names2.add(name);
            }
            if (!recursively) continue;
            this.checkForEmptyAndDuplicatedNames(node, prefix, title, configurableClass, true);
        }
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected void removePaths(TreePath ... paths) {
        ArrayList<MyNode> nodes = new ArrayList<MyNode>();
        for (TreePath path2 : paths) {
            nodes.add((MyNode)path2.getLastPathComponent());
        }
        this.removeNodes(nodes);
    }

    protected void removeNodes(List<? extends MyNode> nodes) {
        DefaultMutableTreeNode parentNode = null;
        int idx = -1;
        for (MyNode myNode : nodes) {
            NamedConfigurable namedConfigurable = myNode.getConfigurable();
            Object editableObject = namedConfigurable.getEditableObject();
            parentNode = (MyNode)myNode.getParent();
            if (parentNode == null) continue;
            idx = parentNode.getIndex(myNode);
            ((DefaultTreeModel)this.myTree.getModel()).removeNodeFromParent(myNode);
            this.myHasDeletedItems |= this.wasObjectStored(editableObject);
            this.fireItemsChangeListener(editableObject);
            this.onItemDeleted(editableObject);
            namedConfigurable.disposeUIResources();
        }
        if (!nodes.isEmpty()) {
            if (parentNode != null && idx != -1) {
                DefaultMutableTreeNode toSelect2 = null;
                if (idx < parentNode.getChildCount()) {
                    toSelect2 = (DefaultMutableTreeNode)parentNode.getChildAt(idx);
                } else if (idx > 0 && parentNode.getChildCount() > 0) {
                    toSelect2 = idx - 1 < parentNode.getChildCount() ? (DefaultMutableTreeNode)parentNode.getChildAt(idx - 1) : (DefaultMutableTreeNode)parentNode.getFirstChild();
                } else if (parentNode.isRoot() && this.myTree.isRootVisible()) {
                    toSelect2 = parentNode;
                } else if (parentNode.getChildCount() > 0) {
                    toSelect2 = (DefaultMutableTreeNode)parentNode.getFirstChild();
                }
                if (toSelect2 != null) {
                    TreeUtil.selectInTree(toSelect2, true, this.myTree);
                }
            } else {
                TreeUtil.promiseSelectFirst(this.myTree);
            }
        }
    }

    protected void onItemDeleted(Object item) {
    }

    protected static Condition<Object[]> forAll(Condition<Object> condition2) {
        return objects -> {
            for (Object object : objects) {
                if (condition2.value(object)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    public JComponent getToolbar() {
        this.myToReInitWholePanel = true;
        return this.myNorthPanel;
    }

    @Override
    public JComponent getMaster() {
        this.myToReInitWholePanel = true;
        return this.myMaster;
    }

    @Override
    public DetailsComponent getDetails() {
        this.myToReInitWholePanel = true;
        return this.myDetails;
    }

    @Override
    public void initUi() {
        this.createComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MasterDetailsComponent", "createComponent"));
    }

    protected class MyActionGroupWrapper
    extends AnAction
    implements DumbAware {
        private final ActionGroup myActionGroup;
        private ActionGroupWithPreselection myPreselection;

        public MyActionGroupWrapper(ActionGroupWithPreselection actionGroup) {
            this(actionGroup.getActionGroup());
            this.myPreselection = actionGroup;
        }

        public MyActionGroupWrapper(ActionGroup actionGroup) {
            super(actionGroup.getTemplatePresentation().getText(), actionGroup.getTemplatePresentation().getDescription(), actionGroup.getTemplatePresentation().getIcon());
            this.myActionGroup = actionGroup;
            this.registerCustomShortcutSet(actionGroup.getShortcutSet(), MasterDetailsComponent.this.myTree);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionGroupWrapper.$$$reportNull$$$0(0);
            }
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            DataContext dataContext = e.getDataContext();
            ListPopupStep step = popupFactory.createActionsStep(this.myActionGroup, dataContext, "unknown", false, false, this.myActionGroup.getTemplatePresentation().getText(), MasterDetailsComponent.this.myTree, true, this.myPreselection != null ? this.myPreselection.getDefaultIndex() : 0, true);
            ListPopup listPopup = popupFactory.createListPopup(step);
            listPopup.setHandleAutoSelectionBeforeShow(true);
            if (e instanceof AnActionButton.AnActionEventWrapper) {
                ((AnActionButton.AnActionEventWrapper)e).showPopup(listPopup);
            } else {
                listPopup.showInBestPositionFor(dataContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/MasterDetailsComponent$MyActionGroupWrapper", "actionPerformed"));
        }
    }

    public static interface ActionGroupWithPreselection {
        public ActionGroup getActionGroup();

        default public int getDefaultIndex() {
            return 0;
        }
    }

    protected static interface ItemsChangeListener {
        public void itemChanged(@Nullable Object var1);

        default public void itemsExternallyChanged() {
        }
    }

    protected static class MyRootNode
    extends MyNode {
        public MyRootNode() {
            super(new NamedConfigurable(false, null){

                @Override
                public void setDisplayName(String name) {
                }

                public Object getEditableObject() {
                    return null;
                }

                @Override
                public String getBannerSlogan() {
                    return null;
                }

                @Override
                public String getDisplayName() {
                    return "";
                }

                @Override
                public JComponent createOptionsPanel() {
                    return null;
                }

                @Override
                public boolean isModified() {
                    return false;
                }

                @Override
                public void apply() {
                }
            }, false);
        }
    }

    public static class MyNode
    extends DefaultMutableTreeNode {
        private boolean myDisplayInBold;

        public MyNode(@NotNull NamedConfigurable userObject) {
            if (userObject == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            super(userObject);
        }

        public MyNode(@NotNull NamedConfigurable userObject, boolean displayInBold) {
            if (userObject == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            super(userObject);
            this.myDisplayInBold = displayInBold;
        }

        @NotNull
        public String getDisplayName() {
            NamedConfigurable configurable2 = (NamedConfigurable)this.getUserObject();
            if (configurable2 != null) {
                String string = configurable2.getDisplayName();
                if (string == null) {
                    MyNode.$$$reportNull$$$0(2);
                }
                return string;
            }
            LOG.debug("Tree was already disposed");
            return "DISPOSED";
        }

        public NamedConfigurable getConfigurable() {
            return (NamedConfigurable)this.getUserObject();
        }

        public boolean isDisplayInBold() {
            return this.myDisplayInBold;
        }

        public void setDisplayInBold(boolean displayInBold) {
            this.myDisplayInBold = displayInBold;
        }

        @Nullable
        public Icon getIcon(boolean expanded) {
            NamedConfigurable configurable2 = this.getConfigurable();
            if (configurable2 != null) {
                return configurable2.getIcon(expanded);
            }
            return null;
        }

        protected void reloadNode(DefaultTreeModel treeModel) {
            treeModel.reload(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userObject";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/MasterDetailsComponent$MyNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsComponent$MyNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class MyDeleteAction
    extends AnAction
    implements DumbAware {
        private final Condition<Object[]> myCondition;

        public MyDeleteAction() {
            this(Conditions.alwaysTrue());
        }

        public MyDeleteAction(Condition<Object[]> availableCondition) {
            super(CommonBundle.messagePointer("button.delete", new Object[0]), CommonBundle.messagePointer("button.delete", new Object[0]), PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.REMOVE), MasterDetailsComponent.this.myTree);
            this.myCondition = availableCondition;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDeleteAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath[] selectionPath = MasterDetailsComponent.this.myTree.getSelectionPaths();
            if (selectionPath != null) {
                Object[] nodes = ContainerUtil.map2Array(selectionPath, TreePath::getLastPathComponent);
                if (!this.myCondition.value(nodes)) {
                    return;
                }
                presentation.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDeleteAction.$$$reportNull$$$0(1);
            }
            MasterDetailsComponent.this.removePaths(MasterDetailsComponent.this.myTree.getSelectionPaths());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsComponent$MyDeleteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

