/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class MultiLineLabelUI
extends BasicLabelUI {
    private String myString;
    private String[] myLines;
    static final int LEADING = 10;
    static final int TRAILING = 11;
    static final int LEFT = 2;
    static final int RIGHT = 4;
    static final int TOP = 1;
    static final int CENTER = 0;

    @Override
    protected String layoutCL(JLabel label2, FontMetrics fontMetrics, String text2, Icon icon2, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String s = MultiLineLabelUI.layoutCompoundLabel(label2, fontMetrics, this.splitStringByLines(text2), icon2, label2.getVerticalAlignment(), label2.getHorizontalAlignment(), label2.getVerticalTextPosition(), label2.getHorizontalTextPosition(), viewR, iconR, textR, label2.getIconTextGap());
        if ("".equals(s)) {
            return text2;
        }
        return s;
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String[] text2, Icon icon2, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return MultiLineLabelUI.layoutCompoundLabel(fm, text2, icon2, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String[] text2, Icon icon2, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon2 != null) {
            iconR.width = icon2.getIconWidth();
            iconR.height = icon2.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text2 == null || text2.length == 0 || text2.length == 1 && (text2[0] == null || "".equals(text2[0]));
        String rettext = "";
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
        } else {
            Dimension dim = MultiLineLabelUI.computeMultiLineDimension(fm, text2);
            textR.width = dim.width;
            textR.height = dim.height;
        }
        int n = gap = textIsEmpty || icon2 == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap)) && text2.length == 1) {
            int nChars;
            String clipString = "...";
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text2[0].length() && (totalWidth += fm.charWidth(text2[0].charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            rettext = text2[0].substring(0, nChars) + clipString;
            textR.width = SwingUtilities.computeStringWidth(fm, rettext);
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return rettext;
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getForeground());
        this.drawString(g, s, accChar, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getBackground());
        this.drawString(g, s, accChar, textX, textY);
    }

    protected void drawString(Graphics g, String s, int accChar, int textX, int textY) {
        UISettings.setupAntialiasing(g);
        if (s.indexOf(10) == -1) {
            BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
        } else {
            String[] strs = this.splitStringByLines(s);
            int height = g.getFontMetrics().getHeight();
            BasicGraphicsUtils.drawString(g, strs[0], accChar, textX, textY);
            for (int i = 1; i < strs.length; ++i) {
                g.drawString(strs[i], textX, textY + height * i);
            }
        }
    }

    public static Dimension computeMultiLineDimension(FontMetrics fm, String[] strs) {
        int width = 0;
        for (String str : strs) {
            width = Math.max(width, SwingUtilities.computeStringWidth(fm, str));
        }
        return new Dimension(width, fm.getHeight() * strs.length);
    }

    public String[] splitStringByLines(String str) {
        if (str == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        if (str.equals(this.myString)) {
            return this.myLines;
        }
        this.myString = MultiLineLabelUI.convertTabs(str, 2);
        this.myLines = StringUtil.splitByLines(this.myString, false);
        return this.myLines;
    }

    public static String convertTabs(String text2, int tabLength) {
        StringBuilder buf = new StringBuilder(text2.length());
        for (int idx = 0; idx < text2.length(); ++idx) {
            char ch = text2.charAt(idx);
            if (ch == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    buf.append(' ');
                }
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }
}

