/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShadowAction {
    private final AnAction myAction;
    private AnAction myCopyFromAction;
    private final Reference<JComponent> myComponent;
    private String myActionId;
    private Presentation myPresentation;
    private final Disposable parentDisposable;
    private Disposable listenerDisposable;
    private Disposable shortcutSetDisposable;

    public ShadowAction(AnAction action2, AnAction copyFromAction, JComponent component2, Presentation presentation, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ShadowAction.$$$reportNull$$$0(0);
        }
        this(action2, copyFromAction, component2, parentDisposable);
        this.myPresentation = presentation;
    }

    public ShadowAction(AnAction action2, AnAction copyFromAction, JComponent component2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ShadowAction.$$$reportNull$$$0(1);
        }
        this.myAction = action2;
        this.parentDisposable = parentDisposable;
        this.myCopyFromAction = copyFromAction;
        this.myComponent = new WeakReference<JComponent>(component2);
        this.myActionId = ActionManager.getInstance().getId(this.myCopyFromAction);
        this.myAction.getTemplatePresentation().copyFrom(copyFromAction.getTemplatePresentation());
        Disposer.register(parentDisposable, new UiNotifyConnector(component2, new Activatable(){

            @Override
            public void showNotify() {
                ShadowAction.this._connect();
            }

            @Override
            public void hideNotify() {
                ShadowAction.this.disposeListeners();
            }
        }));
    }

    private void _connect() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        if (this.listenerDisposable == null) {
            this.listenerDisposable = Disposer.newDisposable();
            Disposer.register(this.parentDisposable, this.listenerDisposable);
            application.getMessageBus().connect(this.listenerDisposable).subscribe(KeymapManagerListener.TOPIC, new KeymapManagerListener(){

                @Override
                public void activeKeymapChanged(@Nullable Keymap keymap2) {
                    ShadowAction.this.rebound();
                }

                @Override
                public void shortcutChanged(@NotNull Keymap keymap2, @NotNull String actionId) {
                    if (keymap2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (actionId == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (ShadowAction.this.myActionId == null || actionId.equals(ShadowAction.this.myActionId)) {
                        ShadowAction.this.rebound();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "keymap";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "actionId";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/ui/ShadowAction$2";
                    objectArray[2] = "shortcutChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.rebound();
    }

    private void disposeListeners() {
        Disposable disposable2 = this.listenerDisposable;
        if (disposable2 != null) {
            this.listenerDisposable = null;
            Disposer.dispose(disposable2);
        }
        this.disposeShortcutSetListener();
    }

    private void rebound() {
        this.disposeShortcutSetListener();
        KeymapManager keymapManager2 = ShadowAction.getKeymapManager();
        if (keymapManager2 == null) {
            return;
        }
        this.myActionId = ActionManager.getInstance().getId(this.myCopyFromAction);
        if (this.myPresentation == null) {
            this.myAction.copyFrom(this.myCopyFromAction);
        } else {
            this.myAction.getTemplatePresentation().copyFrom(this.myPresentation);
            this.myAction.copyShortcutFrom(this.myCopyFromAction);
        }
        if (this.myActionId == null) {
            return;
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        if (keymap2 == null) {
            return;
        }
        CustomShortcutSet shortcutSet = new CustomShortcutSet(keymap2.getShortcuts(this.myActionId));
        this.shortcutSetDisposable = Disposer.newDisposable();
        Disposer.register(this.parentDisposable, this.shortcutSetDisposable);
        this.myAction.registerCustomShortcutSet(shortcutSet, this.myComponent.get(), this.shortcutSetDisposable);
    }

    private void disposeShortcutSetListener() {
        Disposable disposable2 = this.shortcutSetDisposable;
        if (disposable2 != null) {
            this.shortcutSetDisposable = null;
            Disposer.dispose(disposable2);
        }
    }

    @Nullable
    private static KeymapManager getKeymapManager() {
        return ApplicationManager.getApplication().isDisposed() ? null : KeymapManager.getInstance();
    }

    public void reconnect(AnAction copyFromAction) {
        this.myCopyFromAction = copyFromAction;
        this._connect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/ui/ShadowAction", "<init>"));
    }
}

