/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int BOTTOM = 2;
    public static final int MIDDLE = 1;
    public static final int TOP = 0;
    private boolean myVerticalFill;
    private boolean myHorizontalFill;
    private final int vGap;
    private final int hGap;

    public VerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VerticalFlowLayout(@VerticalFlowAlignment int alignment) {
        this(alignment, 5, 5, true, false);
    }

    public VerticalFlowLayout(boolean fillHorizontally, boolean fillVertically) {
        this(0, 5, 5, fillHorizontally, fillVertically);
    }

    public VerticalFlowLayout(@VerticalFlowAlignment int alignment, boolean fillHorizontally, boolean fillVertically) {
        this(alignment, 5, 5, fillHorizontally, fillVertically);
    }

    public VerticalFlowLayout(int hGap, int vGap) {
        this(0, hGap, vGap, true, false);
    }

    public VerticalFlowLayout(@VerticalFlowAlignment int alignment, int hGap, int vGap, boolean fillHorizontally, boolean fillVertically) {
        this.setAlignment(alignment);
        this.hGap = hGap;
        this.vGap = vGap;
        this.myHorizontalFill = fillHorizontally;
        this.myVerticalFill = fillVertically;
    }

    @Override
    public void layoutContainer(Container container2) {
        Insets insets = container2.getInsets();
        int i = container2.getSize().height - (insets.top + insets.bottom + this.vGap * 2);
        int j = container2.getSize().width - (insets.left + insets.right + this.hGap * 2);
        int k = container2.getComponentCount();
        int l = insets.left + this.hGap;
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        for (int l1 = 0; l1 < k; ++l1) {
            Component component2 = container2.getComponent(l1);
            if (!component2.isVisible()) continue;
            Dimension dimension = component2.getPreferredSize();
            if (this.myVerticalFill && l1 == k - 1) {
                dimension.height = Math.max(i - i1, component2.getPreferredSize().height);
            }
            if (this.myHorizontalFill) {
                component2.setSize(j, dimension.height);
                dimension.width = j;
            } else {
                component2.setSize(dimension.width, dimension.height);
            }
            if (i1 + dimension.height > i) {
                this.a(container2, l, insets.top + this.vGap, j1, i - i1, k1, l1);
                i1 = dimension.height;
                l += this.hGap + j1;
                j1 = dimension.width;
                k1 = l1;
                continue;
            }
            if (i1 > 0) {
                i1 += this.vGap;
            }
            i1 += dimension.height;
            j1 = Math.max(j1, dimension.width);
        }
        this.a(container2, l, insets.top + this.vGap, j1, i - i1, k1, k);
    }

    private void a(Container container2, int i, int j, int k, int l, int i1, int j1) {
        int k1 = this.getAlignment();
        if (k1 == 1) {
            j += l / 2;
        }
        if (k1 == 2) {
            j += l;
        }
        for (int l1 = i1; l1 < j1; ++l1) {
            Component component2 = container2.getComponent(l1);
            Dimension dimension = component2.getSize();
            if (!component2.isVisible()) continue;
            int i2 = i + (k - dimension.width) / 2;
            component2.setLocation(i2, j);
            j += this.vGap + dimension.height;
        }
    }

    public boolean getHorizontalFill() {
        return this.myHorizontalFill;
    }

    public void setHorizontalFill(boolean flag) {
        this.myHorizontalFill = flag;
    }

    public boolean getVerticalFill() {
        return this.myVerticalFill;
    }

    public void setVerticalFill(boolean flag) {
        this.myVerticalFill = flag;
    }

    @Override
    public Dimension minimumLayoutSize(Container container2) {
        JBDimension dimension = JBUI.emptySize();
        for (int i = 0; i < container2.getComponentCount(); ++i) {
            Component component2 = container2.getComponent(i);
            if (!component2.isVisible()) continue;
            Dimension dimension1 = component2.getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension1.width);
            if (i > 0) {
                dimension.height += this.vGap;
            }
            dimension.height += dimension1.height;
        }
        this.addInsets(dimension, container2);
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container2) {
        JBDimension dimension = JBUI.emptySize();
        for (int i = 0; i < container2.getComponentCount(); ++i) {
            Component component2 = container2.getComponent(i);
            if (!component2.isVisible()) continue;
            Dimension dimension1 = component2.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension1.width);
            if (i > 0) {
                dimension.height += this.vGap;
            }
            dimension.height += dimension1.height;
        }
        this.addInsets(dimension, container2);
        return dimension;
    }

    private void addInsets(Dimension dimension, Container container2) {
        JBInsets.addTo(dimension, container2.getInsets());
        dimension.width += this.hGap + this.hGap;
        dimension.height += this.vGap + this.vGap;
    }

    public static @interface VerticalFlowAlignment {
    }
}

