/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.cellvalidators;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class StatefulValidatingCellEditor
extends DefaultCellEditor
implements Supplier<ValidationInfo> {
    private Consumer<ValidationInfo> stateUpdater;

    public StatefulValidatingCellEditor(JTextField textField2, Disposable disposable2) {
        super(textField2);
        this.stateUpdater = vi -> {};
        this.editorComponent.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
        new ComponentValidator(disposable2).withValidator(this).installOn(this.editorComponent);
        DocumentAdapter dl = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                StatefulValidatingCellEditor.this.editorComponent.putClientProperty("CellRenderer.validationInfo", null);
                ComponentValidator.getInstance(StatefulValidatingCellEditor.this.editorComponent).ifPresent(ComponentValidator::revalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/cellvalidators/StatefulValidatingCellEditor$1", "textChanged"));
            }
        };
        textField2.getDocument().addDocumentListener(dl);
        Disposer.register(disposable2, () -> textField2.getDocument().removeDocumentListener(dl));
    }

    public StatefulValidatingCellEditor(JComboBox comboBox2, Disposable disposable2) {
        super(comboBox2);
        this.stateUpdater = vi -> {};
        this.editorComponent.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
        new ComponentValidator(disposable2).withValidator(this).installOn(this.editorComponent);
        ItemListener il = e -> {
            this.editorComponent.putClientProperty("CellRenderer.validationInfo", null);
            ComponentValidator.getInstance(this.editorComponent).ifPresent(ComponentValidator::revalidate);
        };
        comboBox2.addItemListener(il);
        Disposer.register(disposable2, () -> comboBox2.removeItemListener(il));
    }

    @ApiStatus.Experimental
    public StatefulValidatingCellEditor withStateUpdater(@NotNull Consumer<ValidationInfo> stateUpdater) {
        if (stateUpdater == null) {
            StatefulValidatingCellEditor.$$$reportNull$$$0(0);
        }
        this.stateUpdater = stateUpdater;
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        ValidationInfo cellInfo;
        JComponent editor = (JComponent)super.getTableCellEditorComponent(table, value2, isSelected, row, column);
        JComponent renderer = (JComponent)table.getCellRenderer(row, column).getTableCellRendererComponent(table, value2, isSelected, true, row, column);
        ValidationInfo validationInfo = cellInfo = renderer != null ? (ValidationInfo)renderer.getClientProperty("CellRenderer.validationInfo") : null;
        if (cellInfo != null) {
            editor.putClientProperty("CellRenderer.validationInfo", cellInfo.forComponent(editor));
            ComponentValidator.getInstance(editor).ifPresent(ComponentValidator::revalidate);
        }
        return editor;
    }

    @Override
    public boolean stopCellEditing() {
        this.editorComponent.putClientProperty("CellRenderer.validationInfo", null);
        ComponentValidator.getInstance(this.editorComponent).ifPresent(ComponentValidator::revalidate);
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editorComponent.putClientProperty("CellRenderer.validationInfo", null);
        ComponentValidator.getInstance(this.editorComponent).ifPresent(ComponentValidator::revalidate);
        super.cancelCellEditing();
    }

    @Override
    public ValidationInfo get() {
        ValidationInfo info = (ValidationInfo)this.editorComponent.getClientProperty("CellRenderer.validationInfo");
        this.stateUpdater.accept(info);
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateUpdater", "com/intellij/openapi/ui/cellvalidators/StatefulValidatingCellEditor", "withStateUpdater"));
    }
}

