/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlassPaneDialogWrapperPeer
extends DialogWrapperPeer {
    private static final Logger LOG = Logger.getInstance(GlassPaneDialogWrapperPeer.class);
    private final DialogWrapper myWrapper;
    private MyDialog myDialog;

    public GlassPaneDialogWrapperPeer(@Nullable Project project2, DialogWrapper wrapper2) throws GlasspanePeerUnavailableException {
        this.myWrapper = wrapper2;
        Window window = null;
        if (LoadingState.APP_STARTED.isOccurred()) {
            Window focusedWindow;
            WindowManagerEx windowManager;
            if (project2 == null) {
                project2 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            if ((window = (windowManager = WindowManagerEx.getInstanceEx()).suggestParentWindow(project2)) == null && (focusedWindow = windowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
        }
        Frame owner = window != null ? window : JOptionPane.getRootFrame();
        this.createDialog(owner);
    }

    public GlassPaneDialogWrapperPeer(@NotNull DialogWrapper wrapper2) throws GlasspanePeerUnavailableException {
        if (wrapper2 == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(0);
        }
        this(null, wrapper2);
    }

    public GlassPaneDialogWrapperPeer(DialogWrapper wrapper2, @NotNull Component parent) throws GlasspanePeerUnavailableException {
        if (parent == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(1);
        }
        this.myWrapper = wrapper2;
        if (!parent.isShowing() && parent != JOptionPane.getRootFrame()) {
            throw new IllegalArgumentException("parent must be showing: " + parent);
        }
        Window owner = ComponentUtil.getWindow(parent);
        if (!(owner instanceof Dialog) && !(owner instanceof Frame)) {
            owner = JOptionPane.getRootFrame();
        }
        this.createDialog(owner);
    }

    private void createDialog(Window owner) throws GlasspanePeerUnavailableException {
        Component glassPane;
        Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (active instanceof JDialog || !(owner instanceof IdeFrame)) {
            throw new GlasspanePeerUnavailableException();
        }
        if (owner instanceof JFrame) {
            glassPane = ((JFrame)owner).getGlassPane();
        } else if (owner instanceof JDialog) {
            glassPane = ((JDialog)owner).getGlassPane();
        } else {
            throw new IllegalStateException("Cannot find glass pane for " + owner.getClass().getName());
        }
        assert (glassPane instanceof IdeGlassPaneEx) : "GlassPane should be instance of IdeGlassPane!";
        this.myDialog = new MyDialog((IdeGlassPaneEx)((Object)glassPane), this.myWrapper);
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        LOG.assertTrue(undecorated, "Decorated dialogs are not supported!");
    }

    @Override
    public void addMouseListener(MouseListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public void addMouseListener(MouseMotionListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public void addKeyListener(KeyListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public void toFront() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public void toBack() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), "Access is allowed from event dispatch thread only");
        if (this.myDialog != null) {
            Disposer.dispose(this.myDialog);
            this.myDialog = null;
        }
    }

    @Override
    public Container getContentPane() {
        return this.myDialog.getContentPane();
    }

    @Override
    public Window getOwner() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public Window getWindow() {
        return null;
    }

    @Override
    public JRootPane getRootPane() {
        if (this.myDialog == null) {
            return null;
        }
        return this.myDialog.getRootPane();
    }

    @Override
    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    @Override
    public void setModal(boolean modal) {
        LOG.assertTrue(modal, "Can't be non modal!");
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.myDialog != null && this.myDialog.isVisible();
    }

    @Override
    public boolean isShowing() {
        return this.myDialog != null && this.myDialog.isShowing();
    }

    @Override
    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void isResizable() {
    }

    @Override
    public void setResizable(boolean resizable) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(2);
        }
        return point;
    }

    @Override
    public void setLocation(@NotNull Point p) {
        if (p == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(3);
        }
        this.setLocation(p.x, p.y);
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.myDialog == null || !this.myDialog.isShowing()) {
            return;
        }
        Point _p = new Point(x, y);
        JRootPane pane2 = SwingUtilities.getRootPane(this.myDialog);
        SwingUtilities.convertPointFromScreen(_p, pane2);
        this.myDialog.setLocation(_p.x, _p.y);
    }

    @Override
    public ActionCallback show() {
        LOG.assertTrue(EventQueue.isDispatchThread(), "Access is allowed from event dispatch thread only");
        this.hidePopupsIfNeeded();
        this.myDialog.setVisible(true);
        return ActionCallback.DONE;
    }

    @Override
    public void setContentPane(JComponent content2) {
        this.myDialog.setContentPane(content2);
    }

    @Override
    public void centerInParent() {
        if (this.myDialog != null) {
            this.myDialog.center();
        }
    }

    @Override
    public void validate() {
        if (this.myDialog != null) {
            this.myDialog.resetSizeCache();
            this.myDialog.invalidate();
        }
    }

    @Override
    public void repaint() {
        if (this.myDialog != null) {
            this.myDialog.repaint();
        }
    }

    @Override
    public void pack() {
    }

    @Override
    public void setAppIcons() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    public boolean isHeadless() {
        return DialogWrapperPeerImpl.isHeadlessEnv();
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfo.isMac) {
            return;
        }
        final StackingPopupDispatcher stackingPopupDispatcher = StackingPopupDispatcher.getInstance();
        stackingPopupDispatcher.hidePersistentPopups();
        Disposer.register(this.myDialog, new Disposable(){

            @Override
            public void dispose() {
                stackingPopupDispatcher.restorePersistentPopups();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TransparentLayeredPane
    extends JBLayeredPane {
        private TransparentLayeredPane() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){});
            this.addMouseMotionListener(new MouseMotionAdapter(){});
        }

        @Override
        public void addNotify() {
            Container container2 = this.getParent();
            if (container2 != null) {
                this.setBounds(0, 0, container2.getWidth(), container2.getHeight());
            }
            super.addNotify();
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return this.getComponentCount() <= 1;
        }
    }

    public static class GlasspanePeerUnavailableException
    extends Exception {
    }

    private static class MyRootPane
    extends JRootPane
    implements Disposable {
        private MyDialog myDialog;

        private MyRootPane(MyDialog dialog2) {
            this.myDialog = dialog2;
        }

        @Override
        protected JLayeredPane createLayeredPane() {
            JBLayeredPane p = new JBLayeredPane();
            p.setName(this.getName() + ".layeredPane");
            return p;
        }

        @Override
        public void dispose() {
            DialogWrapper.cleanupRootPane(this);
            this.myDialog = null;
        }

        @Override
        public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke, int aCondition) {
            this.myDialog.registerKeyboardAction(anAction, aCommand, aKeyStroke, aCondition);
        }

        @Override
        public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
            this.myDialog.unregisterKeyboardAction(aKeyStroke);
        }

        @Override
        public void setDefaultButton(JButton defaultButton) {
            this.myDialog.setDefaultButton(defaultButton);
        }

        @Override
        public void setContentPane(Container contentPane) {
            super.setContentPane(contentPane);
            contentPane.addMouseMotionListener(new MouseMotionAdapter(){});
        }
    }

    private static class MyDialog
    extends JPanel
    implements Disposable,
    DialogWrapperDialog,
    DataProvider {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private final IdeGlassPaneEx myPane;
        private JComponent myContentPane;
        private MyRootPane myRootPane;
        private BufferedImage shadow;
        private int shadowWidth;
        private int shadowHeight;
        private final JLayeredPane myTransparentPane;
        private final Container myWrapperPane;
        private Component myPreviouslyFocusedComponent;
        private Dimension myCachedSize = null;

        private MyDialog(IdeGlassPaneEx pane2, DialogWrapper wrapper2) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(AllIcons.Ide.Shadow.Top.getIconHeight(), AllIcons.Ide.Shadow.Left.getIconWidth(), AllIcons.Ide.Shadow.Bottom.getIconHeight(), AllIcons.Ide.Shadow.Right.getIconWidth()));
            this.myPane = pane2;
            this.myDialogWrapper = new WeakReference<DialogWrapper>(wrapper2);
            this.myRootPane = new MyRootPane(this);
            Disposer.register(this, this.myRootPane);
            this.myContentPane = new JPanel();
            this.myContentPane.setOpaque(true);
            this.add((Component)this.myContentPane, "Center");
            this.myTransparentPane = this.createTransparentPane();
            this.myWrapperPane = this.createWrapperPane();
            this.myWrapperPane.add(this);
            this.setFocusCycleRoot(true);
        }

        public void resetSizeCache() {
            this.myCachedSize = null;
        }

        private Container createWrapperPane() {
            JPanel result2 = new JPanel(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doLayout() {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        Container container2 = this.getParent();
                        if (container2 != null) {
                            Component[] components = this.getComponents();
                            LOG.assertTrue(components.length == 1);
                            for (Component c : components) {
                                Point location2;
                                if (myCachedSize == null) {
                                    myCachedSize = c.getPreferredSize();
                                    location2 = this.getLocationInCenter(myCachedSize, c.getLocation());
                                } else {
                                    location2 = c.getLocation();
                                }
                                double _width = myCachedSize.getWidth();
                                double _height = myCachedSize.getHeight();
                                DialogWrapper dialogWrapper2 = (DialogWrapper)myDialogWrapper.get();
                                if (dialogWrapper2 != null) {
                                    int width = (int)(_width * (double)dialogWrapper2.getHorizontalStretch());
                                    int height = (int)(_height * (double)dialogWrapper2.getVerticalStretch());
                                    c.setBounds((int)location2.getX(), (int)location2.getY(), width, height);
                                    continue;
                                }
                                c.setBounds((int)location2.getX(), (int)location2.getY(), (int)_width, (int)_height);
                            }
                        }
                    }
                    super.doLayout();
                }
            };
            result2.setLayout(null);
            result2.setOpaque(false);
            result2.addMouseListener(new MouseAdapter(){});
            result2.addMouseMotionListener(new MouseMotionAdapter(){});
            return result2;
        }

        private TransparentLayeredPane getExistingTransparentPane() {
            for (int i = 0; i < this.myPane.getComponentCount(); ++i) {
                Component c = this.myPane.getComponent(i);
                if (!(c instanceof TransparentLayeredPane)) continue;
                return (TransparentLayeredPane)c;
            }
            return null;
        }

        private boolean isTransparentPaneExist() {
            for (int i = 0; i < this.myPane.getComponentCount(); ++i) {
                Component c = this.myPane.getComponent(i);
                if (!(c instanceof TransparentLayeredPane)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setVisible(boolean show2) {
            if (show2) {
                if (!this.isTransparentPaneExist()) {
                    this.myPane.add(this.myTransparentPane);
                } else {
                    this.myPreviouslyFocusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                }
                this.myTransparentPane.add(this.myWrapperPane);
                this.myTransparentPane.setLayer(this.myWrapperPane, this.myTransparentPane.getComponentCount() - 1);
                if (!this.myTransparentPane.isVisible()) {
                    this.myTransparentPane.setVisible(true);
                }
            }
            super.setVisible(show2);
            if (show2) {
                this.myTransparentPane.revalidate();
                this.myTransparentPane.repaint();
            } else {
                this.myTransparentPane.remove(this.myWrapperPane);
                this.myTransparentPane.revalidate();
                this.myTransparentPane.repaint();
                if (this.myPreviouslyFocusedComponent != null) {
                    Component component2 = this.myPreviouslyFocusedComponent;
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component2, true));
                    this.myPreviouslyFocusedComponent = null;
                }
                if (this.myTransparentPane.getComponentCount() == 0) {
                    this.myTransparentPane.setVisible(false);
                    this.myPane.remove(this.myTransparentPane);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing(g);
            super.paint(g);
        }

        private JLayeredPane createTransparentPane() {
            TransparentLayeredPane pane2 = this.getExistingTransparentPane();
            if (pane2 == null) {
                pane2 = new TransparentLayeredPane();
            }
            return pane2;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.shadow != null) {
                UIUtil.drawImage((Graphics)g2, (Image)this.shadow, 0, 0, null);
            }
            super.paintComponent(g);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            JLayeredPane p = this.myTransparentPane;
            if (p != null) {
                Rectangle bounds2 = new Rectangle(((Component)p).getWidth() - width, ((Component)p).getHeight() - height);
                JBInsets.removeFrom(bounds2, this.getInsets());
                x = bounds2.width < 0 ? bounds2.width / 2 : Math.min(bounds2.x + bounds2.width, Math.max(bounds2.x, x));
                y = bounds2.height < 0 ? bounds2.height / 2 : Math.min(bounds2.y + bounds2.height, Math.max(bounds2.y, y));
            }
            super.setBounds(x, y, width, height);
            if (RemoteDesktopService.isRemoteSession()) {
                this.shadow = null;
            } else if (this.shadow == null || this.shadowWidth != width || this.shadowHeight != height) {
                this.shadow = ShadowBorderPainter.createShadow(this, width, height);
                this.shadowWidth = width;
                this.shadowHeight = height;
            }
        }

        @Override
        public void dispose() {
            this.remove(this.getContentPane());
            this.setVisible(false);
            DialogWrapper.unregisterKeyboardActions(this.myWrapperPane);
            this.myRootPane = null;
        }

        public void setContentPane(JComponent content2) {
            if (this.myContentPane != null) {
                this.remove(this.myContentPane);
                this.myContentPane = null;
            }
            this.myContentPane = content2;
            this.myContentPane.setOpaque(true);
            this.add((Component)this.myContentPane, "Center");
        }

        public JComponent getContentPane() {
            return this.myContentPane;
        }

        @Override
        public JRootPane getRootPane() {
            return this.myRootPane;
        }

        @Override
        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        @Override
        public Object getData(@NotNull @NonNls String dataId) {
            DialogWrapper wrapper2;
            if (dataId == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            if ((wrapper2 = (DialogWrapper)this.myDialogWrapper.get()) instanceof DataProvider) {
                return ((DataProvider)((Object)wrapper2)).getData(dataId);
            }
            if (wrapper2 instanceof TypeSafeDataProvider) {
                TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)((Object)wrapper2));
                return adapter.getData(dataId);
            }
            return null;
        }

        @Override
        public void setSize(int width, int height) {
            Point location2 = this.getLocation();
            Rectangle rect = new Rectangle(location2.x, location2.y, width, height);
            ScreenUtil.fitToScreen(rect);
            if (location2.x != rect.x || location2.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Nullable
        private Point getLocationInCenter(Dimension size, @Nullable Point _default) {
            if (this.myTransparentPane != null) {
                Dimension d = this.myTransparentPane.getSize();
                return new Point((d.width - size.width) / 2, (d.height - size.height) / 2);
            }
            return _default;
        }

        public void center() {
            Point location2 = this.getLocationInCenter(this.getSize(), null);
            if (location2 != null) {
                this.setLocation(location2);
                this.repaint();
            }
        }

        public void setDefaultButton(JButton defaultButton) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer$MyDialog", "getData"));
        }
    }
}

