/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class DetectedPluginsPanel
extends OrderPanel<PluginDownloader> {
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final JEditorPane myDescriptionPanel = new JEditorPane();
    private final PluginHeaderPanel myHeader;

    public DetectedPluginsPanel() {
        super(PluginDownloader.class);
        final JTable entryTable = this.getEntryTable();
        this.myHeader = new PluginHeaderPanel();
        entryTable.setTableHeader(null);
        entryTable.setDefaultRenderer(PluginDownloader.class, new ColoredTableCellRenderer(){

            @Override
            protected void customizeCellRenderer(JTable table, Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                this.setBorder(null);
                PluginDownloader downloader = (PluginDownloader)value2;
                if (downloader != null) {
                    String loadedVersion;
                    String oldPluginName;
                    String pluginName = downloader.getPluginName();
                    this.append(pluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(downloader.getId());
                    if (ideaPluginDescriptor != null && !Comparing.strEqual(pluginName, oldPluginName = ideaPluginDescriptor.getName())) {
                        this.append(" - " + oldPluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    if ((loadedVersion = downloader.getPluginVersion()) != null || ideaPluginDescriptor != null && ideaPluginDescriptor.getVersion() != null) {
                        String installedVersion = ideaPluginDescriptor != null && ideaPluginDescriptor.getVersion() != null ? ideaPluginDescriptor.getVersion() + (loadedVersion != null ? " " + UIUtil.rightArrow() + " " : "") : "";
                        String availableVersion = loadedVersion != null ? loadedVersion : "";
                        this.append(" " + installedVersion + availableVersion, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                    }
                }
            }
        });
        entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = entryTable.getSelectedRow();
                if (selectedRow != -1) {
                    PluginDownloader selection = (PluginDownloader)DetectedPluginsPanel.this.getValueAt(selectedRow);
                    IdeaPluginDescriptor descriptor2 = selection.getDescriptor();
                    PluginManagerMain.pluginInfoUpdate(descriptor2, null, DetectedPluginsPanel.this.myDescriptionPanel, DetectedPluginsPanel.this.myHeader);
                }
            }
        });
        this.setCheckboxColumnName("");
        this.myDescriptionPanel.setPreferredSize(new JBDimension(600, 400));
        this.myDescriptionPanel.setEditable(false);
        this.myDescriptionPanel.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myDescriptionPanel.addHyperlinkListener(new PluginManagerMain.MyHyperlinkListener());
        this.removeAll();
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setFirstComponent(DetectedPluginsPanel.wrapWithPane(entryTable, 1, 0));
        splitter.setSecondComponent(DetectedPluginsPanel.wrapWithPane(this.myDescriptionPanel, 0, 1));
        this.add((Component)splitter, "Center");
    }

    @NotNull
    private static JScrollPane wrapWithPane(@NotNull JComponent c, int left, int right) {
        if (c == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(0);
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane(c);
        pane2.setBorder(JBUI.Borders.customLine(OnePixelDivider.BACKGROUND, 1, left, 1, right));
        JScrollPane jScrollPane = pane2;
        if (jScrollPane == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(1);
        }
        return jScrollPane;
    }

    @Override
    public String getCheckboxColumnName() {
        return "";
    }

    @Override
    public boolean isCheckable(PluginDownloader downloader) {
        return true;
    }

    @Override
    public boolean isChecked(PluginDownloader downloader) {
        return !this.getSkippedPlugins().contains(downloader.getId());
    }

    @Override
    public void setChecked(PluginDownloader downloader, boolean checked) {
        if (checked) {
            this.getSkippedPlugins().remove(downloader.getId());
        } else {
            this.getSkippedPlugins().add(downloader.getId());
        }
        for (Listener listener2 : this.myListeners) {
            listener2.stateChanged();
        }
    }

    protected Set<PluginId> getSkippedPlugins() {
        return UpdateChecker.getDisabledToUpdate();
    }

    public void addStateListener(Listener l) {
        this.myListeners.add(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPane";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void stateChanged();
    }
}

