/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoPanelUI;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002JP\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u001e\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010'\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J.\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J4\u0010.\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInfoPanelUI;", "", "()V", "DEFAULT_MAX_HEIGHT", "", "DEFAULT_MIN_HEIGHT", "DEFAULT_WIDTH", "DIVIDER_COLOR", "Lcom/intellij/ui/JBColor;", "FROM_TO_PATCHES_REGEXP", "Lkotlin/text/Regex;", "MB_UNITS", "", "PATCH_SIZE_IS", "calculatePatchSize", "patchesChain", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "testPatch", "Ljava/io/File;", "createPanel", "Ljavax/swing/JPanel;", "newBuild", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "patches", "writeProtected", "", "licenseInfo", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Color;", "enableLink", "updatedChannel", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "downloadUrl", "newBuildInfo", "updateChannel", "getConfigLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "panel", "text", "getPatchesText", "getSettingsLink", "appNames", "Lcom/intellij/openapi/application/ApplicationNamesInfo;", "smallFont", "Ljava/awt/Font;", "font", "updateHighlightsContent", "intellij.platform.ide.impl"})
public final class UpdateInfoPanelUI {
    private static final String MB_UNITS = "MB";
    private static final String PATCH_SIZE_IS = "Patch size is";
    private static final Regex FROM_TO_PATCHES_REGEXP;
    private static final JBColor DIVIDER_COLOR;
    private static final int DEFAULT_MIN_HEIGHT = 300;
    private static final int DEFAULT_MAX_HEIGHT = 600;
    private static final int DEFAULT_WIDTH = 700;
    public static final UpdateInfoPanelUI INSTANCE;

    @NotNull
    public final JPanel createPanel(@NotNull BuildInfo newBuild, @Nullable UpdateChain patches2, @Nullable File testPatch, boolean writeProtected, @Nullable Pair<String, Color> licenseInfo, boolean enableLink, @NotNull UpdateChannel updatedChannel) {
        Intrinsics.checkParameterIsNotNull((Object)newBuild, (String)"newBuild");
        Intrinsics.checkParameterIsNotNull((Object)updatedChannel, (String)"updatedChannel");
        JPanel panel2 = new JPanel(new BorderLayout());
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        ApplicationNamesInfo appNames = applicationNamesInfo;
        JEditorPane jEditorPane = new JEditorPane("text/html", ""){};
        boolean bl = false;
        boolean bl2 = false;
        JEditorPane it322 = jEditorPane;
        boolean bl3 = false;
        String string = UIUtil.getCssFontDeclaration(UIUtil.getLabelFont());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UIUtil.getCssFontDeclara\u2026on(UIUtil.getLabelFont())");
        String cssFontDeclaration = string;
        String updateHighlightsContent22 = INSTANCE.updateHighlightsContent(appNames, patches2, testPatch, newBuild, updatedChannel);
        it322.setText("<html><head>" + cssFontDeclaration + "</head><body>" + updateHighlightsContent22 + "</body></html>");
        it322.addHyperlinkListener(createPanel.updateHighlightsComponent.2.1.INSTANCE);
        it322.setCaretPosition(0);
        it322.setEditable(false);
        it322.setBorder(JBUI.Borders.empty(10, 16));
        it322.addHyperlinkListener(BrowserHyperlinkListener.INSTANCE);
        JEditorPane updateHighlightsComponent2 = jEditorPane;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)updateHighlightsComponent2, true);
        bl2 = false;
        boolean it322 = false;
        JScrollPane it = jScrollPane;
        boolean bl4 = false;
        JScrollPane jScrollPane2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane2, (String)"it");
        jScrollPane2.setBorder(JBUI.Borders.customLine(DIVIDER_COLOR, 0, 0, 1, 0));
        int updateHighlightsContent22 = it.getPreferredSize().width;
        int n = 700;
        JScrollPane jScrollPane3 = it;
        boolean bl5 = false;
        int n2 = Math.min(updateHighlightsContent22, n);
        int n3 = RangesKt.coerceIn((int)it.getPreferredSize().height, (int)300, (int)600);
        int n4 = n2;
        jScrollPane3.setPreferredSize(new Dimension(n4, n3));
        JScrollPane jScrollPane4 = jScrollPane;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane4, (String)"ScrollPaneFactory.create\u2026AULT_MAX_HEIGHT))\n      }");
        JScrollPane updateHighlightsScrollPane = jScrollPane4;
        JBLabel jBLabel = new JBLabel();
        it322 = false;
        boolean bl6 = false;
        JBLabel it2 = jBLabel;
        boolean bl7 = false;
        it2.setBorder(JBUI.Borders.empty());
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES");
        it2.setForeground(simpleTextAttributes.getFgColor());
        String patchSize = INSTANCE.calculatePatchSize(patches2, testPatch);
        StringBuilder stringBuilder = new StringBuilder().append("Updating ");
        ApplicationInfo applicationInfo = appInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"appInfo");
        it2.setText(stringBuilder.append(applicationInfo.getFullVersion()).append(" to ").append(newBuild.getVersion()).append(" (").append(newBuild.getNumber()).append(").").append(patchSize).toString());
        Font font = it2.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"it.font");
        it2.setFont(INSTANCE.smallFont(font));
        JBLabel updatingVersionAndPatches = jBLabel;
        JPanel it322 = new JPanel(new FlowLayout(0, 2, 0));
        bl6 = false;
        boolean bl8 = false;
        JPanel it4 = it322;
        boolean bl9 = false;
        it4.setBorder(JBUI.Borders.empty(1, 16));
        it4.add(updatingVersionAndPatches);
        LinkLabel<?> linkLabel = INSTANCE.getSettingsLink(panel2, writeProtected, enableLink, appNames);
        if (linkLabel != null) {
            LinkLabel<?> linkLabel2 = linkLabel;
            boolean bl10 = false;
            boolean bl11 = false;
            LinkLabel<?> link = linkLabel2;
            boolean bl12 = false;
            it4.add(link);
        }
        JPanel updatingInfoPanel = it322;
        JPanel jPanel = new JPanel(new VerticalFlowLayout(0, 0));
        bl8 = false;
        boolean bl13 = false;
        JPanel it5 = jPanel;
        boolean bl14 = false;
        it5.setBorder(JBUI.Borders.empty(8, 0));
        if (licenseInfo != null) {
            JBLabel jBLabel2 = new JBLabel((String)licenseInfo.first);
            boolean bl15 = false;
            boolean bl16 = false;
            JBLabel label2 = jBLabel2;
            boolean bl17 = false;
            UpdateInfoPanelUI updateInfoPanelUI = INSTANCE;
            boolean bl18 = false;
            boolean bl19 = false;
            UpdateInfoPanelUI $this$run = updateInfoPanelUI;
            boolean bl20 = false;
            label2.setForeground((Color)licenseInfo.second);
            label2.setBorder(JBUI.Borders.empty(1, 16));
            Font font2 = label2.getFont();
            Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"label.font");
            label2.setFont($this$run.smallFont(font2));
            JBLabel licensePanel = jBLabel2;
            it5.add(licensePanel);
        }
        it5.add(updatingInfoPanel);
        JPanel infoPanel = jPanel;
        jPanel = panel2;
        bl8 = false;
        bl13 = false;
        it5 = jPanel;
        boolean bl21 = false;
        it5.add((Component)updateHighlightsScrollPane, "Center");
        it5.add((Component)infoPanel, "South");
        return jPanel;
    }

    private final Font smallFont(Font font) {
        Font font2;
        if (SystemInfoRt.isMac) {
            Font font3 = FontUtil.minusOne(font);
            font2 = font3;
            Intrinsics.checkExpressionValueIsNotNull((Object)font3, (String)"FontUtil.minusOne(font)");
        } else if (SystemInfoRt.isLinux) {
            Font font4 = FontUtil.minusOne(FontUtil.minusOne(font));
            font2 = font4;
            Intrinsics.checkExpressionValueIsNotNull((Object)font4, (String)"FontUtil.minusOne(FontUtil.minusOne(font))");
        } else {
            font2 = font;
        }
        return font2;
    }

    private final LinkLabel<?> getSettingsLink(JPanel panel2, boolean writeProtected, boolean enableLink, ApplicationNamesInfo appNames) {
        LinkLabel<?> linkLabel;
        if (!enableLink) {
            return null;
        }
        if (writeProtected) {
            LinkLabel<?> linkLabel2 = this.getConfigLink(panel2, IdeBundle.message("updates.write.protected", appNames.getProductName(), PathManager.getHomePath()));
            boolean bl = false;
            boolean bl2 = false;
            LinkLabel<?> it = linkLabel2;
            boolean bl3 = false;
            it.setForeground(JBColor.RED);
            linkLabel = linkLabel2;
        } else {
            linkLabel = this.getConfigLink(panel2, IdeBundle.message("updates.configure.updates.label", new Object[0]));
        }
        return linkLabel;
    }

    private final LinkLabel<?> getConfigLink(JPanel panel2, String text2) {
        LinkLabel<?> linkLabel = LinkLabel.create(text2, new Runnable(panel2){
            final /* synthetic */ JPanel $panel;

            public final void run() {
                ShowSettingsUtil.getInstance().editConfigurable((Component)this.$panel, (Configurable)new UpdateSettingsConfigurable(false));
            }
            {
                this.$panel = jPanel;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        LinkLabel<?> it = linkLabel;
        boolean bl3 = false;
        LinkLabel<?> linkLabel2 = it;
        Intrinsics.checkExpressionValueIsNotNull(linkLabel2, (String)"it");
        Font font = it.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"it.font");
        linkLabel2.setFont(INSTANCE.smallFont(font));
        LinkLabel<?> linkLabel3 = linkLabel;
        Intrinsics.checkExpressionValueIsNotNull(linkLabel3, (String)"LinkLabel.create(text) {\u2026nt = smallFont(it.font) }");
        return linkLabel3;
    }

    private final String getPatchesText(UpdateChain patches2, File testPatch) {
        String string;
        if (patches2 != null && !StringUtil.isEmptyOrSpaces(patches2.getSize())) {
            string = patches2.getSize();
        } else if (testPatch != null) {
            long l = 1L;
            long l2 = testPatch.length() >> 20;
            boolean bl = false;
            string = String.valueOf(Math.max(l, l2));
        } else {
            string = null;
        }
        return string;
    }

    private final String updateHighlightsContent(ApplicationNamesInfo appNames, UpdateChain patches2, File testPatch, BuildInfo newBuildInfo, UpdateChannel updateChannel) {
        ButtonInfo it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String message = newBuildInfo.getMessage();
        if (StringsKt.isBlank((CharSequence)message)) {
            String string = IdeBundle.message("updates.new.version.available", appNames.getFullProductName(), this.downloadUrl(newBuildInfo, updateChannel));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026uildInfo, updateChannel))");
            message = string;
        }
        Iterable iterable = newBuildInfo.getButtons();
        StringBuilder stringBuilder = new StringBuilder().append(message).append("<br><br>");
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ButtonInfo)element$iv$iv;
            boolean bl = false;
            if (!(!it.isDownload())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = list2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ButtonInfo)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"More Information") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$filter$iv = list2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ButtonInfo)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"Release Notes") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"<br><br>", null, null, (int)0, null, (Function1)updateHighlightsContent.4.INSTANCE, (int)30, null)).toString();
    }

    private final String calculatePatchSize(UpdateChain patchesChain, File testPatch) {
        Object object;
        block5: {
            String patchesSize;
            block4: {
                String string = patchesSize = this.getPatchesText(patchesChain, testPatch);
                if (string == null) {
                    return "";
                }
                object = FROM_TO_PATCHES_REGEXP.matchEntire((CharSequence)string);
                if (object == null) break block4;
                MatchResult matchResult = object;
                boolean bl = false;
                boolean bl2 = false;
                MatchResult it = matchResult;
                boolean bl3 = false;
                object = " Patch size is about " + (String)it.getGroupValues().get(1) + " MB.";
                if (object != null) break block5;
            }
            object = " Patch size is " + patchesSize + " MB.";
        }
        return object;
    }

    private final String downloadUrl(BuildInfo newBuildInfo, UpdateChannel updateChannel) {
        String string;
        String string2;
        IdeUrlTrackingParametersProvider ideUrlTrackingParametersProvider = IdeUrlTrackingParametersProvider.getInstance();
        String string3 = newBuildInfo.getDownloadUrl();
        if (string3 == null) {
            string3 = string2 = newBuildInfo.getBlogPost();
        }
        if (string3 == null) {
            string2 = string = updateChannel.getUrl();
        }
        if (string2 == null) {
            string = "https://www.jetbrains.com";
        }
        String string4 = ideUrlTrackingParametersProvider.augmentUrl(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"IdeUrlTrackingParameters\u2026tps://www.jetbrains.com\")");
        return string4;
    }

    private UpdateInfoPanelUI() {
    }

    static {
        UpdateInfoPanelUI updateInfoPanelUI;
        INSTANCE = updateInfoPanelUI = new UpdateInfoPanelUI();
        String string = "from \\d+ to (\\d+)";
        boolean bl = false;
        FROM_TO_PATCHES_REGEXP = new Regex(string);
        DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
    }
}

