/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class PluginsAdvertiserStartupActivity
implements StartupActivity.Background {
    private final Object myListRefreshLock = new Object();
    private boolean myListRefreshed = false;

    PluginsAdvertiserStartupActivity() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runActivity(@NotNull Project project2) {
        Application app;
        if (project2 == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() || app.isHeadlessEnvironment() || !UpdateSettings.getInstance().isCheckNeeded()) {
            return;
        }
        Object object = this.myListRefreshLock;
        synchronized (object) {
            if (!this.myListRefreshed) {
                this.myListRefreshed = true;
                PluginsAdvertiser.ensureDeleted();
            }
        }
        try {
            PluginsAdvertiserStartupActivity.run(project2);
        }
        catch (UnknownHostException e) {
            PluginsAdvertiser.LOG.warn("Host name could not be resolved: " + e.getMessage());
        }
        catch (Exception e) {
            PluginsAdvertiser.LOG.info(e);
        }
    }

    private static void run(@NotNull Project project2) throws IOException {
        if (project2 == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(1);
        }
        Set<UnknownFeature> unknownFeatures = UnknownFeaturesCollector.getInstance(project2).getUnknownFeatures();
        PluginsAdvertiser.KnownExtensions extensions2 = PluginsAdvertiser.loadExtensions();
        if (extensions2 != null && unknownFeatures.isEmpty()) {
            return;
        }
        MultiMap<PluginId, UnknownFeature> features = new MultiMap<PluginId, UnknownFeature>();
        THashMap<PluginsAdvertiser.Plugin, IdeaPluginDescriptor> disabledPlugins = new THashMap<PluginsAdvertiser.Plugin, IdeaPluginDescriptor>();
        List<IdeaPluginDescriptor> allPlugins = RepositoryHelper.loadPluginsFromAllRepositories(null);
        if (project2.isDisposed()) {
            return;
        }
        if (extensions2 == null) {
            PluginsAdvertiser.loadSupportedExtensions(allPlugins);
            if (project2.isDisposed()) {
                return;
            }
            EditorNotifications.getInstance(project2).updateAllNotifications();
        }
        HashMap<PluginId, PluginsAdvertiser.Plugin> ids = new HashMap<PluginId, PluginsAdvertiser.Plugin>();
        for (UnknownFeature feature : unknownFeatures) {
            ProgressManager.checkCanceled();
            List<PluginsAdvertiser.Plugin> pluginId = PluginsAdvertiser.retrieve(feature);
            if (pluginId == null) continue;
            for (PluginsAdvertiser.Plugin plugin : pluginId) {
                PluginId id2 = PluginId.getId(plugin.myPluginId);
                ids.put(id2, plugin);
                features.putValue(id2, feature);
            }
        }
        for (PluginId id3 : ids.keySet()) {
            IdeaPluginDescriptor pluginDescriptor;
            PluginsAdvertiser.Plugin plugin = (PluginsAdvertiser.Plugin)ids.get(id3);
            if (!PluginManagerCore.isDisabled(id3) || (pluginDescriptor = PluginManagerCore.getPlugin(id3)) == null) continue;
            disabledPlugins.put(plugin, pluginDescriptor);
        }
        List<String> bundledPlugin = PluginsAdvertiser.hasBundledPluginToInstall(ids.values());
        THashSet<PluginDownloader> plugins2 = new THashSet<PluginDownloader>();
        for (IdeaPluginDescriptor loadedPlugin : allPlugins) {
            PluginId pluginId = loadedPlugin.getPluginId();
            if (!ids.containsKey(pluginId) || PluginManagerCore.isDisabled(pluginId) || PluginManagerCore.isBrokenPlugin(loadedPlugin)) continue;
            plugins2.add(PluginDownloader.createDownloader(loadedPlugin));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project2.isDisposed()) {
                return;
            }
            ArrayList<NotificationAction> notificationActions = new ArrayList<NotificationAction>();
            String message = null;
            if (!plugins2.isEmpty() || !disabledPlugins.isEmpty()) {
                message = PluginsAdvertiserStartupActivity.getAddressedMessagePresentation(plugins2, disabledPlugins, features);
                if (!disabledPlugins.isEmpty()) {
                    notificationActions.add(NotificationAction.createSimpleExpiring(IdeBundle.message("plugins.advertiser.action.enable.plugins", new Object[0]), () -> {
                        FeatureUsageData data2 = new FeatureUsageData().addData("source", "notification").addData("plugins", ContainerUtil.map(disabledPlugins.values(), plugin -> plugin.getPluginId().getIdString()));
                        FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "enable.plugins", data2);
                        PluginsAdvertiser.enablePlugins(project2, disabledPlugins.values());
                    }));
                } else {
                    notificationActions.add(NotificationAction.createSimpleExpiring(IdeBundle.message("plugins.advertiser.action.configure.plugins", new Object[0]), () -> {
                        FeatureUsageData data2 = new FeatureUsageData().addData("source", "notification");
                        FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "configure.plugins", data2);
                        new PluginsAdvertiserDialog(project2, plugins2.toArray(new PluginDownloader[0]), allPlugins).show();
                    }));
                }
                notificationActions.add(NotificationAction.createSimpleExpiring(IdeBundle.message("plugins.advertiser.action.ignore.unknown.features", new Object[0]), () -> {
                    FeatureUsageData data2 = new FeatureUsageData().addData("source", "notification");
                    FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "ignore.unknown.features", data2);
                    UnknownFeaturesCollector featuresCollector = UnknownFeaturesCollector.getInstance(project2);
                    for (UnknownFeature feature : unknownFeatures) {
                        featuresCollector.ignoreFeature(feature);
                    }
                }));
            } else if (bundledPlugin != null && !PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
                message = IdeBundle.message("plugins.advertiser.ultimate.features.detected", StringUtil.join(bundledPlugin, ", "));
                notificationActions.add(NotificationAction.createSimpleExpiring(IdeBundle.message("plugins.advertiser.action.try.ultimate", new Object[0]), () -> {
                    FeatureUsageData data2 = new FeatureUsageData().addData("source", "notification");
                    FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "open.download.page", data2);
                    PluginsAdvertiser.openDownloadPage();
                }));
                notificationActions.add(NotificationAction.createSimpleExpiring(IdeBundle.message("plugins.advertiser.action.ignore.ultimate", new Object[0]), () -> {
                    FeatureUsageData data2 = new FeatureUsageData().addData("source", "notification");
                    FUCounterUsageLogger.getInstance().logEvent("plugins.advertiser", "ignore.ultimate", data2);
                    PropertiesComponent.getInstance().setValue("ignoreUltimateEdition", "true");
                }));
            }
            if (message != null) {
                Notification notification = PluginsAdvertiser.NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, null);
                for (NotificationAction action2 : notificationActions) {
                    notification.addAction(action2);
                }
                notification.notify(project2);
            }
        }, ModalityState.NON_MODAL);
    }

    @NotNull
    private static String getAddressedMessagePresentation(@NotNull Set<PluginDownloader> plugins2, @NotNull Map<PluginsAdvertiser.Plugin, IdeaPluginDescriptor> disabledPlugins, @NotNull MultiMap<PluginId, UnknownFeature> features) {
        if (plugins2 == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(2);
        }
        if (disabledPlugins == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(3);
        }
        if (features == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(4);
        }
        MultiMap<String, String> addressedFeatures = MultiMap.createSet();
        LinkedHashSet<PluginId> ids = new LinkedHashSet<PluginId>();
        for (PluginDownloader pluginDownloader : plugins2) {
            ids.add(pluginDownloader.getId());
        }
        for (PluginsAdvertiser.Plugin plugin : disabledPlugins.keySet()) {
            ids.add(PluginId.getId(plugin.myPluginId));
        }
        for (PluginId pluginId : ids) {
            for (UnknownFeature feature : features.get(pluginId)) {
                addressedFeatures.putValue(feature.getFeatureDisplayName(), feature.getImplementationDisplayName());
            }
        }
        String addressedFeaturesPresentation = StringUtil.join(addressedFeatures.entrySet(), entry -> (String)entry.getKey() + "[" + StringUtil.join((Collection)entry.getValue(), ", ") + "]", ", ");
        int n = addressedFeatures.keySet().size();
        int pluginsNumber = ids.size();
        String string = StringUtil.pluralize("Plugin", pluginsNumber) + " supporting " + StringUtil.pluralize("feature", n) + " (" + addressedFeaturesPresentation + ") " + (pluginsNumber == 1 ? "is" : "are") + " currently " + (plugins2.isEmpty() ? "disabled" : "not installed") + ".<br>";
        if (string == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserStartupActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserStartupActivity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddressedMessagePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAddressedMessagePresentation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

