/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildNumber
implements Comparable<BuildNumber> {
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    private final String myProductCode;
    private final int @NotNull [] myComponents;

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber) {
        if (productCode == null) {
            BuildNumber.$$$reportNull$$$0(0);
        }
        this(productCode, new int[]{baselineVersion, buildNumber});
    }

    public BuildNumber(@NotNull String productCode, int ... components) {
        if (productCode == null) {
            BuildNumber.$$$reportNull$$$0(1);
        }
        if (components == null) {
            BuildNumber.$$$reportNull$$$0(2);
        }
        this.myProductCode = productCode;
        this.myComponents = components;
    }

    private static boolean isPlaceholder(@NotNull String value2) {
        if (value2 == null) {
            BuildNumber.$$$reportNull$$$0(3);
        }
        return "__BUILD_NUMBER__".equals(value2) || "__BUILD__".equals(value2);
    }

    @NotNull
    public String getProductCode() {
        String string = this.myProductCode;
        if (string == null) {
            BuildNumber.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getBaselineVersion() {
        return this.myComponents[0];
    }

    public int @NotNull [] getComponents() {
        int[] nArray = (int[])this.myComponents.clone();
        if (nArray == null) {
            BuildNumber.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    public boolean isSnapshot() {
        for (int value2 : this.myComponents) {
            if (value2 != Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public BuildNumber withoutProductCode() {
        return this.myProductCode.isEmpty() ? this : new BuildNumber("", this.myComponents);
    }

    @NotNull
    public String asString() {
        return this.asString(true, true);
    }

    @NotNull
    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    @NotNull
    public String asStringWithoutProductCodeAndSnapshot() {
        return this.asString(false, false);
    }

    @NotNull
    private String asString(boolean includeProductCode, boolean withSnapshotMarker) {
        StringBuilder builder2 = new StringBuilder();
        if (includeProductCode && !this.myProductCode.isEmpty()) {
            builder2.append(this.myProductCode).append('-');
        }
        for (int each : this.myComponents) {
            if (each != Integer.MAX_VALUE) {
                builder2.append(each);
            } else if (withSnapshotMarker) {
                builder2.append(SNAPSHOT);
            }
            builder2.append('.');
        }
        if (builder2.charAt(builder2.length() - 1) == '.') {
            builder2.setLength(builder2.length() - 1);
        }
        String string = builder2.toString();
        if (string == null) {
            BuildNumber.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static BuildNumber fromStringOrNull(@NotNull String version2) {
        if (version2 == null) {
            BuildNumber.$$$reportNull$$$0(7);
        }
        try {
            return BuildNumber.fromString(version2);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    @Nullable
    public static BuildNumber fromString(@Nullable String version2) {
        if (version2 == null) {
            return null;
        }
        return (version2 = version2.trim()).isEmpty() ? null : BuildNumber.fromString(version2, null, null);
    }

    @Nullable
    public static BuildNumber fromStringWithProductCode(@NotNull String version2, @NotNull String productCode) {
        if (version2 == null) {
            BuildNumber.$$$reportNull$$$0(8);
        }
        if (productCode == null) {
            BuildNumber.$$$reportNull$$$0(9);
        }
        return BuildNumber.fromString(version2, null, productCode);
    }

    @Nullable
    public static BuildNumber fromString(@NotNull String version2, @Nullable String pluginName, @Nullable String productCodeIfAbsentInVersion) {
        String productCode;
        String code;
        int productSeparator;
        if (version2 == null) {
            BuildNumber.$$$reportNull$$$0(10);
        }
        if ((productSeparator = (code = version2).indexOf(45)) > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            String string = productCode = productCodeIfAbsentInVersion != null ? productCodeIfAbsentInVersion : "";
        }
        if (SNAPSHOT.equals(code) || BuildNumber.isPlaceholder(code)) {
            return new BuildNumber(productCode, BuildNumber.currentVersion().myComponents);
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            String baselineVersionString = code.substring(0, baselineVersionSeparator);
            if (baselineVersionString.trim().isEmpty()) {
                return null;
            }
            List<String> stringComponents = StringUtil.split(code, ".");
            TIntArrayList intComponentsList = new TIntArrayList();
            for (String stringComponent : stringComponents) {
                int comp = BuildNumber.parseBuildNumber(version2, stringComponent, pluginName);
                intComponentsList.add(comp);
                if (comp != Integer.MAX_VALUE) continue;
                break;
            }
            int[] intComponents = intComponentsList.toNativeArray();
            return new BuildNumber(productCode, intComponents);
        }
        int buildNumber = BuildNumber.parseBuildNumber(version2, code, pluginName);
        if (buildNumber <= 2000) {
            return new BuildNumber(productCode, buildNumber, 0);
        }
        int baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version2, @NotNull String code, String pluginName) {
        if (code == null) {
            BuildNumber.$$$reportNull$$$0(11);
        }
        if (SNAPSHOT.equals(code) || BuildNumber.isPlaceholder(code) || STAR.equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid version number: " + version2 + "; plugin name: " + pluginName);
        }
    }

    @Override
    public int compareTo(@NotNull BuildNumber o) {
        if (o == null) {
            BuildNumber.$$$reportNull$$$0(12);
        }
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = c1[i] - c2[i];
            if (result2 == 0) continue;
            return result2;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (!this.myProductCode.equals(that.myProductCode)) {
            return false;
        }
        return Arrays.equals(this.myComponents, that.myComponents);
    }

    public int hashCode() {
        int result2 = this.myProductCode.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myComponents);
        return result2;
    }

    public String toString() {
        return this.asString();
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    @ApiStatus.Internal
    @NotNull
    public static BuildNumber currentVersion() {
        BuildNumber buildNumber = Holder.CURRENT_VERSION;
        if (buildNumber == null) {
            BuildNumber.$$$reportNull$$$0(13);
        }
        return buildNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productCode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/BuildNumber";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/BuildNumber";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductCode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "currentVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceholder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromStringOrNull";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromStringWithProductCode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildNumber";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Holder {
        private static final BuildNumber CURRENT_VERSION = Holder.fromFile();

        private Holder() {
        }

        @NotNull
        private static BuildNumber fromFile() {
            String homePath = PathManager.getHomePath();
            Path home = Paths.get(homePath, new String[0]);
            BuildNumber result2 = Holder.readFile(home.resolve("build.txt"));
            if (result2 != null) {
                BuildNumber buildNumber = result2;
                if (buildNumber == null) {
                    Holder.$$$reportNull$$$0(0);
                }
                return buildNumber;
            }
            if (SystemInfoRt.isMac && (result2 = Holder.readFile(home.resolve("Resources/build.txt"))) != null) {
                BuildNumber buildNumber = result2;
                if (buildNumber == null) {
                    Holder.$$$reportNull$$$0(1);
                }
                return buildNumber;
            }
            String communityHomePath = PathManager.getCommunityHomePath();
            if (communityHomePath != homePath && (result2 = Holder.readFile(Paths.get(communityHomePath, "build.txt"))) != null) {
                BuildNumber buildNumber = result2;
                if (buildNumber == null) {
                    Holder.$$$reportNull$$$0(2);
                }
                return buildNumber;
            }
            BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(BuildNumber.FALLBACK_VERSION));
            if (buildNumber == null) {
                Holder.$$$reportNull$$$0(3);
            }
            return buildNumber;
        }

        @Nullable
        private static BuildNumber readFile(@NotNull Path path2) {
            if (path2 == null) {
                Holder.$$$reportNull$$$0(4);
            }
            try {
                String text2 = Files.newBufferedReader(path2).readLine();
                if (text2 != null) {
                    return BuildNumber.fromString(text2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/BuildNumber$Holder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/BuildNumber$Holder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

