/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static <E extends Throwable> void runWithClassLoader(@Nullable ClassLoader classLoader, @NotNull ThrowableRunnable<E> runnable2) throws E {
        if (runnable2 == null) {
            ClassLoaderUtil.$$$reportNull$$$0(0);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            runnable2.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithClassLoader(@Nullable ClassLoader classLoader, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            ClassLoaderUtil.$$$reportNull$$$0(1);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = computable.compute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Deprecated
    public static <T> T runWithClassLoader(ClassLoader classLoader, Computable<T> computable) {
        return (T)ClassLoaderUtil.computeWithClassLoader(classLoader, () -> computable.compute());
    }

    @Nullable
    public static ClassLoader getPlatformLoaderParentIfOnJdk9() {
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            try {
                return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void addPlatformLoaderParentIfOnJdk9(@NotNull UrlClassLoader.Builder builder2) {
        if (builder2 == null) {
            ClassLoaderUtil.$$$reportNull$$$0(2);
        }
        builder2.parent(ClassLoaderUtil.getPlatformLoaderParentIfOnJdk9());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/ClassLoaderUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addPlatformLoaderParentIfOnJdk9";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

