/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    private static final ConcurrentMap<Class, Map<String, Field>> ourFieldCache = ConcurrentFactoryMap.createMap(c -> {
        LinkedHashMap<String, Field> result2 = new LinkedHashMap<String, Field>();
        for (Field field : c.getFields()) {
            int modifiers;
            String name = field.getName();
            if (name.indexOf(36) >= 0 || result2.containsKey(name) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null) continue;
            field.setAccessible(true);
            if (field.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
            result2.put(name, field);
        }
        return result2;
    });

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode) throws WriteExternalException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.writeExternal(data2, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") JDOMFilter filter2) throws WriteExternalException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(3);
        }
        for (Field field : ((Map)ourFieldCache.get(data2.getClass())).values()) {
            Element element2;
            String value2;
            block25: {
                if (filter2 != null && !filter2.isAccept(field)) continue;
                Class<?> type = field.getType();
                value2 = null;
                try {
                    if (type.isPrimitive()) {
                        if (type.equals(Byte.TYPE)) {
                            value2 = Byte.toString(field.getByte(data2));
                        } else if (type.equals(Short.TYPE)) {
                            value2 = Short.toString(field.getShort(data2));
                        } else if (type.equals(Integer.TYPE)) {
                            value2 = Integer.toString(field.getInt(data2));
                        } else if (type.equals(Long.TYPE)) {
                            value2 = Long.toString(field.getLong(data2));
                        } else if (type.equals(Float.TYPE)) {
                            value2 = Float.toString(field.getFloat(data2));
                        } else if (type.equals(Double.TYPE)) {
                            value2 = Double.toString(field.getDouble(data2));
                        } else if (type.equals(Character.TYPE)) {
                            value2 = String.valueOf(field.getChar(data2));
                        } else {
                            if (!type.equals(Boolean.TYPE)) continue;
                            value2 = Boolean.toString(field.getBoolean(data2));
                        }
                        break block25;
                    }
                    if (type.equals(String.class)) {
                        value2 = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data2));
                        break block25;
                    }
                    if (type.isEnum()) {
                        value2 = field.get(data2).toString();
                        break block25;
                    }
                    if (type.equals(Color.class)) {
                        Color color = (Color)field.get(data2);
                        if (color != null) {
                            value2 = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                        element2 = new Element("option");
                        parentNode.addContent(element2);
                        element2.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data2);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element2.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element2 = new Element("option");
            parentNode.addContent(element2);
            element2.setAttribute("name", field.getName());
            if (value2 == null) continue;
            element2.setAttribute("value", value2);
        }
    }

    @Nullable
    static String filterXMLCharacters(@Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        StringBuilder builder2 = null;
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (Verifier.isXMLCharacter(c)) {
                if (builder2 == null) continue;
                builder2.append(c);
                continue;
            }
            if (builder2 != null) continue;
            builder2 = new StringBuilder(value2.length() + 5);
            builder2.append(value2, 0, i);
        }
        if (builder2 != null) {
            value2 = builder2.toString();
        }
        return value2;
    }

    public static void readExternal(@NotNull Object data2, Element parentNode) throws InvalidDataException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            return;
        }
        Map fields = (Map)ourFieldCache.get(data2.getClass());
        block12: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Object value2;
                Field field = (Field)fields.get(fieldName);
                if (field == null) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    value2 = field.get(data2);
                    if (!(value2 instanceof JDOMExternalizable)) continue;
                    List<Element> children2 = e.getChildren("value");
                    Iterator<Element> iterator2 = children2.iterator();
                    while (iterator2.hasNext()) {
                        Element child2;
                        Element valueTag = child2 = iterator2.next();
                        ((JDOMExternalizable)value2).readExternal(valueTag);
                    }
                    continue;
                }
                value2 = e.getAttributeValue("value");
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    if (value2 == null) continue;
                    if (type.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data2, Byte.parseByte((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            field.setShort(data2, Short.parseShort((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value2);
                        field.setInt(data2, i);
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            field.setLong(data2, Long.parseLong((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data2, Float.parseFloat((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data2, Double.parseDouble((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Character.TYPE)) {
                        if (((String)value2).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data2, ((String)value2).charAt(0));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        if (((String)value2).equals("true")) {
                            field.setBoolean(data2, true);
                            continue;
                        }
                        if (((String)value2).equals("false")) {
                            field.setBoolean(data2, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type.isEnum()) {
                    for (Object enumValue : type.getEnumConstants()) {
                        if (!enumValue.toString().equals(value2)) continue;
                        field.set(data2, enumValue);
                        continue block12;
                    }
                    continue;
                }
                if (type.equals(String.class)) {
                    field.set(data2, value2);
                    continue;
                }
                if (type.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value2);
                    field.set(data2, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                    List<Element> children3 = e.getChildren("value");
                    if (children3.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element2 : children3) {
                        object = (JDOMExternalizable)type.newInstance();
                        object.readExternal(element2);
                    }
                    field.set(data2, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                throw new InvalidDataException(ex);
            }
        }
    }

    public static int toInt(@NotNull String value2) throws InvalidDataException {
        int i;
        if (value2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(5);
        }
        try {
            i = Integer.parseInt(value2);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value2, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value2) throws InvalidDataException {
        Color color;
        if (value2 == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value2, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value2, ex);
                throw new InvalidDataException("Wrong color value: " + value2, ex);
            }
        }
        return color;
    }

    @ApiStatus.Internal
    public static void clearFieldCache() {
        ourFieldCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/DefaultJDOMExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "toInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

