/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExecutionCallback {
    private int myCurrentCount;
    private final int myCountToExecution;
    private List<Runnable> myRunnables;

    ExecutionCallback() {
        this(1);
    }

    ExecutionCallback(int executedCount) {
        this.myCountToExecution = executedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setExecuted() {
        List<Runnable> all;
        if (!this.signalExecution()) {
            return false;
        }
        ExecutionCallback executionCallback = this;
        synchronized (executionCallback) {
            if (this.myRunnables == null) {
                return true;
            }
            all = this.myRunnables;
            this.myRunnables = null;
        }
        for (Runnable each : all) {
            each.run();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWhenExecuted(@NotNull Runnable runnable2) {
        Runnable toRun;
        if (runnable2 == null) {
            ExecutionCallback.$$$reportNull$$$0(0);
        }
        ExecutionCallback executionCallback = this;
        synchronized (executionCallback) {
            if (this.isExecuted()) {
                if (this.myRunnables == null) {
                    toRun = runnable2;
                } else {
                    CompositeRunnable composite = new CompositeRunnable(this.myRunnables);
                    composite.add(runnable2);
                    toRun = composite;
                    this.myRunnables = null;
                }
            } else {
                if (this.myRunnables == null) {
                    this.myRunnables = new SmartList<Runnable>();
                }
                this.myRunnables.add(runnable2);
                return;
            }
        }
        toRun.run();
    }

    synchronized void clear() {
        this.myRunnables = null;
    }

    private synchronized boolean signalExecution() {
        return ++this.myCurrentCount >= this.myCountToExecution;
    }

    synchronized boolean isExecuted() {
        return this.myCurrentCount >= this.myCountToExecution;
    }

    @NonNls
    public synchronized String toString() {
        return "current=" + this.myCurrentCount + " countToExecution=" + this.myCountToExecution;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ExecutionCallback", "doWhenExecuted"));
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable(@NotNull Collection<? extends Runnable> c) {
            if (c == null) {
                CompositeRunnable.$$$reportNull$$$0(0);
            }
            super(c);
        }

        @Override
        public void run() {
            for (Runnable runnable2 : this) {
                runnable2.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/util/ExecutionCallback$CompositeRunnable", "<init>"));
        }
    }
}

