/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.Attribute;
import org.jdom.CloneBase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMUtil {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final Predicate<Attribute> NOT_EMPTY_VALUE_CONDITION = attribute -> !StringUtil.isEmpty(attribute.getValue());
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static final String XML_INPUT_FACTORY_KEY = "javax.xml.stream.XMLInputFactory";
    private static final String XML_INPUT_FACTORY_IMPL = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    private static volatile XMLInputFactory XML_INPUT_FACTORY;
    private static final EmptyTextFilter CONTENT_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory = XML_INPUT_FACTORY;
        if (factory != null) {
            return factory;
        }
        Class<JDOMUtil> clazz = JDOMUtil.class;
        synchronized (JDOMUtil.class) {
            factory = XML_INPUT_FACTORY;
            if (factory != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return factory;
            }
            String property = System.setProperty(XML_INPUT_FACTORY_KEY, XML_INPUT_FACTORY_IMPL);
            try {
                factory = XMLInputFactory.newFactory();
            }
            finally {
                if (property != null) {
                    System.setProperty(XML_INPUT_FACTORY_KEY, property);
                } else {
                    System.clearProperty(XML_INPUT_FACTORY_KEY);
                }
            }
            if (!SystemInfo.isIbmJvm) {
                try {
                    factory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", true);
                }
                catch (Exception e) {
                    JDOMUtil.getLogger().error("cannot set \"report-cdata-event\" property for XMLInputFactory", e);
                }
            }
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            XML_INPUT_FACTORY = factory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return factory;
        }
    }

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        List<Object> list2 = parent == null ? Collections.emptyList() : parent.getChildren();
        if (list2 == null) {
            JDOMUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(1);
        }
        if (parent != null) {
            List<Element> list2 = parent.getChildren(name);
            if (list2 == null) {
                JDOMUtil.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<Element> list3 = Collections.emptyList();
        if (list3 == null) {
            JDOMUtil.$$$reportNull$$$0(3);
        }
        return list3;
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.areElementContentsEqual(e1, e2, ignoreEmptyAttrValues);
    }

    public static int hashCode(@Nullable Element e, boolean ignoreEmptyAttrValues) {
        if (e == null) {
            return 0;
        }
        int hashCode = e.getName().hashCode();
        for (Attribute attribute : JDOMUtil.getAttributes(e)) {
            if (ignoreEmptyAttrValues && !NOT_EMPTY_VALUE_CONDITION.test(attribute)) continue;
            hashCode = hashCode * 31 * 31 + attribute.getName().hashCode() * 31 + attribute.getValue().hashCode();
        }
        for (Content content2 : e.getContent(CONTENT_FILTER)) {
            int contentHash = content2 instanceof Element ? JDOMUtil.hashCode((Element)content2, ignoreEmptyAttrValues) : e.getValue().hashCode();
            hashCode = hashCode * 31 + contentHash;
        }
        return hashCode;
    }

    public static boolean areElementContentsEqual(@NotNull Element e1, @NotNull Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null) {
            JDOMUtil.$$$reportNull$$$0(4);
        }
        if (e2 == null) {
            JDOMUtil.$$$reportNull$$$0(5);
        }
        return JDOMUtil.contentListsEqual(e1.getContent(CONTENT_FILTER), e2.getContent(CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    @Deprecated
    public static Element @NotNull [] getElements(@NotNull Element m) {
        if (m == null) {
            JDOMUtil.$$$reportNull$$$0(6);
        }
        List<Element> list2 = m.getChildren();
        Element[] elementArray = list2.toArray(new Element[0]);
        if (elementArray == null) {
            JDOMUtil.$$$reportNull$$$0(7);
        }
        return elementArray;
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(8);
        }
        String string = JDOMUtil.legalizeChars(str).toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result2, str.charAt(i));
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            JDOMUtil.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    private static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (sb == null) {
            JDOMUtil.$$$reportNull$$$0(12);
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter(each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List<Content> c1, List<Content> c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator<Content> l1 = c1.listIterator();
        ListIterator<Content> l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(13);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(14);
        }
        if (ignoreEmptyAttrValues) {
            l1 = l1.isEmpty() ? Collections.emptyList() : l1.stream().filter(NOT_EMPTY_VALUE_CONDITION).collect(Collectors.toList());
            List<Object> list2 = l2 = l2.isEmpty() ? Collections.emptyList() : l2.stream().filter(NOT_EMPTY_VALUE_CONDITION).collect(Collectors.toList());
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            JDOMUtil.$$$reportNull$$$0(15);
        }
        if (a2 == null) {
            JDOMUtil.$$$reportNull$$$0(16);
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull Reader reader) throws JDOMException, IOException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);
        Document document = SafeStAXStreamBuilder.buildDocument(xmlStreamReader, true);
        xmlStreamReader.close();
        Document document2 = document;
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(18);
        }
        return document2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(19);
        }
        XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);
        Element element2 = SafeStAXStreamBuilder.build(xmlStreamReader, true, factory == null ? SafeStAXStreamBuilder.FACTORY : factory);
        xmlStreamReader.close();
        Element element3 = element2;
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(20);
        }
        return element3;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(21);
        }
        return JDOMUtil.loadDocument(new CharSequenceReader(seq));
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(22);
        }
        Element element2 = JDOMUtil.load(new CharSequenceReader(seq));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(23);
        }
        return element2;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(24);
        }
        return JDOMUtil.loadDocumentUsingStaX(reader);
    }

    @NotNull
    public static Document loadDocument(@NotNull File file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(25);
        }
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(file2))), StandardCharsets.UTF_8));
    }

    @NotNull
    public static Element load(@NotNull File file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(26);
        }
        return JDOMUtil.load(file2, null);
    }

    @NotNull
    public static Element load(@NotNull Path file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(27);
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(file2, new OpenOption[0]))), StandardCharsets.UTF_8), null);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull File file2, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(28);
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(file2))), StandardCharsets.UTF_8), factory);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull Path file2, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(file2, new OpenOption[0]))), StandardCharsets.UTF_8), factory);
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(30);
        }
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadUsingStaX(reader, null);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.load(stream, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8), factory);
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        if (resource == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Element element2 = JDOMUtil.load(stream);
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(34);
        }
        return element2;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        return JDOMUtil.loadDocument(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        Element element2 = JDOMUtil.load(URLUtil.openStream(url));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        return element2;
    }

    @Deprecated
    @NotNull
    public static Document loadResourceDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(38);
        }
        return JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(39);
        }
        Element element2 = JDOMUtil.load(URLUtil.openResourceStream(url));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(40);
        }
        return element2;
    }

    public static void writeDocument(@NotNull Document document, @NotNull String filePath2, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(41);
        }
        if (filePath2 == null) {
            JDOMUtil.$$$reportNull$$$0(42);
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath2));){
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file2, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(43);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(44);
        }
        JDOMUtil.write((Parent)document, file2, lineSeparator);
    }

    public static void write(@NotNull Element element2, @NotNull File file2) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(45);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(46);
        }
        JDOMUtil.write(element2, file2, "\n");
    }

    public static void write(@NotNull Element element2, @NotNull File file2, @Nullable String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(47);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(48);
        }
        FileUtil.createParentDirs(file2);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8));){
            JDOMUtil.writeElement(element2, (Writer)writer, JDOMUtil.createOutputter(lineSeparator));
        }
    }

    public static void write(@NotNull Element element2, @NotNull Path file2) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(49);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(50);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);){
            JDOMUtil.writeElement(element2, (Writer)writer, JDOMUtil.createOutputter("\n"));
        }
    }

    public static void write(@NotNull Parent element2, @NotNull File file2) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(51);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(52);
        }
        JDOMUtil.write(element2, file2, "\n");
    }

    public static void write(@NotNull Parent element2, @NotNull File file2, @NotNull String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(53);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(54);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(55);
        }
        FileUtil.createParentDirs(file2);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file2));){
            JDOMUtil.write(element2, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(56);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(57);
        }
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    public static void write(@NotNull Parent element2, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(58);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(59);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(60);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            if (element2 instanceof Document) {
                JDOMUtil.writeDocument((Document)element2, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element2, (Writer)writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        String string;
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(61);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static String write(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(63);
        }
        return JDOMUtil.writeElement(element2);
    }

    @NotNull
    public static String write(@NotNull Parent element2, String lineSeparator) {
        String string;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(64);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element2, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    public static void write(Parent element2, Writer writer, String lineSeparator) throws IOException {
        if (element2 instanceof Element) {
            JDOMUtil.writeElement((Element)element2, writer, lineSeparator);
        } else if (element2 instanceof Document) {
            JDOMUtil.writeDocument((Document)element2, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element2, Writer writer, String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(66);
        }
        JDOMUtil.writeElement(element2, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element2, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(67);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(68);
        }
        if (xmlOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(69);
        }
        try {
            xmlOutputter.output(element2, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element2, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(70);
        }
        return JDOMUtil.writeElement(element2, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element2, String lineSeparator) {
        String string;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(71);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element2, (Writer)writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    @NotNull
    public static String writeChildren(@NotNull Element element2, @NotNull String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(73);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(74);
        }
        StringWriter writer = new StringWriter();
        for (Element child2 : element2.getChildren()) {
            JDOMUtil.writeElement(child2, (Writer)writer, lineSeparator);
            writer.append(lineSeparator);
        }
        String string = writer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(76);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(77);
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        if (format == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        return format;
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text2) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(79);
        }
        return JDOMUtil.escapeText(text2, false, false);
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(80);
        }
        return JDOMUtil.escapeText(text2, false, escapeSpaces, escapeLineEnds);
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(81);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text2, buffer, i, quotation, ch);
        }
        String string = buffer == null ? text2 : buffer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static void printDiagnostics(@NotNull Element element2, String prefix) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(83);
        }
        ElementInfo info = JDOMUtil.getElementInfo(element2);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child2 : element2.getChildren()) {
            JDOMUtil.printDiagnostics(child2, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(84);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element2.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element2);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(File @NotNull [] oldFiles, String @NotNull [] newFilePaths, Document @NotNull [] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            JDOMUtil.$$$reportNull$$$0(85);
        }
        if (newFilePaths == null) {
            JDOMUtil.$$$reportNull$$$0(86);
        }
        if (newFileDocuments == null) {
            JDOMUtil.$$$reportNull$$$0(87);
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file2 = new File(newFilePath);
            if (!file2.exists() || file2.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file3 : oldFiles) {
            if (!file3.exists() || file3.canWrite()) continue;
            throw new IOException("File \"" + file3.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result2 = oldFile.delete();
            if (result2) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content2 = (Content)node;
            return content2.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element2) {
        return element2 == null || !element2.hasAttributes() && element2.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element2, int attributeCount) {
        return element2 == null || JDOMUtil.getAttributes(element2).size() == attributeCount && element2.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        if (e == null) {
            JDOMUtil.$$$reportNull$$$0(88);
        }
        List<Attribute> list2 = e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
        if (list2 == null) {
            JDOMUtil.$$$reportNull$$$0(89);
        }
        return list2;
    }

    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator<CloneBase> iterator2 = from.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element configuration = iterator2.next();
            iterator2.remove();
            to.addContent(configuration);
        }
        iterator2 = JDOMUtil.getAttributes(from).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(90);
        }
        if (from == null) {
            JDOMUtil.$$$reportNull$$$0(91);
        }
        Iterator<CloneBase> iterator2 = from.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element child2 = iterator2.next();
            iterator2.remove();
            Element existingChild = to.getChild(child2.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child2.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child2), false)) {
                to.addContent(child2);
                continue;
            }
            JDOMUtil.deepMerge(existingChild, child2);
        }
        iterator2 = JDOMUtil.getAttributes(from).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        Element element2 = to;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(92);
        }
        return element2;
    }

    @NotNull
    public static Element internElement(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(93);
        }
        Element element3 = JDOMInterner.INSTANCE.internElement(element2);
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(94);
        }
        return element3;
    }

    @NotNull
    public static String removeControlChars(@NotNull String text2) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(95);
        }
        StringBuilder result2 = null;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!Verifier.isXMLCharacter(c)) {
                if (result2 != null) continue;
                result2 = new StringBuilder(text2.length());
                result2.append(text2, 0, i);
                continue;
            }
            if (result2 == null) continue;
            result2.append(c);
        }
        String string = result2 == null ? text2 : result2.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(96);
        }
        return string;
    }

    @Nullable
    public static Point getLocation(@Nullable Element element2) {
        return element2 == null ? null : JDOMUtil.getLocation(element2, X, Y);
    }

    @Nullable
    public static Point getLocation(@NotNull Element element2, @NotNull String x, @NotNull String y) {
        String sX;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(97);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(98);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(99);
        }
        if ((sX = element2.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element2.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(sX), Integer.parseInt(sY));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setLocation(@NotNull Element element2, @NotNull Point location2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(100);
        }
        if (location2 == null) {
            JDOMUtil.$$$reportNull$$$0(101);
        }
        return JDOMUtil.setLocation(element2, X, Y, location2);
    }

    @NotNull
    public static Element setLocation(@NotNull Element element2, @NotNull String x, @NotNull String y, @NotNull Point location2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(102);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(103);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(104);
        }
        if (location2 == null) {
            JDOMUtil.$$$reportNull$$$0(105);
        }
        Element element3 = element2.setAttribute(x, Integer.toString(location2.x)).setAttribute(y, Integer.toString(location2.y));
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(106);
        }
        return element3;
    }

    @Nullable
    public static Dimension getSize(@Nullable Element element2) {
        return element2 == null ? null : JDOMUtil.getSize(element2, WIDTH, HEIGHT);
    }

    @Nullable
    public static Dimension getSize(@NotNull Element element2, @NotNull String width, @NotNull String height) {
        String sWidth;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(107);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(108);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(109);
        }
        if ((sWidth = element2.getAttributeValue(width)) == null) {
            return null;
        }
        String sHeight = element2.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Dimension(iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setSize(@NotNull Element element2, @NotNull Dimension size) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(110);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(111);
        }
        return JDOMUtil.setSize(element2, WIDTH, HEIGHT, size);
    }

    @NotNull
    public static Element setSize(@NotNull Element element2, @NotNull String width, @NotNull String height, @NotNull Dimension size) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(112);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(113);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(114);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(115);
        }
        Element element3 = element2.setAttribute(width, Integer.toString(size.width)).setAttribute(height, Integer.toString(size.height));
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(116);
        }
        return element3;
    }

    @Nullable
    public static Rectangle getBounds(@Nullable Element element2) {
        return element2 == null ? null : JDOMUtil.getBounds(element2, X, Y, WIDTH, HEIGHT);
    }

    @Nullable
    public static Rectangle getBounds(@NotNull Element element2, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height) {
        String sX;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(117);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(118);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(119);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(120);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(121);
        }
        if ((sX = element2.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element2.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        String sWidth = element2.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element2.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setBounds(@NotNull Element element2, @NotNull Rectangle bounds2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(122);
        }
        if (bounds2 == null) {
            JDOMUtil.$$$reportNull$$$0(123);
        }
        return JDOMUtil.setBounds(element2, X, Y, WIDTH, HEIGHT, bounds2);
    }

    @NotNull
    public static Element setBounds(@NotNull Element element2, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height, @NotNull Rectangle bounds2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(124);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(125);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(126);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(127);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(128);
        }
        if (bounds2 == null) {
            JDOMUtil.$$$reportNull$$$0(129);
        }
        Element element3 = element2.setAttribute(x, Integer.toString(bounds2.x)).setAttribute(y, Integer.toString(bounds2.y)).setAttribute(width, Integer.toString(bounds2.width)).setAttribute(height, Integer.toString(bounds2.height));
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(130);
        }
        return element3;
    }

    public static void copyMissingContent(@NotNull Element source, @NotNull Element target2) {
        if (source == null) {
            JDOMUtil.$$$reportNull$$$0(131);
        }
        if (target2 == null) {
            JDOMUtil.$$$reportNull$$$0(132);
        }
        Element targetClone = target2.clone();
        for (Attribute attribute : source.getAttributes()) {
            if (JDOMUtil.hasAttribute(targetClone, attribute.getName())) continue;
            target2.setAttribute(attribute.clone());
        }
        for (Content content2 : source.getContent()) {
            if (JDOMUtil.hasContent(targetClone, content2)) continue;
            target2.addContent(content2.clone());
        }
    }

    private static boolean hasAttribute(@NotNull Element element2, @NotNull String name) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(133);
        }
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(134);
        }
        return element2.getAttribute(name) != null;
    }

    private static boolean hasContent(@NotNull Element element2, @NotNull Content content2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(135);
        }
        if (content2 == null) {
            JDOMUtil.$$$reportNull$$$0(136);
        }
        if (content2 instanceof Element) {
            return !element2.getChildren(((Element)content2).getName()).isEmpty();
        }
        return false;
    }

    static {
        CONTENT_FILTER = new EmptyTextFilter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 31: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 41: 
            case 43: 
            case 56: 
            case 61: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 73: 
            case 83: 
            case 84: 
            case 93: 
            case 97: 
            case 100: 
            case 102: 
            case 107: 
            case 110: 
            case 112: 
            case 117: 
            case 122: 
            case 124: 
            case 133: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: 
            case 60: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 68: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 98: 
            case 103: 
            case 118: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = X;
                break;
            }
            case 99: 
            case 104: 
            case 119: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = Y;
                break;
            }
            case 101: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 108: 
            case 113: 
            case 120: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = WIDTH;
                break;
            }
            case 109: 
            case 114: 
            case 121: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = HEIGHT;
                break;
            }
            case 111: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 123: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 23: 
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "removeControlChars";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocation";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "setSize";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "setBounds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areElementContentsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attEqual";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 30: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceDocument";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 61: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "removeControlChars";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "setBounds";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "copyMissingContent";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "hasContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            if (name == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        MyXMLOutputter(@NotNull Format format) {
            if (format == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            super(format);
        }

        @Override
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            String string = JDOMUtil.escapeText(str, false, true);
            if (string == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            String string = JDOMUtil.escapeText(str, false, false);
            if (string == null) {
                MyXMLOutputter.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance(JDOMUtil.class);

        private LoggerHolder() {
        }
    }
}

