/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Segment;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextRange
implements Segment,
Serializable {
    private static final Logger LOG = Logger.getInstance(TextRange.class);
    private static final long serialVersionUID = -670091356599757430L;
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    public static final TextRange[] EMPTY_ARRAY = new TextRange[0];
    private final int myStartOffset;
    private final int myEndOffset;

    public TextRange(int startOffset, int endOffset) {
        this(startOffset, endOffset, true);
    }

    protected TextRange(int startOffset, int endOffset, boolean checkForProperTextRange) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        if (checkForProperTextRange) {
            TextRange.assertProperRange(this);
        }
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range2 = (TextRange)obj;
        return this.myStartOffset == range2.myStartOffset && this.myEndOffset == range2.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(@NotNull TextRange range2) {
        if (range2 == null) {
            TextRange.$$$reportNull$$$0(0);
        }
        return this.contains((Segment)range2);
    }

    public boolean contains(@NotNull Segment range2) {
        if (range2 == null) {
            TextRange.$$$reportNull$$$0(1);
        }
        return this.containsRange(range2.getStartOffset(), range2.getEndOffset());
    }

    public boolean containsRange(int startOffset, int endOffset) {
        return this.getStartOffset() <= startOffset && endOffset <= this.getEndOffset();
    }

    public static boolean containsRange(@NotNull Segment outer, @NotNull Segment inner) {
        if (outer == null) {
            TextRange.$$$reportNull$$$0(2);
        }
        if (inner == null) {
            TextRange.$$$reportNull$$$0(3);
        }
        return outer.getStartOffset() <= inner.getStartOffset() && inner.getEndOffset() <= outer.getEndOffset();
    }

    public boolean containsOffset(int offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    @NotNull
    public String substring(@NotNull String str) {
        String string;
        if (str == null) {
            TextRange.$$$reportNull$$$0(4);
        }
        try {
            string = str.substring(this.myStartOffset, this.myEndOffset);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException("Can't extract " + this + " range from '" + str + "'");
        }
        if (string == null) {
            TextRange.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public CharSequence subSequence(@NotNull CharSequence str) {
        CharSequence charSequence;
        if (str == null) {
            TextRange.$$$reportNull$$$0(6);
        }
        try {
            charSequence = str.subSequence(this.myStartOffset, this.myEndOffset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Can't extract " + this + " range from '" + str + "'");
        }
        if (charSequence == null) {
            TextRange.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            TextRange.$$$reportNull$$$0(8);
        }
        if (subRange.getStartOffset() > this.getLength()) {
            throw new IllegalArgumentException("SubRange: " + subRange + "; this=" + this);
        }
        if (subRange.getEndOffset() > this.getLength()) {
            throw new IllegalArgumentException("SubRange: " + subRange + "; this=" + this);
        }
        TextRange.assertProperRange(subRange);
        return new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
    }

    @NotNull
    public TextRange shiftRight(int delta) {
        if (delta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                TextRange.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        return new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
    }

    @NotNull
    public TextRange shiftLeft(int delta) {
        if (delta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                TextRange.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        return new TextRange(this.myStartOffset - delta, this.myEndOffset - delta);
    }

    @NotNull
    public TextRange grown(int lengthDelta) {
        return TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
    }

    @NotNull
    public static TextRange from(int offset, int length) {
        return TextRange.create(offset, offset + length);
    }

    @NotNull
    public static TextRange create(int startOffset, int endOffset) {
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static TextRange create(@NotNull Segment segment) {
        if (segment == null) {
            TextRange.$$$reportNull$$$0(11);
        }
        return TextRange.create(segment.getStartOffset(), segment.getEndOffset());
    }

    public static boolean areSegmentsEqual(@NotNull Segment segment1, @NotNull Segment segment2) {
        if (segment1 == null) {
            TextRange.$$$reportNull$$$0(12);
        }
        if (segment2 == null) {
            TextRange.$$$reportNull$$$0(13);
        }
        return segment1.getStartOffset() == segment2.getStartOffset() && segment1.getEndOffset() == segment2.getEndOffset();
    }

    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        String string;
        if (original == null) {
            TextRange.$$$reportNull$$$0(14);
        }
        if (replacement == null) {
            TextRange.$$$reportNull$$$0(15);
        }
        try {
            String beginning = original.substring(0, this.getStartOffset());
            String ending = original.substring(this.getEndOffset());
            string = beginning + replacement + ending;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new StringIndexOutOfBoundsException("Can't replace " + this + " range from '" + original + "' with '" + replacement + "'");
        }
        if (string == null) {
            TextRange.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean intersects(@NotNull TextRange textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(17);
        }
        return this.intersects((Segment)textRange);
    }

    public boolean intersects(@NotNull Segment textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(18);
        }
        return this.intersects(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersects(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) <= Math.min(this.myEndOffset, endOffset);
    }

    public boolean intersectsStrict(@NotNull TextRange textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(19);
        }
        return this.intersectsStrict(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersectsStrict(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) < Math.min(this.myEndOffset, endOffset);
    }

    @Nullable
    public TextRange intersection(@NotNull TextRange range2) {
        int newEnd;
        int newStart;
        if (range2 == null) {
            TextRange.$$$reportNull$$$0(20);
        }
        return TextRange.isProperRange(newStart = Math.max(this.myStartOffset, range2.getStartOffset()), newEnd = Math.min(this.myEndOffset, range2.getEndOffset())) ? new TextRange(newStart, newEnd) : null;
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(21);
        }
        return new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
    }

    public boolean equalsToRange(int startOffset, int endOffset) {
        return startOffset == this.myStartOffset && endOffset == this.myEndOffset;
    }

    @NotNull
    public static TextRange allOf(@NotNull String s) {
        if (s == null) {
            TextRange.$$$reportNull$$$0(22);
        }
        return new TextRange(0, s.length());
    }

    public static void assertProperRange(@NotNull Segment range2) throws AssertionError {
        if (range2 == null) {
            TextRange.$$$reportNull$$$0(23);
        }
        TextRange.assertProperRange(range2, "");
    }

    public static void assertProperRange(@NotNull Segment range2, @NotNull Object message) throws AssertionError {
        if (range2 == null) {
            TextRange.$$$reportNull$$$0(24);
        }
        if (message == null) {
            TextRange.$$$reportNull$$$0(25);
        }
        TextRange.assertProperRange(range2.getStartOffset(), range2.getEndOffset(), message);
    }

    public static void assertProperRange(int startOffset, int endOffset, @NotNull Object message) {
        if (message == null) {
            TextRange.$$$reportNull$$$0(26);
        }
        if (!TextRange.isProperRange(startOffset, endOffset)) {
            throw new IllegalArgumentException("Invalid range specified: (" + startOffset + ", " + endOffset + "); " + message);
        }
    }

    private static boolean isProperRange(int startOffset, int endOffset) {
        return startOffset <= endOffset && startOffset >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/TextRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/TextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftRight";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftLeft";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substring";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "subSequence";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cutOut";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areSegmentsEqual";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "intersectsStrict";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "allOf";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "assertProperRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

