/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemUtil {
    static final String FORCE_USE_NIO2_KEY = "idea.io.use.nio2";
    private static final String COARSE_TIMESTAMP_KEY = "idea.io.coarse.ts";
    private static final Logger LOG = Logger.getInstance(FileSystemUtil.class);
    @NotNull
    private static Mediator ourMediator = FileSystemUtil.getMediator();

    private static Mediator getMediator() {
        if (!Boolean.getBoolean(FORCE_USE_NIO2_KEY)) {
            try {
                if (SystemInfo.isWindows && IdeaWin32.isAvailable()) {
                    return FileSystemUtil.check(new IdeaWin32MediatorImpl());
                }
                if ((SystemInfo.isLinux || SystemInfo.isMac || SystemInfo.isSolaris || SystemInfo.isFreeBSD) && JnaLoader.isLoaded()) {
                    return FileSystemUtil.check(new JnaUnixMediatorImpl());
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to load filesystem access layer: " + SystemInfo.OS_NAME + ", " + SystemInfo.JAVA_VERSION, t);
            }
        }
        return new Nio2MediatorImpl();
    }

    private static Mediator check(Mediator mediator) throws Exception {
        String quickTestPath = SystemInfo.isWindows ? "C:\\" : "/";
        mediator.getAttributes(quickTestPath);
        return mediator;
    }

    private FileSystemUtil() {
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull String path2) {
        if (path2 == null) {
            FileSystemUtil.$$$reportNull$$$0(0);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("getAttributes(" + path2 + ")");
                long t = System.nanoTime();
                FileAttributes result2 = ourMediator.getAttributes(path2);
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("  " + t + " mks");
                return result2;
            }
            return ourMediator.getAttributes(path2);
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull File file2) {
        if (file2 == null) {
            FileSystemUtil.$$$reportNull$$$0(1);
        }
        return FileSystemUtil.getAttributes(file2.getPath());
    }

    public static long lastModified(@NotNull File file2) {
        FileAttributes attributes;
        if (file2 == null) {
            FileSystemUtil.$$$reportNull$$$0(2);
        }
        return (attributes = FileSystemUtil.getAttributes(file2)) != null ? attributes.lastModified : 0L;
    }

    public static boolean isSymLink(@NotNull String path2) {
        if (path2 == null) {
            FileSystemUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.areSymLinksSupported) {
            FileAttributes attributes = FileSystemUtil.getAttributes(path2);
            return attributes != null && attributes.isSymLink();
        }
        return false;
    }

    public static boolean isSymLink(@NotNull File file2) {
        if (file2 == null) {
            FileSystemUtil.$$$reportNull$$$0(4);
        }
        return FileSystemUtil.isSymLink(file2.getAbsolutePath());
    }

    @Nullable
    public static String resolveSymLink(@NotNull String path2) {
        if (path2 == null) {
            FileSystemUtil.$$$reportNull$$$0(5);
        }
        try {
            String realPath;
            if (LOG.isTraceEnabled()) {
                LOG.trace("resolveSymLink(" + path2 + ")");
                long t = System.nanoTime();
                realPath = ourMediator.resolveSymLink(path2);
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("  " + t + " mks");
            } else {
                realPath = ourMediator.resolveSymLink(path2);
            }
            if (realPath != null && (SystemInfo.isWindows && realPath.startsWith("\\\\") || new File(realPath).exists())) {
                return realPath;
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return null;
    }

    @Nullable
    public static String resolveSymLink(@NotNull File file2) {
        if (file2 == null) {
            FileSystemUtil.$$$reportNull$$$0(6);
        }
        return FileSystemUtil.resolveSymLink(file2.getAbsolutePath());
    }

    public static boolean clonePermissions(@NotNull String source, @NotNull String target2) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(7);
        }
        if (target2 == null) {
            FileSystemUtil.$$$reportNull$$$0(8);
        }
        try {
            return ourMediator.clonePermissions(source, target2, false);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    public static boolean clonePermissionsToExecute(@NotNull String source, @NotNull String target2) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(9);
        }
        if (target2 == null) {
            FileSystemUtil.$$$reportNull$$$0(10);
        }
        try {
            return ourMediator.clonePermissions(source, target2, true);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    static void resetMediator() {
        ourMediator = FileSystemUtil.getMediator();
    }

    static String getMediatorName() {
        return ourMediator.getClass().getSimpleName().replace("MediatorImpl", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lastModified";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSymLink";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clonePermissions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "clonePermissionsToExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Nio2MediatorImpl
    implements Mediator {
        private final LinkOption[] myNoFollowLinkOptions = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        private final PosixFilePermission[] myExecPermissions = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};

        private Nio2MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String pathStr) {
            if (pathStr == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(0);
            }
            try {
                boolean isSymbolicLink;
                Path path2 = Paths.get(pathStr, new String[0]);
                Class schema = SystemInfo.isWindows ? DosFileAttributes.class : PosixFileAttributes.class;
                DosFileAttributes attributes = Files.readAttributes(path2, schema, this.myNoFollowLinkOptions);
                boolean bl = isSymbolicLink = attributes.isSymbolicLink() || SystemInfo.isWindows && attributes.isOther() && attributes.isDirectory() && path2.getParent() != null;
                if (isSymbolicLink) {
                    try {
                        attributes = Files.readAttributes(path2, schema, new LinkOption[0]);
                    }
                    catch (NoSuchFileException e) {
                        return FileAttributes.BROKEN_SYMLINK;
                    }
                }
                boolean isDirectory = attributes.isDirectory();
                boolean isOther = attributes.isOther();
                long size = attributes.size();
                long lastModified = attributes.lastModifiedTime().toMillis();
                if (SystemInfo.isWindows) {
                    boolean isHidden = path2.getParent() != null && attributes.isHidden();
                    boolean isWritable = isDirectory || !attributes.isReadOnly();
                    return new FileAttributes(isDirectory, isOther, isSymbolicLink, isHidden, size, lastModified, isWritable);
                }
                boolean isWritable = Files.isWritable(path2);
                return new FileAttributes(isDirectory, isOther, isSymbolicLink, false, size, lastModified, isWritable);
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug(pathStr, e);
                return null;
            }
        }

        @Override
        public String resolveSymLink(@NotNull String path2) throws IOException {
            if (path2 == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return Paths.get(path2, new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (NoSuchFileException e) {
                return null;
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target2, boolean execOnly) throws IOException {
            Set<PosixFilePermission> newPermissions;
            if (source == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target2 == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(3);
            }
            if (!SystemInfo.isUnix) {
                return false;
            }
            Path sourcePath = Paths.get(source, new String[0]);
            Path targetPath = Paths.get(target2, new String[0]);
            Set<PosixFilePermission> sourcePermissions = Files.readAttributes(sourcePath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            Set<PosixFilePermission> targetPermissions = Files.readAttributes(targetPath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            if (execOnly) {
                newPermissions = EnumSet.copyOf(targetPermissions);
                for (PosixFilePermission permission : this.myExecPermissions) {
                    if (sourcePermissions.contains((Object)permission)) {
                        newPermissions.add(permission);
                        continue;
                    }
                    newPermissions.remove((Object)permission);
                }
            } else {
                newPermissions = sourcePermissions;
            }
            Files.setAttribute(targetPath, "posix:permissions", newPermissions, new LinkOption[0]);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$Nio2MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JnaUnixMediatorImpl
    implements Mediator {
        private static final int[] LINUX_32 = new int[]{16, 44, 72, 24, 28};
        private static final int[] LINUX_64 = new int[]{24, 48, 88, 28, 32};
        private static final int[] LNX_PPC32 = new int[]{16, 48, 80, 24, 28};
        private static final int[] LNX_PPC64 = LINUX_64;
        private static final int[] LNX_ARM32 = LNX_PPC32;
        private static final int[] BSD_32 = new int[]{8, 48, 32, 12, 16};
        private static final int[] BSD_64 = new int[]{8, 72, 40, 12, 16};
        private static final int[] BSD_32_12 = new int[]{24, 96, 64, 28, 32};
        private static final int[] BSD_64_12 = new int[]{24, 112, 64, 28, 32};
        private static final int[] SUN_OS_32 = new int[]{20, 48, 64, 28, 32};
        private static final int[] SUN_OS_64 = new int[]{16, 40, 64, 24, 28};
        private static final int STAT_VER = 1;
        private static final int OFF_MODE = 0;
        private static final int OFF_SIZE = 1;
        private static final int OFF_TIME = 2;
        private static final int OFF_UID = 3;
        private static final int OFF_GID = 4;
        private final int[] myOffsets;
        private final int myUid;
        private final int myGid;
        private final boolean myCoarseTs = SystemProperties.getBooleanProperty("idea.io.coarse.ts", false);
        private final LimitedPool<Memory> myMemoryPool = new LimitedPool.Sync<Memory>(10, () -> new Memory(256L));

        JnaUnixMediatorImpl() {
            if ("linux-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_32;
            } else if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_64;
            } else if ("linux-arm".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_ARM32;
            } else if ("linux-ppc".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC32;
            } else if ("linux-ppc64le".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC64;
            } else if ("darwin".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = BSD_64;
            } else if ("freebsd-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_32_12 : BSD_32;
            } else if ("freebsd-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_64_12 : BSD_64;
            } else if ("sunos-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_32;
            } else if ("sunos-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_64;
            } else {
                throw new IllegalStateException("Unsupported OS/arch: " + SystemInfo.OS_NAME + "/" + SystemInfo.OS_ARCH);
            }
            Map<String, String> options = Collections.singletonMap("string-encoding", CharsetToolkit.getPlatformCharset().name());
            NativeLibrary lib = NativeLibrary.getInstance((String)"c", options);
            Native.register(LibC.class, (NativeLibrary)lib);
            Native.register(SystemInfo.isLinux ? LinuxLibC.class : UnixLibC.class, (NativeLibrary)lib);
            this.myUid = LibC.getuid();
            this.myGid = LibC.getgid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileAttributes getAttributes(@NotNull String path2) {
            if (path2 == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(0);
            }
            Memory buffer = this.myMemoryPool.alloc();
            try {
                long mTime1;
                boolean isSymlink;
                int res2;
                int n = res2 = SystemInfo.isLinux ? LinuxLibC.__lxstat64(1, path2, (Pointer)buffer) : UnixLibC.lstat(path2, (Pointer)buffer);
                if (res2 != 0) {
                    FileAttributes fileAttributes = null;
                    return fileAttributes;
                }
                int mode = this.getModeFlags(buffer) & 0xFFFF;
                boolean bl = isSymlink = (mode & 0xF000) == 40960;
                if (isSymlink) {
                    if (!JnaUnixMediatorImpl.loadFileStatus(path2, buffer)) {
                        FileAttributes fileAttributes = FileAttributes.BROKEN_SYMLINK;
                        return fileAttributes;
                    }
                    mode = this.getModeFlags(buffer) & 0xFFFF;
                }
                boolean isDirectory = (mode & 0xF000) == 16384;
                boolean isSpecial = !isDirectory && (mode & 0xF000) != 32768;
                long size = buffer.getLong((long)this.myOffsets[1]);
                long l = mTime1 = SystemInfo.is32Bit ? (long)buffer.getInt((long)this.myOffsets[2]) : buffer.getLong((long)this.myOffsets[2]);
                long mTime2 = this.myCoarseTs ? 0L : (SystemInfo.is32Bit ? (long)buffer.getInt((long)(this.myOffsets[2] + 4)) : buffer.getLong((long)(this.myOffsets[2] + 8)));
                long mTime = mTime1 * 1000L + mTime2 / 1000000L;
                boolean writable = this.ownFile(buffer) ? (mode & 0x92) != 0 : LibC.access(path2, 2) == 0;
                FileAttributes fileAttributes = new FileAttributes(isDirectory, isSpecial, isSymlink, false, size, mTime, writable);
                return fileAttributes;
            }
            finally {
                this.myMemoryPool.recycle(buffer);
            }
        }

        @Override
        public String resolveSymLink(@NotNull String path2) throws IOException {
            if (path2 == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return new File(path2).getCanonicalPath();
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message != null && StringUtil.toLowerCase(message).contains("too many levels of symbolic links")) {
                    LOG.debug(e);
                    return null;
                }
                throw new IOException("Cannot resolve '" + path2 + "'", e);
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target2, boolean execOnly) {
            int permissions;
            Memory buffer;
            if (source == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(2);
            }
            if (target2 == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(3);
            }
            if (!JnaUnixMediatorImpl.loadFileStatus(source, buffer = new Memory(256L))) {
                return false;
            }
            int sourcePermissions = this.getModeFlags(buffer) & 0x1FF;
            if (execOnly) {
                if (!JnaUnixMediatorImpl.loadFileStatus(target2, buffer)) {
                    return false;
                }
                int targetPermissions = this.getModeFlags(buffer) & 0x1FF;
                permissions = targetPermissions & 0xFFFFFFB6 | sourcePermissions & 0x49;
            } else {
                permissions = sourcePermissions;
            }
            return LibC.chmod(target2, permissions) == 0;
        }

        private static boolean loadFileStatus(String path2, Memory buffer) {
            return (SystemInfo.isLinux ? LinuxLibC.__xstat64(1, path2, (Pointer)buffer) : UnixLibC.stat(path2, (Pointer)buffer)) == 0;
        }

        private int getModeFlags(Memory buffer) {
            return SystemInfo.isLinux ? buffer.getInt((long)this.myOffsets[0]) : (int)buffer.getShort((long)this.myOffsets[0]);
        }

        private boolean ownFile(Memory buffer) {
            return buffer.getInt((long)this.myOffsets[3]) == this.myUid && buffer.getInt((long)this.myOffsets[4]) == this.myGid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class LinuxLibC {
            private LinuxLibC() {
            }

            static native int __lxstat64(int var0, String var1, Pointer var2);

            static native int __xstat64(int var0, String var1, Pointer var2);
        }

        private static class UnixLibC {
            private UnixLibC() {
            }

            static native int lstat(String var0, Pointer var1);

            static native int stat(String var0, Pointer var1);
        }

        private static class LibC {
            static final int S_MASK = 65535;
            static final int S_IFMT = 61440;
            static final int S_IFLNK = 40960;
            static final int S_IFREG = 32768;
            static final int S_IFDIR = 16384;
            static final int PERM_MASK = 511;
            static final int EXECUTE_MASK = 73;
            static final int WRITE_MASK = 146;
            static final int W_OK = 2;

            private LibC() {
            }

            static native int getuid();

            static native int getgid();

            static native int chmod(String var0, int var1);

            static native int access(String var0, int var1);
        }
    }

    private static class IdeaWin32MediatorImpl
    implements Mediator {
        private final IdeaWin32 myInstance = IdeaWin32.getInstance();

        private IdeaWin32MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String path2) {
            FileInfo fileInfo;
            if (path2 == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(0);
            }
            return (fileInfo = this.myInstance.getInfo(path2)) != null ? fileInfo.toFileAttributes() : null;
        }

        @Override
        public String resolveSymLink(@NotNull String path2) {
            if (path2 == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(1);
            }
            path2 = new File(path2).getAbsolutePath();
            char drive = Character.toUpperCase(path2.charAt(0));
            if (path2.length() <= 3 || drive < 'A' || drive > 'Z' || path2.charAt(1) != ':' || path2.charAt(2) != '\\') {
                return path2;
            }
            int remainder = 4;
            while (remainder < path2.length()) {
                int next = path2.indexOf(92, remainder);
                String subPath = next > 0 ? path2.substring(0, next) : path2;
                FileAttributes attributes = this.getAttributes(subPath);
                if (attributes == null) {
                    return null;
                }
                if (attributes.isSymLink()) {
                    return this.myInstance.resolveSymLink(path2);
                }
                remainder = next > 0 ? next + 1 : path2.length();
            }
            return path2;
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target2, boolean execOnly) {
            if (source == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target2 == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$IdeaWin32MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Mediator {
        @Nullable
        public FileAttributes getAttributes(@NotNull String var1) throws IOException;

        @Nullable
        public String resolveSymLink(@NotNull String var1) throws IOException;

        public boolean clonePermissions(@NotNull String var1, @NotNull String var2, boolean var3) throws IOException;
    }
}

