/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsRegistryUtil {
    private WindowsRegistryUtil() {
    }

    @Nullable
    private static String trimToValue(@Nullable StringBuilder output) {
        if (output == null) {
            return null;
        }
        int pos = output.lastIndexOf("  ");
        int pos2 = output.lastIndexOf("\t");
        if ((pos = Math.max(pos, pos2)) == -1) {
            return null;
        }
        output.delete(0, pos + 1);
        String blackList = "\r\n \"";
        int startPos = 0;
        int endPos = output.length() - 1;
        while (true) {
            if (startPos >= endPos) {
                return null;
            }
            if (blackList.indexOf(output.charAt(startPos)) == -1) break;
            ++startPos;
        }
        while (blackList.indexOf(output.charAt(endPos)) != -1) {
            --endPos;
        }
        return output.subSequence(startPos, endPos + 1).toString();
    }

    @NotNull
    public static List<String> readRegistryBranch(@NotNull String location2) {
        if (location2 == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder output = WindowsRegistryUtil.doReadBranch(location2);
        if (output != null) {
            int pos = output.indexOf(location2);
            while (pos != -1) {
                String section;
                int pos2 = output.indexOf("\r\n", pos + location2.length());
                if (pos2 > pos + location2.length() && !(section = output.substring(pos + location2.length() + 1, pos2)).contains("\\")) {
                    result2.add(section);
                }
                pos = output.indexOf(location2, pos + location2.length());
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> readRegistryBranchValues(@NotNull String location2) {
        if (location2 == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(2);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder output = WindowsRegistryUtil.doReadBranch(location2);
        if (output != null) {
            Pattern pattern = Pattern.compile("^\\s{4}(.+)\\s{4}REG_\\w+\\s{4}.+$", 8);
            Matcher m = pattern.matcher(output);
            while (m.find()) {
                result2.add(m.group(1));
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static StringBuilder doReadBranch(@NotNull String location2) {
        if (location2 == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(4);
        }
        return WindowsRegistryUtil.readRegistrySilently("reg query \"" + location2 + "\"");
    }

    @Nullable
    public static String readRegistryDefault(@NonNls @NotNull String location2) {
        if (location2 == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(5);
        }
        return WindowsRegistryUtil.trimToValue(WindowsRegistryUtil.readRegistrySilently("reg query \"" + location2 + "\" /ve"));
    }

    @Nullable
    public static String readRegistryValue(@NonNls @NotNull String location2, @NonNls @NotNull String key) {
        if (location2 == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(6);
        }
        if (key == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(7);
        }
        return WindowsRegistryUtil.trimToValue(WindowsRegistryUtil.readRegistrySilently("reg query \"" + location2 + "\" /v " + key));
    }

    @Nullable
    private static StringBuilder readRegistrySilently(@NonNls @NotNull String command) {
        if (command == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(8);
        }
        try {
            String text2 = WindowsRegistryUtil.readRegistry(command);
            return new StringBuilder(text2);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @ApiStatus.Internal
    public static String readRegistry(@NonNls @NotNull String command) throws IOException, InterruptedException {
        if (command == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(9);
        }
        Process process2 = Runtime.getRuntime().exec(command);
        InputStream is = null;
        ByteArrayOutputStream os = null;
        byte[] buffer = new byte[128];
        is = process2.getInputStream();
        os = new ByteArrayOutputStream();
        int length = is.read(buffer);
        while (length > 0) {
            os.write(buffer, 0, length);
            length = is.read(buffer);
        }
        String string = new String(os.toByteArray(), StandardCharsets.UTF_8);
        String string2 = string;
        if (string2 == null) {
            WindowsRegistryUtil.$$$reportNull$$$0(10);
        }
        return string2;
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            process2.waitFor();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/WindowsRegistryUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/WindowsRegistryUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readRegistryBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readRegistryBranchValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readRegistryBranch";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readRegistryBranchValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doReadBranch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readRegistryDefault";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readRegistryValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readRegistrySilently";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readRegistry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

