/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ProcessCloseUtil {
    private static final long ourSynchronousWaitTimeout = 1000L;
    private static final long ourAsynchronousWaitTimeout = 30000L;

    public static void close(@NotNull Process process2) {
        if (process2 == null) {
            ProcessCloseUtil.$$$reportNull$$$0(0);
        }
        try {
            if (process2.waitFor(1000L, TimeUnit.MILLISECONDS)) {
                ProcessCloseUtil.closeStreams(process2);
                return;
            }
        }
        catch (InterruptedException e) {
            ProcessCloseUtil.closeStreams(process2);
            throw new RuntimeException(e);
        }
        process2.destroy();
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            try {
                if (process2.isAlive()) {
                    process2.destroyForcibly();
                }
            }
            finally {
                ProcessCloseUtil.closeStreams(process2);
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    private static void closeStreams(@NotNull Process process2) {
        if (process2 == null) {
            ProcessCloseUtil.$$$reportNull$$$0(1);
        }
        try {
            process2.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process2.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process2.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "process";
        objectArray2[1] = "com/intellij/openapi/util/process/ProcessCloseUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "close";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "closeStreams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

