/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

final class ExperimentalFeatureRegistryValueWrapper
extends RegistryValue {
    private final ExperimentalFeature myFeature;

    ExperimentalFeatureRegistryValueWrapper(@NotNull ExperimentalFeature feature) {
        if (feature == null) {
            ExperimentalFeatureRegistryValueWrapper.$$$reportNull$$$0(0);
        }
        super(Registry.getInstance(), feature.id, null);
        this.myFeature = feature;
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.myFeature.id;
        if (string == null) {
            ExperimentalFeatureRegistryValueWrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            ExperimentalFeatureRegistryValueWrapper.$$$reportNull$$$0(2);
        }
        return this.asString();
    }

    @Override
    @NotNull
    public String asString() {
        String string = Boolean.toString(this.asBoolean());
        if (string == null) {
            ExperimentalFeatureRegistryValueWrapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean asBoolean() {
        return Experiments.getInstance().isFeatureEnabled(this.myFeature.id);
    }

    @Override
    boolean isRestartRequired() {
        return false;
    }

    @Override
    public boolean isChangedFromDefault() {
        return Experiments.getInstance().isChanged(this.myFeature.id);
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public void setValue(String value2) {
        boolean enable = Boolean.parseBoolean(value2);
        Experiments.getInstance().setFeatureEnabled(this.myFeature.id, enable);
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myFeature.description;
        if (string == null) {
            ExperimentalFeatureRegistryValueWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/ExperimentalFeatureRegistryValueWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/ExperimentalFeatureRegistryValueWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

