/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.OrdinalFormat;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final String VOWELS = "aeiouy";
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    public static final String ELLIPSIS = "\u2026";
    private static final MyHtml2Text html2TextParser = new MyHtml2Text(false);
    public static final NotNullFunction<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final NotNullFunction<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    @NotNull
    public static final Function<String, String> TRIMMER = StringUtil::trim;
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    private static final String[] ourOtherNonCapitalizableWords = new String[]{"iOS", "iPhone", "iPad", "iMac"};
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};
    private static final String[] PADDED_FORMATS = new String[]{"%03d", "%02d", "%02d", "%02d", "%d"};
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start2, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start2), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        List<String> words = StringUtil.getWordsIn(find);
        words.sort((o1, o2) -> o2.length() - o1.length());
        List<String> list2 = words;
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapePattern(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.replace(StringUtil.replace(text2, "'", "''"), "{", "'{'");
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        Function<Object, String> function = Object::toString;
        if (function == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return function;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        String string = StringUtil.replace(text2, oldS, newS, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceIgnoreCase(@NotNull String text2, @NotNull String oldS, @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        String string = StringUtil.replace(text2, oldS, newS, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        String string = buffer.replace(oldChar, newChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text2.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i) : text2.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i);
            }
            newText.append(text2, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return StringUtil.indexOfIgnoreCase((CharSequence)where, (CharSequence)what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        for (int i = Math.min(fromIndex, where.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        String string = html.replaceAll("<(.|\n)*?>", "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        return StringUtil.getPackageName(fqName, '.');
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(0, lastPointIdx);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(37);
        }
        int count = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text2.length() && text2.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeLineBreak(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        StringBuilder buffer = new StringBuilder(text2.length());
        block4: for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text2, int line, int col) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text2.length()) {
                return -1;
            }
            char c = text2.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text2.length() - 1 && text2.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset) {
        LineColumn lineColumn;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text2, offset)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text2.length()) {
                return null;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text2.length() - 1 && text2.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset - curLineStart);
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        return StringUtil.fixCapitalization(s, ArrayUtil.mergeArrays(ourPrepositions, ourOtherNonCapitalizableWords), true);
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        return StringUtil.fixCapitalization(s, ourPrepositions, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, true);
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, String @NotNull [] prepositions, boolean title) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (!title && j > i + 1 && !Character.isLowerCase(s.charAt(i + 1)) || StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string = buffer == null ? s : buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, String @NotNull [] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        for (String preposition : prepositions) {
            boolean found2 = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found2 = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == StringUtil.toLowerCase(preposition.charAt(j))) continue;
                    found2 = false;
                    break;
                }
            }
            if (!found2) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static NotNullFunction<String, String> escaper(boolean escapeSlash, @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = dom -> {
            StringBuilder builder2 = new StringBuilder(dom.length());
            StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder2);
            return builder2.toString();
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        return StringUtilRt.isQuotedString(s);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        String string = StringUtilRt.unquoteString(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        String string = StringUtilRt.unquoteString(s, quotationChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string = plural;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(81);
            }
            return string;
        }
        if (word.endsWith("s")) {
            String string = Pluralizer.restoreCase(word, word + "es");
            if (string == null) {
                StringUtil.$$$reportNull$$$0(82);
            }
            return string;
        }
        String string = Pluralizer.restoreCase(word, word + "s");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text2, boolean allWords) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        return StringUtil.capitalizeWords(text2, " \t\n\r\f([<", allWords, true);
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text2, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        if (tokenizerDelim == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text2, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text2.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        String string = Introspector.decapitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(91);
            }
            return string;
        }
        if (s.length() == 1) {
            String string = StringUtil.toUpperCase(s);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(92);
            }
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(93);
            }
            return string;
        }
        String string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(96);
            }
            return string;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return StringUtil.stringHashCode(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(100);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return StringUtil.stringHashCodeInsensitive(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(char @NotNull [] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        return StringUtil.trimEnd(s, suffix, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(113);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(116);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text2, int limit) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        if (limit > 5 && text2.length() > limit) {
            String string = text2.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(119);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(120);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        String string2 = StringUtil.trimLeading((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(123);
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        CharSequence charSequence = string.subSequence(index, string.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder2, char symbol) {
        int index;
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        for (index = 0; index < builder2.length() && builder2.charAt(index) == symbol; ++index) {
        }
        if (index > 0) {
            builder2.delete(0, index);
        }
        StringBuilder stringBuilder = builder2;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        return stringBuilder;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        String string2 = StringUtil.trimTrailing((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        CharSequence charSequence = string.subSequence(0, index + 1);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        for (index = string.length() - 1; index >= 0 && string.charAt(index) == symbol; --index) {
        }
        String string2 = string.substring(0, index + 1);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder2, char symbol) {
        int index;
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        for (index = builder2.length() - 1; index >= 0 && builder2.charAt(index) == symbol; --index) {
        }
        builder2.setLength(index + 1);
        StringBuilder stringBuilder = builder2;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(139);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimExtensions(@NotNull String name) {
        int index;
        if (name == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        String string = (index = name.indexOf(46)) < 0 ? name : name.substring(0, index);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String base, int count) {
        if (base == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        if (count == 1) {
            String string = base;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(144);
            }
            return string;
        }
        return StringUtil.pluralize(base);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value2, String defaultValue) {
        return StringUtil.isEmpty(value2) ? defaultValue : value2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return StringUtilRt.isEmpty(cs);
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string = StringUtilRt.notNullize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        String string = StringUtilRt.notNullize(s, defaultValue);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        boolean empty = StringUtil.isEmpty(s) || Comparing.equal(s, defaultValue);
        return empty ? null : s;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        boolean empty = nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s);
        return empty ? null : s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return StringUtilRt.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string = StringFactory.createShared(buffer);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        List<String> list2 = StringUtilRt.splitHonorQuotes(s, separator);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        return StringUtil.split(s, separator, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        return StringUtil.split(s, separator, true, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        if (separator.length() == 0) {
            List<CharSequence> list2 = Collections.singletonList(s);
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(167);
            }
            return list2;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(final @NotNull java.util.StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        Iterable<String> iterable = () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        SmartList<String> result2 = null;
        int start2 = -1;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start2 == -1) {
                start2 = i;
            }
            if (isIdentifierPart && i == text2.length() - 1) {
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(text2.substring(start2, i + 1));
                continue;
            }
            if (isIdentifierPart || start2 == -1) continue;
            if (result2 == null) {
                result2 = new SmartList<String>();
            }
            result2.add(text2.substring(start2, i));
            start2 = -1;
        }
        if (result2 == null) {
            List<String> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(175);
            }
            return list2;
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        return StringUtil.getWordIndicesIn(text2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text2, @Nullable Set<Character> separatorsSet) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        SmartList<TextRange> result2 = new SmartList<TextRange>();
        int start2 = -1;
        for (int i = 0; i < text2.length(); ++i) {
            boolean isIdentifierPart;
            char c = text2.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start2 == -1) {
                start2 = i;
            }
            if (isIdentifierPart && i == text2.length() - 1) {
                result2.add(new TextRange(start2, i + 1));
                continue;
            }
            if (isIdentifierPart || start2 == -1) continue;
            result2.add(new TextRange(start2, i));
            start2 = -1;
        }
        SmartList<TextRange> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        return StringUtil.join(strings, 0, strings.length, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String @NotNull [] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result2.append(separator);
            }
            result2.append(strings[i]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] zip(String @NotNull [] strings1, String @NotNull [] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result2 = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = strings1[i] + separator + strings2[i];
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        return result2;
    }

    @Contract(pure=true)
    public static String @NotNull [] surround(String @NotNull [] strings, @NotNull String prefix, @NotNull String suffix) {
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        String[] result2 = ArrayUtil.newStringArray(strings.length);
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = prefix + strings[i] + suffix;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(T @NotNull [] items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (f == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        if (items == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        return StringUtil.join(Arrays.asList(items), f, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        if (items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return StringUtil.notNullize(f.fun(items.iterator().next()));
        }
        return StringUtil.join(items, f, separator);
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(items, f, separator, result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        return string;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        boolean isFirst = true;
        for (T item : items) {
            CharSequence string = f.fun(item);
            if (StringUtil.isEmpty(string)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        if (strings.size() <= 1) {
            return StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(strings, separator, result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(int @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(215);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result2.append(separator);
            }
            result2.append(strings[i]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(218);
        }
        if (strings.length == 0) {
            return "";
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string : strings) {
            builder2.append(string);
        }
        String string = builder2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static Collector<CharSequence, ?, String> joining() {
        Collector<CharSequence, ?, String> collector = Collectors.joining(", ");
        if (collector == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        return collector;
    }

    @NotNull
    @Contract(pure=true)
    public static String stripQuotesAroundValue(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        if ((len = text2.length()) > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text2, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text2, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text2.substring(from, to);
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(222);
                }
                return string;
            }
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        String string = StringUtilRt.formatFileSize(fileSize);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        String string2 = StringUtilRt.formatFileSize(fileSize, (String)unitSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration) {
        return StringUtil.formatDuration(duration, " ");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        return StringUtil.formatDuration(duration, (String)unitSeparator, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    private static String formatDuration(long duration, @NotNull String unitSeparator, int n) {
        void maxFragments;
        long multiplier;
        int i;
        if (unitSeparator == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        TLongArrayList unitValues = new TLongArrayList();
        TIntArrayList unitIndices = new TIntArrayList();
        long count = duration;
        for (i = 1; i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder != 0L || !unitValues.isEmpty()) {
                unitValues.insert(0, remainder);
                unitIndices.insert(0, i - 1);
                continue;
            }
            remainder = Math.round((double)(remainder * 100L) / (double)multiplier);
            count += remainder / 100L;
        }
        unitValues.insert(0, count);
        unitIndices.insert(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.get((int)(maxFragments - true));
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.get((int)maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.get((int)maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return StringUtil.formatDuration(duration + increment, unitSeparator, (int)maxFragments);
            }
        }
        StringBuilder result2 = new StringBuilder();
        for (i = 0; i < unitValues.size() && i < maxFragments; ++i) {
            if (i > 0) {
                result2.append(" ");
            }
            result2.append(unitValues.get(i)).append(unitSeparator).append(TIME_UNITS[unitIndices.get(i)]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatDurationPadded(long millis, @NotNull String string) {
        long multiplier;
        int i;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        StringBuilder result2 = new StringBuilder();
        long millisIn = 1L;
        for (i = 1; i < TIME_MULTIPLIERS.length && millis >= (millisIn *= (multiplier = TIME_MULTIPLIERS[i])); ++i) {
        }
        long d = millis;
        --i;
        while (i >= 0) {
            void unitSeparator;
            String format;
            long multiplier2 = i == TIME_MULTIPLIERS.length - 1 ? 1L : TIME_MULTIPLIERS[i + 1];
            long value2 = d / (millisIn /= multiplier2);
            d %= millisIn;
            String string2 = format = result2.length() == 0 ? "%d" : PADDED_FORMATS[i];
            if (result2.length() != 0) {
                result2.append(" ");
            }
            result2.append(String.format(format, value2)).append((String)unitSeparator).append(TIME_UNITS[i]);
            --i;
        }
        String string3 = result2.toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDurationApproximate(long duration) {
        return StringUtil.formatDuration(duration, " ", 2);
    }

    @NotNull
    @Contract(pure=true)
    public static String formatOrdinal(long num) {
        String string = OrdinalFormat.formatEnglish(num);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String unpluralize(@NotNull String word) {
        String singular;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        if ((singular = Pluralizer.PLURALIZER.singular(word)) != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value2) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        for (int i = 0; i < value2.length(); ++i) {
            if (!Character.isLetter(value2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        return chars.length() > value2.length() ? StringUtil.containsAnyChar(value2, chars, 0, value2.length()) : StringUtil.containsAnyChar(chars, value2, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars, int start2, int end) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        for (int i = start2; i < end; ++i) {
            if (chars.indexOf(value2.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value2, char ch) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        return value2.indexOf(ch) >= 0;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(240);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            result2.append(ch);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trim(@NotNull String s, @NotNull CharFilter filter2) {
        char ch;
        int start2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(244);
        }
        int end = s.length();
        for (start2 = 0; start2 < end && !filter2.accept(ch = s.charAt(start2)); ++start2) {
        }
        while (start2 < end && !filter2.accept(ch = s.charAt(end - 1))) {
            --end;
        }
        String string = s.substring(start2, end);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(247);
        }
        return StringUtil.findMatches(s, pattern, 1);
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        SmartList<String> result2 = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result2.add(group);
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range2, @NotNull String replacement) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        if (range2 == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        String string2 = range2.replace(string, replacement);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        return !text2.isEmpty() && Character.isWhitespace(text2.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        if ((l1 = text2.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, int startIndex, @NotNull CharSequence prefix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        int tl = text2.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        return StringUtilRt.endsWith(text2, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, int start2, int end, @NotNull CharSequence suffix) {
        int suffixLen;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        if (end < (suffixLen = suffix.length())) {
            return false;
        }
        for (int i = end - 1; i >= end - suffixLen && i >= start2; --i) {
            if (text2.charAt(i) == suffix.charAt(i + suffixLen - end)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start2, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        return StringUtil.indexOf(s, c, start2, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        return StringUtil.indexOf(s, c, start2, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start2, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start2, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        return StringUtil.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        return StringUtil.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start2) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        return StringUtil.indexOf(sequence, infix, start2, sequence.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start2, int end) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        for (int i = start2; i <= end - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start2, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start2, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] s, char c, int start2, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        end = Math.min(end, s.length);
        for (int i = Math.max(start2, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start2, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        return StringUtil.indexOfAny((CharSequence)s, chars, start2, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start2, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(300);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start2, 0); i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(303);
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringBefore(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(305);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(0, i);
    }

    @NotNull
    @Contract(pure=true)
    public static String substringBeforeLast(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        if ((i = text2.lastIndexOf(subString)) == -1) {
            String string = text2;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(308);
            }
            return string;
        }
        String string = text2.substring(0, i);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfter(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(311);
        }
        if ((i = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i + subString.length());
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfterLast(@NotNull String text2, @NotNull String subString) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(313);
        }
        if ((i = text2.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start2, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(314);
        }
        return StringUtilRt.lastIndexOf(s, c, start2, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        String string = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(317);
        }
        if (text2.length() <= length) {
            CharSequence charSequence = text2;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(318);
            }
            return charSequence;
        }
        if (appendEllipsis) {
            String string = text2.subSequence(0, length) + "...";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(319);
            }
            return string;
        }
        CharSequence charSequence = text2.subSequence(0, length);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        if (text2.length() <= length) {
            CharSequence charSequence = text2;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(322);
            }
            return charSequence;
        }
        if (prependEllipsis) {
            String string = "..." + text2.subSequence(text2.length() - length, text2.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(323);
            }
            return string;
        }
        CharSequence charSequence = text2.subSequence(text2.length() - length, text2.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String firstLast(@NotNull String text2, int length) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        String string = text2.length() > length ? text2.subSequence(0, length / 2) + ELLIPSIS + text2.subSequence(text2.length() - length / 2 - 1, text2.length()) : text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(326);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        return StringUtil.escapeChars(str, character);
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        if (character == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        return string;
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        return StringUtil.escapeChar(str, '\"');
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        return StringUtil.escapeChar(str, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        return StringUtil.escapeChar(str, '\\');
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        StringUtil.escapeChar(buf, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder2) {
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        StringUtil.quote(builder2, '\"');
    }

    public static void quote(@NotNull StringBuilder builder2, char quotingChar) {
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(346);
        }
        builder2.insert(0, quotingChar);
        builder2.append(quotingChar);
    }

    @NotNull
    @Contract(pure=true)
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(347);
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        return string;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.unescapeXmlEntities(text2);
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.escapeXmlEntities(text2);
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeXmlEntities(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(349);
        }
        return StringUtil.replace(text2, REPLACES_REFS, REPLACES_DISP);
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeXmlEntities(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(350);
        }
        return StringUtil.replace(text2, REPLACES_DISP, REPLACES_REFS);
    }

    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(351);
        }
        return StringUtil.removeHtmlTags(htmlString, false);
    }

    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString, boolean isRemoveStyleTag) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(352);
        }
        if (StringUtil.isEmpty(htmlString)) {
            return "";
        }
        MyHtml2Text parser = isRemoveStyleTag ? new MyHtml2Text(true) : html2TextParser;
        try {
            parser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
        String string = parser.getText();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeEllipsisSuffix(@NotNull String s) {
        String THREE_DOTS;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        if (s.endsWith(THREE_DOTS = "...")) {
            String string = s.substring(0, s.length() - THREE_DOTS.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(355);
            }
            return string;
        }
        if (s.endsWith(ELLIPSIS)) {
            String string = s.substring(0, s.length() - ELLIPSIS.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(356);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeMnemonics(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        return StringUtil.replace(text2, MN_CHARS, MN_QUOTED);
    }

    @NotNull
    @Contract(pure=true)
    public static String htmlEmphasize(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        String string = "<b><code>" + StringUtil.escapeXmlEntities(text2) + "</code></b>";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeToRegexp(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        StringBuilder result2 = new StringBuilder(text2.length());
        String string = StringUtil.escapeToRegexp(text2, result2).toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        return string;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text2, @NotNull StringBuilder builder2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        if (builder2 == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder2.append(c);
                continue;
            }
            if (c == '\n') {
                builder2.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder2.append("\\r");
                continue;
            }
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (block == Character.UnicodeBlock.HIGH_SURROGATES || block == Character.UnicodeBlock.LOW_SURROGATES) {
                builder2.append(c);
                continue;
            }
            builder2.append('\\').append(c);
        }
        StringBuilder stringBuilder = builder2;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(char @NotNull [] chars, int startOffset, int backslashOffset) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        if (chars[backslashOffset] != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text2, int startOffset, int backslashOffset) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(367);
        }
        if (text2.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text2.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, String @NotNull [] from, String @NotNull [] to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return StringUtil.replace(text2, Arrays.asList(from), Arrays.asList(to));
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull List<String> from, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        assert (from.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i = 0; i < text2.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (len == 0 || !text2.regionMatches(i, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text2.length());
                    result2.append(text2, 0, i);
                }
                result2.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text2.charAt(i));
        }
        String string = result2 == null ? text2 : result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] filterEmptyStrings(String @NotNull [] strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                StringUtil.$$$reportNull$$$0(376);
            }
            return strings;
        }
        String[] result2 = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result2[count++] = string;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(377);
        }
        return result2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        return StringUtil.countChars(text2, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        return StringUtil.countChars(text2, c, offset, text2.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start2, int end, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        boolean forward = start2 <= end;
        start2 = forward ? Math.max(0, start2) : Math.min(text2.length(), start2);
        end = forward ? Math.min(text2.length(), end) : Math.max(0, end);
        int count = 0;
        int i = forward ? start2 : start2 - 1;
        while (forward == i < end) {
            if (text2.charAt(i) == c) {
                ++count;
            } else if (stopAtOtherChar) break;
            i += forward ? 1 : -1;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalsOnly(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(382);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        String string = b.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(386);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(388);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, @NotNull String className) {
        if (className == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        if (packageName == null || packageName.isEmpty()) {
            String string = className;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(390);
            }
            return string;
        }
        String string = packageName + '.' + className;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        return string;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        int res2 = 0;
        for (int i = 0; i < text2.length() && (i = text2.indexOf(c, i)) >= 0; ++i) {
            ++res2;
        }
        return res2;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        int res2 = 0;
        for (int i = 0; i < text2.length() && (i = text2.indexOf(s, i)) >= 0; ++i) {
            ++res2;
        }
        return res2;
    }

    @Contract(pure=true)
    public static int getIgnoreCaseOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(395);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        int res2 = 0;
        for (int i = 0; i < text2.length() && (i = StringUtil.indexOfIgnoreCase(text2, s, i)) >= 0; ++i) {
            ++res2;
        }
        return res2;
    }

    @NotNull
    @Contract(pure=true)
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(398);
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(399);
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        StringBuilder result2 = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        return string;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        String string = idx >= s.length() ? "" : s.substring(idx);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        return StringUtil.splitByLines(string, true);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        String[] stringArray = (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        String[] stringArray = EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        String[] stringArray = EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        ArrayList<Pair<String, Integer>> res2 = new ArrayList<Pair<String, Integer>>();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res2.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        ArrayList<Pair<String, Integer>> arrayList = res2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isDecimalDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int compare(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int length1 = s1.length();
        int length2 = s2.length();
        for (int i = 0; i < length1 && i < length2; ++i) {
            int diff = StringUtil.compare(s1.charAt(i), s2.charAt(i), ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return length1 - length2;
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, false);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c;
        int start2;
        char c2;
        int start1;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    @NotNull
    public static String collapseWhiteSpace(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        StringBuilder result2 = new StringBuilder();
        boolean space = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (StringUtil.isWhiteSpace(ch)) {
                if (space) continue;
                space = true;
                continue;
            }
            if (space && result2.length() > 0) {
                result2.append(' ');
            }
            result2.append(ch);
            space = false;
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(418);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        for (String string : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9./\\-+]+");
        StringBuffer result2 = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result2, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(421);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(422);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        if (symbol == null) {
            StringUtil.$$$reportNull$$$0(425);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength > 0);
            String string = text2.substring(0, prefixLength) + symbol + text2.substring(textLength - suffixLength);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(426);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        String symbol = useEllipsisSymbol ? ELLIPSIS : "...";
        return StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path2, int maxLength, boolean useEllipsisSymbol) {
        if (path2 == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        return StringUtil.shortenTextWithEllipsis(path2, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path2, int maxLength) {
        if (path2 == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        return StringUtil.shortenPathWithEllipsis(path2, maxLength, false);
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtil.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean isUpperCase(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (Character.isUpperCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text2) {
        int index;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        if ((index = StringUtil.indexOfAny(text2, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text2, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text2, int index) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        if (index < 0 || index >= text2.length()) {
            return null;
        }
        char ch = text2.charAt(index);
        if (ch == '\r') {
            return index + 1 < text2.length() && text2.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        String string = StringUtilRt.convertLineSeparators(text2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        String string = StringUtilRt.convertLineSeparators(text2, keepCarriageReturn);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, int @Nullable [] offsetsToKeep) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator, offsetsToKeep);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        return StringUtilRt.parseEnum(string, defaultValue, clazz);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StringUtil.$$$reportNull$$$0(446);
        }
        String string = StringUtilRt.getShortName(aClass);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        String string = StringUtilRt.getShortName(fqName);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(449);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(450);
        }
        String string = StringUtilRt.getShortName(fqName, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        return string;
    }

    public static boolean isShortNameOf(@NotNull String fqName, @NotNull String shortName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(452);
        }
        if (shortName == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        if (fqName.length() < shortName.length()) {
            return false;
        }
        if (fqName.length() == shortName.length()) {
            return fqName.equals(shortName);
        }
        int diff = fqName.length() - shortName.length();
        if (fqName.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className)) {
            return s;
        }
        return s.length() > className.length() && !Character.isLetter(s.charAt(className.length())) ? StringUtil.trimStart(s, className) : s;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(454);
        }
        final long myTime = System.currentTimeMillis() + delay;
        return new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(455);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(456);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(457);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(458);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(459);
        }
        return (s = StringUtil.toLowerCase(string)).startsWith(StringUtil.toLowerCase(smallPart)) && StringUtil.toLowerCase(bigPart).startsWith(s);
    }

    public static boolean hasUpperCaseChar(@NotNull String s) {
        char[] chars;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(460);
        }
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(@NotNull String s) {
        char[] chars;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(461);
        }
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text2) {
        if (text2 == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text2);
        if (!matcher.find()) {
            return text2;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text2.length());
        while (matcher.find()) {
            sb.append(text2, lastEnd, matcher.start());
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text2.substring(lastEnd));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(462);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(463);
        }
        return string;
    }

    @Contract(pure=true)
    public static byte @NotNull [] parseHexString(@NotNull String str) {
        int len;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(464);
        }
        if ((len = str.length()) % 2 != 0) {
            throw new IllegalArgumentException("Non-even-length: " + str);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(465);
        }
        return bytes;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(466);
        }
        if (firstPrefix == null) {
            StringUtil.$$$reportNull$$$0(467);
        }
        if (secondPrefix == null) {
            StringUtil.$$$reportNull$$$0(468);
        }
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    public static int skipWhitespaceForward(@NotNull CharSequence text2, int pos) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(469);
        }
        int length = text2.length();
        while (pos < length && StringUtil.isWhitespaceOrTab(text2.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespaceBackward(@NotNull CharSequence text2, int pos) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(470);
        }
        while (pos > 0 && StringUtil.isWhitespaceOrTab(text2.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    private static boolean isWhitespaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 200: 
            case 204: 
            case 211: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 229: 
            case 231: 
            case 232: 
            case 242: 
            case 245: 
            case 250: 
            case 256: 
            case 268: 
            case 275: 
            case 308: 
            case 309: 
            case 316: 
            case 318: 
            case 319: 
            case 320: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 330: 
            case 338: 
            case 340: 
            case 342: 
            case 348: 
            case 353: 
            case 355: 
            case 356: 
            case 357: 
            case 360: 
            case 362: 
            case 365: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 390: 
            case 391: 
            case 398: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 408: 
            case 410: 
            case 412: 
            case 414: 
            case 418: 
            case 421: 
            case 426: 
            case 427: 
            case 435: 
            case 437: 
            case 440: 
            case 443: 
            case 447: 
            case 449: 
            case 451: 
            case 463: 
            case 465: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 200: 
            case 204: 
            case 211: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 229: 
            case 231: 
            case 232: 
            case 242: 
            case 245: 
            case 250: 
            case 256: 
            case 268: 
            case 275: 
            case 308: 
            case 309: 
            case 316: 
            case 318: 
            case 319: 
            case 320: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 330: 
            case 338: 
            case 340: 
            case 342: 
            case 348: 
            case 353: 
            case 355: 
            case 356: 
            case 357: 
            case 360: 
            case 362: 
            case 365: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 390: 
            case 391: 
            case 398: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 408: 
            case 410: 
            case 412: 
            case 414: 
            case 418: 
            case 421: 
            case 426: 
            case 427: 
            case 435: 
            case 437: 
            case 440: 
            case 443: 
            case 447: 
            case 449: 
            case 451: 
            case 463: 
            case 465: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 200: 
            case 204: 
            case 211: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 229: 
            case 231: 
            case 232: 
            case 242: 
            case 245: 
            case 250: 
            case 256: 
            case 268: 
            case 275: 
            case 308: 
            case 309: 
            case 316: 
            case 318: 
            case 319: 
            case 320: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 330: 
            case 338: 
            case 340: 
            case 342: 
            case 348: 
            case 353: 
            case 355: 
            case 356: 
            case 357: 
            case 360: 
            case 362: 
            case 365: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 390: 
            case 391: 
            case 398: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 408: 
            case 410: 
            case 412: 
            case 414: 
            case 418: 
            case 421: 
            case 426: 
            case 427: 
            case 435: 
            case 437: 
            case 440: 
            case 443: 
            case 447: 
            case 449: 
            case 451: 
            case 463: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 84: 
            case 85: 
            case 118: 
            case 174: 
            case 177: 
            case 178: 
            case 221: 
            case 257: 
            case 258: 
            case 260: 
            case 262: 
            case 264: 
            case 292: 
            case 304: 
            case 306: 
            case 310: 
            case 312: 
            case 315: 
            case 317: 
            case 321: 
            case 325: 
            case 349: 
            case 350: 
            case 358: 
            case 359: 
            case 361: 
            case 363: 
            case 367: 
            case 368: 
            case 371: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 386: 
            case 392: 
            case 393: 
            case 395: 
            case 422: 
            case 423: 
            case 424: 
            case 428: 
            case 432: 
            case 433: 
            case 434: 
            case 436: 
            case 438: 
            case 441: 
            case 469: 
            case 470: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 15: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 79: 
            case 145: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 419: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 327: 
            case 328: 
            case 332: 
            case 334: 
            case 335: 
            case 337: 
            case 339: 
            case 341: 
            case 344: 
            case 347: 
            case 464: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 110: 
            case 112: 
            case 189: 
            case 263: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 138: 
            case 188: 
            case 259: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 34: 
            case 35: 
            case 448: 
            case 450: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 45: 
            case 266: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 415: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 46: 
            case 267: 
            case 270: 
            case 272: 
            case 274: 
            case 277: 
            case 416: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 88: 
            case 90: 
            case 95: 
            case 109: 
            case 111: 
            case 115: 
            case 137: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 169: 
            case 240: 
            case 243: 
            case 246: 
            case 248: 
            case 251: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 290: 
            case 291: 
            case 294: 
            case 296: 
            case 298: 
            case 300: 
            case 302: 
            case 314: 
            case 354: 
            case 382: 
            case 394: 
            case 396: 
            case 403: 
            case 404: 
            case 413: 
            case 417: 
            case 460: 
            case 461: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 80: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 236: 
            case 238: 
            case 295: 
            case 297: 
            case 299: 
            case 301: 
            case 303: 
            case 366: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 107: 
            case 121: 
            case 123: 
            case 125: 
            case 129: 
            case 131: 
            case 133: 
            case 253: 
            case 406: 
            case 407: 
            case 409: 
            case 411: 
            case 444: 
            case 457: 
            case 466: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 127: 
            case 135: 
            case 345: 
            case 346: 
            case 364: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 141: 
            case 397: 
            case 401: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 180: 
            case 182: 
            case 193: 
            case 197: 
            case 199: 
            case 203: 
            case 207: 
            case 210: 
            case 213: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 181: 
            case 183: 
            case 190: 
            case 209: 
            case 212: 
            case 216: 
            case 218: 
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 192: 
            case 196: 
            case 202: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 194: 
            case 195: 
            case 198: 
            case 201: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 208: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 225: 
            case 227: 
            case 228: 
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 234: 
            case 235: 
            case 237: 
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 241: 
            case 244: 
            case 252: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 247: 
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 254: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 282: 
            case 284: 
            case 286: 
            case 288: 
            case 431: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 283: 
            case 285: 
            case 287: 
            case 289: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 293: 
            case 305: 
            case 307: 
            case 311: 
            case 313: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 329: {
                objectArray2 = objectArray3;
                objectArray3[0] = "character";
                break;
            }
            case 331: 
            case 333: 
            case 336: 
            case 343: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 351: 
            case 352: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 369: 
            case 372: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 370: 
            case 373: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 385: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 387: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 389: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 420: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 425: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 429: 
            case 430: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 439: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 456: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 458: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 459: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 462: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 467: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 468: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 10: 
            case 374: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 65: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 113: 
            case 114: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 122: 
            case 124: 
            case 126: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 130: 
            case 132: 
            case 134: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 146: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 171: 
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 184: 
            case 200: 
            case 204: 
            case 211: 
            case 217: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 220: {
                objectArray = objectArray2;
                objectArray2[1] = "joining";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 224: 
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPadded";
                break;
            }
            case 232: {
                objectArray = objectArray2;
                objectArray2[1] = "formatOrdinal";
                break;
            }
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 308: 
            case 309: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 316: 
            case 318: 
            case 319: 
            case 320: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 322: 
            case 323: 
            case 324: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 326: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 330: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 338: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlashes";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 348: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 353: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 355: 
            case 356: 
            case 357: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEllipsisSuffix";
                break;
            }
            case 360: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 362: 
            case 365: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 376: 
            case 377: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 383: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalsOnly";
                break;
            }
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 390: 
            case 391: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 398: 
            case 399: 
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 405: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 412: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 414: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 418: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseWhiteSpace";
                break;
            }
            case 421: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 426: 
            case 427: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 435: 
            case 437: 
            case 440: 
            case 443: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 447: 
            case 449: 
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 463: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 465: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 200: 
            case 204: 
            case 211: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 229: 
            case 231: 
            case 232: 
            case 242: 
            case 245: 
            case 250: 
            case 256: 
            case 268: 
            case 275: 
            case 308: 
            case 309: 
            case 316: 
            case 318: 
            case 319: 
            case 320: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 330: 
            case 338: 
            case 340: 
            case 342: 
            case 348: 
            case 353: 
            case 355: 
            case 356: 
            case 357: 
            case 360: 
            case 362: 
            case 365: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 390: 
            case 391: 
            case 398: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 408: 
            case 410: 
            case 412: 
            case 414: 
            case 418: 
            case 421: 
            case 426: 
            case 427: 
            case 435: 
            case 437: 
            case 440: 
            case 443: 
            case 447: 
            case 449: 
            case 451: 
            case 463: 
            case 465: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 70: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 80: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 455: 
            case 456: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 129: 
            case 131: 
            case 133: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 169: 
            case 170: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 188: 
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "formatDurationPadded";
                break;
            }
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 235: 
            case 236: 
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 246: 
            case 247: 
            case 248: 
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 251: 
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 253: 
            case 254: 
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 258: 
            case 259: 
            case 260: 
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 262: 
            case 263: 
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 269: 
            case 270: 
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 276: 
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 278: 
            case 282: 
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 279: 
            case 280: 
            case 281: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 302: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 304: 
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 306: 
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 310: 
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 312: 
            case 313: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 315: 
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 325: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 327: 
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 328: 
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 332: 
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 334: 
            case 336: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlashes";
                break;
            }
            case 339: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 341: 
            case 343: 
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 345: 
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 347: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 350: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 351: 
            case 352: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "removeEllipsisSuffix";
                break;
            }
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 361: 
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 366: 
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 378: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 379: 
            case 380: 
            case 381: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 382: {
                objectArray = objectArray;
                objectArray[2] = "capitalsOnly";
                break;
            }
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 385: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 392: 
            case 393: 
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 395: 
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreCaseOccurrenceCount";
                break;
            }
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 406: 
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 415: 
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 422: 
            case 424: 
            case 425: 
            case 428: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 423: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 429: 
            case 430: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 432: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 434: 
            case 436: 
            case 438: 
            case 439: 
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 444: 
            case 445: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 446: 
            case 448: 
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 452: 
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 457: 
            case 458: 
            case 459: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "hasUpperCaseChar";
                break;
            }
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "hasLowerCaseChar";
                break;
            }
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 464: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 466: 
            case 467: 
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
            case 469: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceForward";
                break;
            }
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceBackward";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 33: 
            case 36: 
            case 40: 
            case 52: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 167: 
            case 168: 
            case 171: 
            case 173: 
            case 175: 
            case 176: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 200: 
            case 204: 
            case 211: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 229: 
            case 231: 
            case 232: 
            case 242: 
            case 245: 
            case 250: 
            case 256: 
            case 268: 
            case 275: 
            case 308: 
            case 309: 
            case 316: 
            case 318: 
            case 319: 
            case 320: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 330: 
            case 338: 
            case 340: 
            case 342: 
            case 348: 
            case 353: 
            case 355: 
            case 356: 
            case 357: 
            case 360: 
            case 362: 
            case 365: 
            case 374: 
            case 376: 
            case 377: 
            case 383: 
            case 388: 
            case 390: 
            case 391: 
            case 398: 
            case 399: 
            case 400: 
            case 402: 
            case 405: 
            case 408: 
            case 410: 
            case 412: 
            case 414: 
            case 418: 
            case 421: 
            case 426: 
            case 427: 
            case 435: 
            case 437: 
            case 440: 
            case 443: 
            case 447: 
            case 449: 
            case 451: 
            case 463: 
            case 465: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;
        private boolean myDefused;

        public BombedCharSequence(@NotNull CharSequence sequence) {
            if (sequence == null) {
                BombedCharSequence.$$$reportNull$$$0(0);
            }
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if (this.myDefused) {
                return;
            }
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        public final void defuse() {
            this.myDefused = true;
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string = this.delegate.toString();
            if (string == null) {
                BombedCharSequence.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i, int i1) {
            this.check();
            CharSequence charSequence = this.delegate.subSequence(i, i1);
            if (charSequence == null) {
                BombedCharSequence.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        public void parse(@NotNull Reader in) throws IOException {
            if (in == null) {
                MyHtml2Text.$$$reportNull$$$0(0);
            }
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char @NotNull [] text2, int pos) {
            if (text2 == null) {
                MyHtml2Text.$$$reportNull$$$0(1);
            }
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text2);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag2, MutableAttributeSet set, int i) {
            if (tag2 == null) {
                MyHtml2Text.$$$reportNull$$$0(2);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag2.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag2);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag2, int pos) {
            if (tag2 == null) {
                MyHtml2Text.$$$reportNull$$$0(3);
            }
            if (this.myIsSkipStyleTag && "style".equals(tag2.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag2, MutableAttributeSet set, int i) {
            this.handleTag(tag2);
        }

        private void handleTag(@NotNull HTML.Tag tag2) {
            if (tag2 == null) {
                MyHtml2Text.$$$reportNull$$$0(4);
            }
            if (tag2.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        @NotNull
        public String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                MyHtml2Text.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$MyHtml2Text";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleStartTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEndTag";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTag";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

