/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CachingCommittedChangesProvider<T extends CommittedChangeList, U extends ChangeBrowserSettings>
extends CommittedChangesProvider<T, U> {
    public int getFormatVersion();

    public void writeChangeList(@NotNull DataOutput var1, @NotNull T var2) throws IOException;

    @NotNull
    public T readChangeList(@NotNull RepositoryLocation var1, @NotNull DataInput var2) throws IOException;

    default public boolean isMaxCountSupported() {
        return true;
    }

    @Nullable
    default public Collection<FilePath> getIncomingFiles(@NotNull RepositoryLocation location2) throws VcsException {
        if (location2 == null) {
            CachingCommittedChangesProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    default public boolean refreshCacheByNumber() {
        return true;
    }

    @Nullable
    @Nls
    public String getChangelistTitle();

    default public boolean isChangeLocallyAvailable(@NotNull FilePath filePath2, @Nullable VcsRevisionNumber localRevision, @NotNull VcsRevisionNumber changeRevision, @NotNull T changeList) {
        if (filePath2 == null) {
            CachingCommittedChangesProvider.$$$reportNull$$$0(1);
        }
        if (changeRevision == null) {
            CachingCommittedChangesProvider.$$$reportNull$$$0(2);
        }
        if (changeList == null) {
            CachingCommittedChangesProvider.$$$reportNull$$$0(3);
        }
        return localRevision != null && localRevision.compareTo(changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRevision";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/CachingCommittedChangesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIncomingFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isChangeLocallyAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

