/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

@State(name="IssueNavigationConfiguration", storages={@Storage(value="vcs.xml")})
public class IssueNavigationConfiguration
extends SimpleModificationTracker
implements PersistentStateComponent<IssueNavigationConfiguration> {
    private static final Logger LOG = Logger.getInstance(IssueNavigationConfiguration.class);
    private List<IssueNavigationLink> myLinks = new ArrayList<IssueNavigationLink>();

    public static IssueNavigationConfiguration getInstance(Project project2) {
        return ServiceManager.getService(project2, IssueNavigationConfiguration.class);
    }

    public List<IssueNavigationLink> getLinks() {
        return this.myLinks;
    }

    public void setLinks(List<? extends IssueNavigationLink> links) {
        this.myLinks = new ArrayList<IssueNavigationLink>(links);
        this.incModificationCount();
    }

    @Override
    public IssueNavigationConfiguration getState() {
        return this;
    }

    @Override
    public void loadState(@NotNull IssueNavigationConfiguration state) {
        if (state == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean(state, this);
    }

    public List<LinkMatch> findIssueLinks(CharSequence text2) {
        ArrayList<LinkMatch> result2 = new ArrayList<LinkMatch>();
        try {
            TextRange match;
            for (IssueNavigationLink link : this.myLinks) {
                Pattern issuePattern = link.getIssuePattern();
                Matcher m = issuePattern.matcher(text2);
                while (m.find()) {
                    try {
                        String replacement = issuePattern.matcher(m.group(0)).replaceFirst(link.getLinkRegexp());
                        IssueNavigationConfiguration.addMatch(result2, new TextRange(m.start(), m.end()), replacement);
                    }
                    catch (Exception e) {
                        LOG.debug("Malformed regex replacement. IssueLink: " + link + "; text: " + text2, e);
                    }
                }
            }
            int lastOffset = 0;
            while ((match = URLUtil.findUrl(text2, lastOffset, text2.length())) != null) {
                IssueNavigationConfiguration.addMatch(result2, match, match.subSequence(text2).toString());
                lastOffset = match.getEndOffset();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        Collections.sort(result2);
        return result2;
    }

    private static void addMatch(List<LinkMatch> result2, TextRange range2, String replacement) {
        Iterator<LinkMatch> iterator2 = result2.iterator();
        while (iterator2.hasNext()) {
            LinkMatch oldMatch = iterator2.next();
            if (range2.contains(oldMatch.getRange())) {
                iterator2.remove();
                continue;
            }
            if (!oldMatch.getRange().contains(range2)) continue;
            return;
        }
        result2.add(new LinkMatch(range2, replacement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vcs/IssueNavigationConfiguration", "loadState"));
    }

    public static class LinkMatch
    implements Comparable {
        private final TextRange myRange;
        private final String myTargetUrl;

        public LinkMatch(TextRange range2, String targetUrl) {
            this.myRange = range2;
            this.myTargetUrl = targetUrl;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public String getTargetUrl() {
            return this.myTargetUrl;
        }

        public int compareTo(Object o) {
            if (!(o instanceof LinkMatch)) {
                return 0;
            }
            return this.myRange.getStartOffset() - ((LinkMatch)o).getRange().getStartOffset();
        }
    }
}

