/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class StartedActivated {
    private static final Logger LOG = Logger.getInstance(StartedActivated.class);
    private final MySection myStart = new MySection(() -> this.start(), () -> this.shutdown());
    private final MySection myActivate = new MySection(() -> this.activate(), () -> this.deactivate());
    private final Object myLock;

    protected StartedActivated(Disposable parent) {
        this.myStart.setDependent(this.myActivate);
        this.myActivate.setMaster(this.myStart);
        this.myLock = new Object();
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                try {
                    StartedActivated.this.doShutdown();
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
        });
    }

    protected abstract void start() throws VcsException;

    protected abstract void shutdown() throws VcsException;

    protected abstract void activate() throws VcsException;

    protected abstract void deactivate() throws VcsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callImpl(MySection section, boolean start2) throws VcsException {
        ArrayList<ThrowableRunnable<VcsException>> list2 = new ArrayList<ThrowableRunnable<VcsException>>(2);
        Iterator iterator2 = this.myLock;
        synchronized (iterator2) {
            if (start2) {
                section.start(list2);
            } else {
                section.stop(list2);
            }
        }
        for (ThrowableRunnable throwableRunnable : list2) {
            throwableRunnable.run();
        }
    }

    public final void doStart() throws VcsException {
        this.callImpl(this.myStart, true);
    }

    public final void doShutdown() throws VcsException {
        this.callImpl(this.myStart, false);
    }

    public final void doActivate() throws VcsException {
        this.callImpl(this.myActivate, true);
    }

    public final void doDeactivate() throws VcsException {
        this.callImpl(this.myActivate, false);
    }

    private static class MySection {
        private MySection myMaster;
        private MySection myDependent;
        private final ThrowableRunnable<VcsException> myStart;
        private final ThrowableRunnable<VcsException> myStop;
        private ThreeState myState;

        MySection(ThrowableRunnable<VcsException> start2, ThrowableRunnable<VcsException> stop2) {
            this.myStart = start2;
            this.myStop = stop2;
            this.myState = ThreeState.UNSURE;
        }

        public void start(List<ThrowableRunnable<VcsException>> callList) {
            if (this.myMaster != null) {
                this.myMaster.start(callList);
            }
            if (!ThreeState.YES.equals((Object)this.myState)) {
                this.myState = ThreeState.YES;
                callList.add(this.myStart);
            }
        }

        public void stop(List<ThrowableRunnable<VcsException>> callList) {
            if (this.myDependent != null) {
                this.myDependent.stop(callList);
            }
            if (ThreeState.YES.equals((Object)this.myState)) {
                this.myState = ThreeState.NO;
                callList.add(this.myStop);
            }
        }

        public void setMaster(MySection master) {
            this.myMaster = master;
        }

        public void setDependent(MySection dependent) {
            this.myDependent = dependent;
        }
    }
}

