/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTaskHandler {
    private static final String DEFAULT_PROHIBITED_SYMBOLS = " ";
    private static final ExtensionPointName<VcsTaskHandler> EXTENSION_POINT_NAME = ExtensionPointName.create("com.intellij.vcs.taskHandler");

    public static VcsTaskHandler[] getAllHandlers(Project project2) {
        VcsTaskHandler[] extensions2 = EXTENSION_POINT_NAME.getExtensions(project2);
        List<VcsTaskHandler> handlers = ContainerUtil.filter(extensions2, handler2 -> handler2.isEnabled());
        return handlers.toArray(new VcsTaskHandler[0]);
    }

    public abstract boolean isEnabled();

    public abstract TaskInfo startNewTask(@NotNull String var1);

    public abstract boolean switchToTask(TaskInfo var1, @Nullable Runnable var2);

    public abstract void closeTask(@NotNull TaskInfo var1, @NotNull TaskInfo var2);

    public abstract boolean isSyncEnabled();

    public abstract TaskInfo @NotNull [] getCurrentTasks();

    public abstract TaskInfo[] getAllExistingTasks();

    public boolean isBranchNameValid(@NotNull String branchName) {
        if (branchName == null) {
            VcsTaskHandler.$$$reportNull$$$0(0);
        }
        return !branchName.contains(DEFAULT_PROHIBITED_SYMBOLS);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            VcsTaskHandler.$$$reportNull$$$0(1);
        }
        String string = suggestedName.replaceAll(DEFAULT_PROHIBITED_SYMBOLS, "-");
        if (string == null) {
            VcsTaskHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsTaskHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsTaskHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBranchNameValid";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TaskInfo
    implements Comparable<TaskInfo> {
        private final String myBranch;
        private final Collection<String> myRepositories;
        private final boolean myRemote;

        public TaskInfo(String branch, Collection<String> repositories) {
            this(branch, repositories, false);
        }

        public TaskInfo(String branch, Collection<String> repositories, boolean remote) {
            this.myBranch = branch;
            this.myRepositories = repositories;
            this.myRemote = remote;
        }

        public String getName() {
            return this.myBranch;
        }

        public boolean isRemote() {
            return this.myRemote;
        }

        public Collection<String> getRepositories() {
            return this.myRepositories;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public int compareTo(TaskInfo o) {
            return Comparing.compare(this.myBranch, o.myBranch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskInfo info = (TaskInfo)o;
            if (this.myRemote != info.myRemote) {
                return false;
            }
            if (!this.myBranch.equals(info.myBranch)) {
                return false;
            }
            return this.myRepositories.size() == info.myRepositories.size() && this.myRepositories.containsAll(info.myRepositories);
        }

        public int hashCode() {
            return this.myBranch.hashCode();
        }
    }
}

