/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesUtil {
    private static final Key<Boolean> INTERNAL_OPERATION_KEY = Key.create("internal vcs operation");
    public static final TObjectHashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        @Override
        public int computeHashCode(@Nullable FilePath path2) {
            return path2 != null ? Objects.hash(path2.getPath(), path2.isDirectory()) : 0;
        }

        @Override
        public boolean equals(@Nullable FilePath path1, @Nullable FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            return path1.isDirectory() == path2.isDirectory() && path1.getPath().equals(path2.getPath());
        }
    };
    public static final Comparator<LocalChangeList> CHANGELIST_COMPARATOR = Comparator.comparingInt(list2 -> list2.isDefault() ? -1 : 0).thenComparing(list2 -> list2.getName(), String::compareToIgnoreCase);

    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(0);
        }
        if ((revision = change.getAfterRevision()) == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        FilePath filePath2 = revision.getFile();
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(1);
        }
        return filePath2;
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(2);
        }
        return (revision = change.getBeforeRevision()) == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(3);
        }
        return (revision = change.getAfterRevision()) == null ? null : revision.getFile();
    }

    public static boolean isAffectedByChange(@NotNull FilePath filePath2, @NotNull Change change) {
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(4);
        }
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(5);
        }
        if (filePath2.equals(ChangesUtil.getBeforePath(change))) {
            return true;
        }
        return filePath2.equals(ChangesUtil.getAfterPath(change));
    }

    @Nullable
    public static AbstractVcs getVcsForChange(@NotNull Change change, @NotNull Project project2) {
        AbstractVcs result2;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(7);
        }
        return (result2 = ChangeListManager.getInstance(project2).getVcsFor(change)) != null ? result2 : ProjectLevelVcsManager.getInstance(project2).getVcsFor(ChangesUtil.getFilePath(change));
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcses(@NotNull Collection<? extends Change> changes, @NotNull Project project2) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(9);
        }
        Set<AbstractVcs> set = ContainerUtil.map2SetNotNull(changes, change -> ChangesUtil.getVcsForChange(change, project2));
        if (set == null) {
            ChangesUtil.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcsesForFiles(@NotNull Collection<? extends VirtualFile> files2, @NotNull Project project2) {
        if (files2 == null) {
            ChangesUtil.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(12);
        }
        Set<AbstractVcs> set = ContainerUtil.map2SetNotNull(files2, file2 -> ChangesUtil.getVcsForFile(file2, project2));
        if (set == null) {
            ChangesUtil.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            ChangesUtil.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(15);
        }
        return ProjectLevelVcsManager.getInstance(project2).getVcsFor(file2);
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull File file2, @NotNull Project project2) {
        if (file2 == null) {
            ChangesUtil.$$$reportNull$$$0(16);
        }
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(17);
        }
        return ProjectLevelVcsManager.getInstance(project2).getVcsFor(VcsUtil.getFilePath(file2));
    }

    @NotNull
    public static List<FilePath> getPaths(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(18);
        }
        List<FilePath> list2 = ChangesUtil.getPaths(changes.stream()).collect(Collectors.toList());
        if (list2 == null) {
            ChangesUtil.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public static List<File> getIoFilesFromChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(20);
        }
        List<File> list2 = ChangesUtil.getPaths(changes.stream()).map(FilePath::getIOFile).distinct().collect(Collectors.toList());
        if (list2 == null) {
            ChangesUtil.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    public static Stream<FilePath> getPaths(@NotNull Stream<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(22);
        }
        Stream<FilePath> stream = changes.flatMap(ChangesUtil::getPathsCaseSensitive);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(23);
        }
        return stream;
    }

    @NotNull
    public static Stream<FilePath> getPathsCaseSensitive(@NotNull Change change) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(24);
        }
        FilePath beforePath = ChangesUtil.getBeforePath(change);
        FilePath afterPath = ChangesUtil.getAfterPath(change);
        Stream<FilePath> stream = Stream.of(beforePath, !CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals(beforePath, afterPath) ? afterPath : null).filter(Objects::nonNull);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(25);
        }
        return stream;
    }

    @NotNull
    public static Stream<VirtualFile> getFiles(@NotNull Stream<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(26);
        }
        Stream<VirtualFile> stream = ChangesUtil.getPaths(changes).map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(27);
        }
        return stream;
    }

    @NotNull
    public static Stream<VirtualFile> getFilesFromPaths(@NotNull Stream<? extends FilePath> paths) {
        if (paths == null) {
            ChangesUtil.$$$reportNull$$$0(28);
        }
        Stream<VirtualFile> stream = paths.map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(29);
        }
        return stream;
    }

    @NotNull
    public static Stream<VirtualFile> getAfterRevisionsFiles(@NotNull Stream<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(30);
        }
        Stream<VirtualFile> stream = changes.map(ChangesUtil::getAfterPath).filter(Objects::nonNull).map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(31);
        }
        return stream;
    }

    public static VirtualFile @NotNull [] getFilesFromChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(32);
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ChangesUtil.getFiles(changes.stream()).toArray(VirtualFile[]::new);
        if (virtualFileArray == null) {
            ChangesUtil.$$$reportNull$$$0(33);
        }
        return virtualFileArray;
    }

    public static Navigatable @NotNull [] getNavigatableArray(@NotNull Project project2, VirtualFile @NotNull [] files2) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(34);
        }
        if (files2 == null) {
            ChangesUtil.$$$reportNull$$$0(35);
        }
        return ChangesUtil.getNavigatableArray(project2, Stream.of(files2));
    }

    public static Navigatable @NotNull [] getNavigatableArray(@NotNull Project project2, @NotNull Stream<? extends VirtualFile> files2) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(36);
        }
        if (files2 == null) {
            ChangesUtil.$$$reportNull$$$0(37);
        }
        Navigatable[] navigatableArray = (Navigatable[])files2.filter(file2 -> !file2.isDirectory()).map(file2 -> new OpenFileDescriptor(project2, (VirtualFile)file2)).toArray(Navigatable[]::new);
        if (navigatableArray == null) {
            ChangesUtil.$$$reportNull$$$0(38);
        }
        return navigatableArray;
    }

    @Nullable
    public static LocalChangeList getChangeListIfOnlyOne(@NotNull Project project2, Change @Nullable [] changes) {
        ChangeListManager manager;
        String changeListName;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(39);
        }
        return (changeListName = (manager = ChangeListManager.getInstance(project2)).getChangeListNameIfOnlyOne(changes)) == null ? null : manager.findChangeList(changeListName);
    }

    public static FilePath getCommittedPath(@NotNull Project project2, FilePath filePath2) {
        Change change;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(40);
        }
        if ((change = ChangeListManager.getInstance(project2).getChange(filePath2)) != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath2)) {
                filePath2 = beforeRevision.getFile();
            }
        }
        return filePath2;
    }

    public static FilePath getLocalPath(@NotNull Project project2, FilePath filePath2) {
        Change change;
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(41);
        }
        if ((change = ReadAction.compute(() -> {
            if (project2.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ChangeListManager.getInstance(project2).getChange(filePath2);
        })) != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath2)) {
                return afterRevision.getFile();
            }
        }
        return filePath2;
    }

    @Nullable
    public static VirtualFile findValidParentAccurately(@NotNull FilePath filePath2) {
        VirtualFile result2;
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(42);
        }
        if ((result2 = filePath2.getVirtualFile()) == null && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            result2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath2.getPath());
        }
        if (result2 == null) {
            result2 = ChangesUtil.getValidParentUnderReadAction(filePath2);
        }
        return result2;
    }

    @Nullable
    private static VirtualFile getValidParentUnderReadAction(@NotNull FilePath filePath2) {
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(43);
        }
        return ReadAction.compute(() -> {
            VirtualFile result2 = null;
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (FilePath parent = filePath2; result2 == null && parent != null; parent = parent.getParentPath()) {
                result2 = lfs.findFileByPath(parent.getPath());
            }
            return result2;
        });
    }

    @Nullable
    public static String getProjectRelativePath(@NotNull Project project2, @Nullable File fileName) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(44);
        }
        if (fileName == null) {
            return null;
        }
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath(VfsUtilCore.virtualToIoFile(baseDir), fileName);
        if (relativePath != null) {
            return relativePath;
        }
        return fileName.toString();
    }

    public static boolean isTextConflictingChange(@NotNull Change change) {
        FileStatus status;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(45);
        }
        return FileStatus.MERGED_WITH_CONFLICTS.equals(status = change.getFileStatus()) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static <T> void processItemsByVcs(@NotNull Collection<? extends T> items, @NotNull VcsSeparator<? super T> separator, @NotNull PerVcsProcessor<T> processor2) {
        if (items == null) {
            ChangesUtil.$$$reportNull$$$0(46);
        }
        if (separator == null) {
            ChangesUtil.$$$reportNull$$$0(47);
        }
        if (processor2 == null) {
            ChangesUtil.$$$reportNull$$$0(48);
        }
        Map changesByVcs = ReadAction.compute(() -> StreamEx.of((Collection)items).mapToEntry(separator::getVcsFor, Function.identity()).nonNullKeys().grouping());
        changesByVcs.forEach(processor2::process);
    }

    public static void processChangesByVcs(@NotNull Project project2, @NotNull Collection<? extends Change> changes, @NotNull PerVcsProcessor<Change> processor2) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(49);
        }
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(50);
        }
        if (processor2 == null) {
            ChangesUtil.$$$reportNull$$$0(51);
        }
        ChangesUtil.processItemsByVcs(changes, change -> ChangesUtil.getVcsForChange(change, project2), processor2);
    }

    public static void processVirtualFilesByVcs(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files2, @NotNull PerVcsProcessor<VirtualFile> processor2) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(52);
        }
        if (files2 == null) {
            ChangesUtil.$$$reportNull$$$0(53);
        }
        if (processor2 == null) {
            ChangesUtil.$$$reportNull$$$0(54);
        }
        ChangesUtil.processItemsByVcs(files2, file2 -> ChangesUtil.getVcsForFile(file2, project2), processor2);
    }

    public static void processFilePathsByVcs(@NotNull Project project2, @NotNull Collection<? extends FilePath> files2, @NotNull PerVcsProcessor<FilePath> processor2) {
        if (project2 == null) {
            ChangesUtil.$$$reportNull$$$0(55);
        }
        if (files2 == null) {
            ChangesUtil.$$$reportNull$$$0(56);
        }
        if (processor2 == null) {
            ChangesUtil.$$$reportNull$$$0(57);
        }
        ChangesUtil.processItemsByVcs(files2, filePath2 -> ChangesUtil.getVcsForFile(filePath2.getIOFile(), project2), processor2);
    }

    @NotNull
    public static List<File> filePathsToFiles(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            ChangesUtil.$$$reportNull$$$0(58);
        }
        List<File> list2 = ContainerUtil.map(filePaths, FilePath::getIOFile);
        if (list2 == null) {
            ChangesUtil.$$$reportNull$$$0(59);
        }
        return list2;
    }

    public static boolean hasFileChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(60);
        }
        return changes.stream().map(ChangesUtil::getFilePath).anyMatch(path2 -> !path2.isDirectory());
    }

    public static void markInternalOperation(@NotNull Iterable<? extends Change> changes, boolean set) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(61);
        }
        for (Change change : changes) {
            VirtualFile file2 = change.getVirtualFile();
            if (file2 == null) continue;
            ChangesUtil.markInternalOperation(file2, set);
        }
    }

    public static void markInternalOperation(@NotNull VirtualFile file2, boolean set) {
        if (file2 == null) {
            ChangesUtil.$$$reportNull$$$0(62);
        }
        file2.putUserData(INTERNAL_OPERATION_KEY, set);
    }

    public static boolean isInternalOperation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangesUtil.$$$reportNull$$$0(63);
        }
        return Boolean.TRUE.equals(file2.getUserData(INTERNAL_OPERATION_KEY));
    }

    @Nullable
    public static File findCommonAncestor(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(64);
        }
        File ancestor = null;
        for (Change change : changes) {
            File currentChangeAncestor = ChangesUtil.getCommonBeforeAfterAncestor(change);
            if (currentChangeAncestor == null) {
                return null;
            }
            if (ancestor == null) {
                ancestor = currentChangeAncestor;
                continue;
            }
            if ((ancestor = FileUtil.findAncestor(ancestor, currentChangeAncestor)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    private static File getCommonBeforeAfterAncestor(@NotNull Change change) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(65);
        }
        FilePath before = ChangesUtil.getBeforePath(change);
        FilePath after2 = ChangesUtil.getAfterPath(change);
        return before == null ? Objects.requireNonNull(after2).getIOFile() : (after2 == null ? before.getIOFile() : FileUtil.findAncestor(before.getIOFile(), after2.getIOFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesUtil";
                break;
            }
            case 4: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 49: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 30: 
            case 32: 
            case 50: 
            case 60: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 11: 
            case 35: 
            case 37: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: 
            case 16: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 48: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcsesForFiles";
                break;
            }
            case 19: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIoFilesFromChanges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsCaseSensitive";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromPaths";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterRevisionsFiles";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromChanges";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableArray";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "filePathsToFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 59: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBeforePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAffectedByChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVcsForChange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedVcses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedVcsesForFiles";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVcsForFile";
                break;
            }
            case 18: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIoFilesFromChanges";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPathsCaseSensitive";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFilesFromPaths";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAfterRevisionsFiles";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFilesFromChanges";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableArray";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListIfOnlyOne";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findValidParentAccurately";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getValidParentUnderReadAction";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRelativePath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isTextConflictingChange";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processItemsByVcs";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processChangesByVcs";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFilesByVcs";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processFilePathsByVcs";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "filePathsToFiles";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "hasFileChanges";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "markInternalOperation";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isInternalOperation";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findCommonAncestor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getCommonBeforeAfterAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 38: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface VcsSeparator<T> {
        @Nullable
        public AbstractVcs getVcsFor(@NotNull T var1);
    }

    @FunctionalInterface
    public static interface PerVcsProcessor<T> {
        public void process(@NotNull AbstractVcs var1, @NotNull List<T> var2);
    }
}

