/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentContentRevision
implements ByteBackedContentRevision {
    protected FilePath myFile;

    public CurrentContentRevision(FilePath file2) {
        this.myFile = file2;
    }

    @Override
    @Nullable
    public String getContent() {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Document doc = ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        if (doc == null) {
            return null;
        }
        return doc.getText();
    }

    @Override
    public byte @Nullable [] getContentAsBytes() throws VcsException {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        try {
            return vFile.contentsToByteArray();
        }
        catch (IOException e) {
            throw new VcsException(e);
        }
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile vFile = this.myFile.getVirtualFile();
        if (vFile == null || !vFile.isValid()) {
            return null;
        }
        return vFile;
    }

    @Override
    @NotNull
    public FilePath getFile() {
        FilePath filePath2 = this.myFile;
        if (filePath2 == null) {
            CurrentContentRevision.$$$reportNull$$$0(0);
        }
        return filePath2;
    }

    @Override
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
        if (vcsRevisionNumber == null) {
            CurrentContentRevision.$$$reportNull$$$0(1);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    public static ContentRevision create(@NotNull FilePath file2) {
        if (file2 == null) {
            CurrentContentRevision.$$$reportNull$$$0(2);
        }
        if (file2.getFileType().isBinary()) {
            return new CurrentBinaryContentRevision(file2);
        }
        return new CurrentContentRevision(file2);
    }

    @NonNls
    public String toString() {
        return "CurrentContentRevision:" + this.myFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/CurrentContentRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/CurrentContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

