/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class CheckinHandler {
    public static final CheckinHandler DUMMY = new CheckinHandler(){};

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        return null;
    }

    @ApiStatus.Experimental
    @Nullable
    public UnnamedConfigurable getBeforeCheckinSettings() {
        return ObjectUtils.tryCast(this.getBeforeCheckinConfigurationPanel(), UnnamedConfigurable.class);
    }

    @Nullable
    public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
        return null;
    }

    public ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer2) {
        return this.beforeCheckin();
    }

    public ReturnResult beforeCheckin() {
        return ReturnResult.COMMIT;
    }

    public void checkinSuccessful() {
    }

    public void checkinFailed(List<VcsException> exception) {
    }

    public void includedChangesChanged() {
    }

    public boolean acceptExecutor(CommitExecutor executor) {
        return !(executor instanceof LocalCommitExecutor);
    }

    public static enum ReturnResult {
        COMMIT,
        CANCEL,
        CLOSE_WINDOW;

    }
}

