/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.ContentAnnotationCache;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SLRUMap;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class ContentAnnotationCacheImpl
implements ContentAnnotationCache {
    private final SLRUMap<HistoryCacheWithRevisionKey, TreeMap<Integer, Long>> myCache;
    private final Object myLock = new Object();

    public ContentAnnotationCacheImpl() {
        this.myCache = new SLRUMap(50, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ThreeState isRecent(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, TextRange range2, long boundTime) {
        TreeMap<Integer, Long> treeMap;
        Object object = this.myLock;
        synchronized (object) {
            treeMap = this.myCache.get(new HistoryCacheWithRevisionKey(VcsContextFactory.SERVICE.getInstance().createFilePathOn(vf), vcsKey, number));
        }
        if (treeMap != null) {
            Map.Entry<Integer, Long> last = treeMap.floorEntry(range2.getEndOffset());
            if (last == null || last.getKey() < range2.getStartOffset()) {
                return ThreeState.NO;
            }
            Map.Entry<Integer, Long> first = treeMap.ceilingEntry(range2.getStartOffset());
            assert (first != null);
            SortedMap<Integer, Long> interval = treeMap.subMap(first.getKey(), last.getKey());
            for (Map.Entry<Integer, Long> entry : interval.entrySet()) {
                if (entry.getValue() < boundTime) continue;
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, FileAnnotation fa) {
        HistoryCacheWithRevisionKey key = new HistoryCacheWithRevisionKey(VcsContextFactory.SERVICE.getInstance().createFilePathOn(vf), vcsKey, number);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCache.get(key) != null) {
                return;
            }
        }
        long absoluteLimit = System.currentTimeMillis() - VcsContentAnnotationSettings.ourAbsoluteLimit;
        TreeMap<Integer, Long> map2 = new TreeMap<Integer, Long>();
        int lineCount = fa.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            Date lineDate = fa.getLineDate(i);
            if (lineDate == null) {
                return;
            }
            if (lineDate.getTime() < absoluteLimit) continue;
            map2.put(i, lineDate.getTime());
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myCache.put(key, map2);
        }
    }
}

