/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0015\u0010\u0007\u001a\u000f\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\t\u0018\u00010\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\f\u001a\u00020\u0004H\u0017J\u0016\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0017J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0015H\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "", "()V", "getCenterPanelTitle", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getColumnNames", "", "Lorg/jetbrains/annotations/Nls;", "getLeftPanelTitle", "getMergeWindowTitle", "getMultipleFileDialogTitle", "getMultipleFileMergeDescription", "files", "", "getRightPanelTitle", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getTitleCustomizerList", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "DiffEditorTitleCustomizerList", "intellij.platform.vcs"})
@ApiStatus.OverrideOnly
public class MergeDialogCustomizer {
    @NotNull
    private static final DiffEditorTitleCustomizerList DEFAULT_CUSTOMIZER_LIST;
    public static final Companion Companion;

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        return "";
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getMergeWindowTitle(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string = VcsBundle.message("multiple.file.merge.request.title", FileUtil.toSystemDependentName(file2.getPresentableUrl()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.message(\"multi\u2026ame(file.presentableUrl))");
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getLeftPanelTitle(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string = DiffBundle.message("merge.version.title.our", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DiffBundle.message(\"merge.version.title.our\")");
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getCenterPanelTitle(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string = DiffBundle.message("merge.version.title.base", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DiffBundle.message(\"merge.version.title.base\")");
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getRightPanelTitle(@NotNull VirtualFile file2, @Nullable VcsRevisionNumber revisionNumber) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (revisionNumber != null) {
            String string2 = DiffBundle.message("merge.version.title.their.with.revision", revisionNumber.asString());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DiffBundle.message(\"merg\u2026evisionNumber.asString())");
        } else {
            String string3 = DiffBundle.message("merge.version.title.their", new Object[0]);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DiffBundle.message(\"merge.version.title.their\")");
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getMultipleFileDialogTitle() {
        String string = VcsBundle.message("multiple.file.merge.title", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.message(\"multiple.file.merge.title\")");
        return string;
    }

    @Nullable
    public List<String> getColumnNames() {
        return null;
    }

    @ApiStatus.Experimental
    @NotNull
    public DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return DEFAULT_CUSTOMIZER_LIST;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_CUSTOMIZER_LIST = new DiffEditorTitleCustomizerList(null, null, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "", "leftTitleCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "centerTitleCustomizer", "rightTitleCustomizer", "(Lcom/intellij/diff/DiffEditorTitleCustomizer;Lcom/intellij/diff/DiffEditorTitleCustomizer;Lcom/intellij/diff/DiffEditorTitleCustomizer;)V", "getCenterTitleCustomizer", "()Lcom/intellij/diff/DiffEditorTitleCustomizer;", "getLeftTitleCustomizer", "getRightTitleCustomizer", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs"})
    public static final class DiffEditorTitleCustomizerList {
        @Nullable
        private final DiffEditorTitleCustomizer leftTitleCustomizer;
        @Nullable
        private final DiffEditorTitleCustomizer centerTitleCustomizer;
        @Nullable
        private final DiffEditorTitleCustomizer rightTitleCustomizer;

        @Nullable
        public final DiffEditorTitleCustomizer getLeftTitleCustomizer() {
            return this.leftTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer getCenterTitleCustomizer() {
            return this.centerTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer getRightTitleCustomizer() {
            return this.rightTitleCustomizer;
        }

        public DiffEditorTitleCustomizerList(@Nullable DiffEditorTitleCustomizer leftTitleCustomizer, @Nullable DiffEditorTitleCustomizer centerTitleCustomizer, @Nullable DiffEditorTitleCustomizer rightTitleCustomizer) {
            this.leftTitleCustomizer = leftTitleCustomizer;
            this.centerTitleCustomizer = centerTitleCustomizer;
            this.rightTitleCustomizer = rightTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer component1() {
            return this.leftTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer component2() {
            return this.centerTitleCustomizer;
        }

        @Nullable
        public final DiffEditorTitleCustomizer component3() {
            return this.rightTitleCustomizer;
        }

        @NotNull
        public final DiffEditorTitleCustomizerList copy(@Nullable DiffEditorTitleCustomizer leftTitleCustomizer, @Nullable DiffEditorTitleCustomizer centerTitleCustomizer, @Nullable DiffEditorTitleCustomizer rightTitleCustomizer) {
            return new DiffEditorTitleCustomizerList(leftTitleCustomizer, centerTitleCustomizer, rightTitleCustomizer);
        }

        public static /* synthetic */ DiffEditorTitleCustomizerList copy$default(DiffEditorTitleCustomizerList diffEditorTitleCustomizerList, DiffEditorTitleCustomizer diffEditorTitleCustomizer, DiffEditorTitleCustomizer diffEditorTitleCustomizer2, DiffEditorTitleCustomizer diffEditorTitleCustomizer3, int n, Object object) {
            if ((n & 1) != 0) {
                diffEditorTitleCustomizer = diffEditorTitleCustomizerList.leftTitleCustomizer;
            }
            if ((n & 2) != 0) {
                diffEditorTitleCustomizer2 = diffEditorTitleCustomizerList.centerTitleCustomizer;
            }
            if ((n & 4) != 0) {
                diffEditorTitleCustomizer3 = diffEditorTitleCustomizerList.rightTitleCustomizer;
            }
            return diffEditorTitleCustomizerList.copy(diffEditorTitleCustomizer, diffEditorTitleCustomizer2, diffEditorTitleCustomizer3);
        }

        @NotNull
        public String toString() {
            return "DiffEditorTitleCustomizerList(leftTitleCustomizer=" + this.leftTitleCustomizer + ", centerTitleCustomizer=" + this.centerTitleCustomizer + ", rightTitleCustomizer=" + this.rightTitleCustomizer + ")";
        }

        public int hashCode() {
            DiffEditorTitleCustomizer diffEditorTitleCustomizer = this.leftTitleCustomizer;
            DiffEditorTitleCustomizer diffEditorTitleCustomizer2 = this.centerTitleCustomizer;
            DiffEditorTitleCustomizer diffEditorTitleCustomizer3 = this.rightTitleCustomizer;
            return ((diffEditorTitleCustomizer != null ? diffEditorTitleCustomizer.hashCode() : 0) * 31 + (diffEditorTitleCustomizer2 != null ? diffEditorTitleCustomizer2.hashCode() : 0)) * 31 + (diffEditorTitleCustomizer3 != null ? diffEditorTitleCustomizer3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DiffEditorTitleCustomizerList)) break block3;
                    DiffEditorTitleCustomizerList diffEditorTitleCustomizerList = (DiffEditorTitleCustomizerList)object;
                    if (!Intrinsics.areEqual((Object)this.leftTitleCustomizer, (Object)diffEditorTitleCustomizerList.leftTitleCustomizer) || !Intrinsics.areEqual((Object)this.centerTitleCustomizer, (Object)diffEditorTitleCustomizerList.centerTitleCustomizer) || !Intrinsics.areEqual((Object)this.rightTitleCustomizer, (Object)diffEditorTitleCustomizerList.rightTitleCustomizer)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$Companion;", "", "()V", "DEFAULT_CUSTOMIZER_LIST", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "getDEFAULT_CUSTOMIZER_LIST", "()Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "intellij.platform.vcs"})
    public static final class Companion {
        @NotNull
        public final DiffEditorTitleCustomizerList getDEFAULT_CUSTOMIZER_LIST() {
            return DEFAULT_CUSTOMIZER_LIST;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

