/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdatedFilesReverseSide {
    private final UpdatedFiles myFiles;
    private final Map<String, FileGroup> myGroupHolder;
    private final Map<String, FileGroup> myFileIdx;
    private static final List<String> ourStoppingGroups = Arrays.asList("MERGED_WITH_CONFLICTS", "UNKNOWN", "SKIPPED");

    public UpdatedFilesReverseSide(UpdatedFiles files2) {
        this.myFiles = files2;
        this.myGroupHolder = new HashMap<String, FileGroup>();
        this.myFileIdx = new HashMap<String, FileGroup>();
    }

    public boolean isEmpty() {
        return this.myFileIdx.isEmpty();
    }

    public FileGroup getGroup(String id2) {
        return this.myGroupHolder.get(id2);
    }

    public void addFileToGroup(String groupId2, String file2, DuplicateLevel duplicateLevel, String vcsName) {
        FileGroup newGroup = this.myGroupHolder.get(groupId2);
        this.addFileToGroup(newGroup, file2, duplicateLevel, vcsName);
    }

    public void addFileToGroup(FileGroup group, String file2, DuplicateLevel duplicateLevel, String vcsName) {
        FileGroup oldGroup;
        if (duplicateLevel.searchPreviousContainment(group.getId()) && (oldGroup = this.myFileIdx.get(file2)) != null) {
            if (duplicateLevel.doesExistingWin(group.getId(), oldGroup.getId())) {
                return;
            }
            oldGroup.remove(file2);
        }
        group.add(file2, vcsName, null);
        this.myFileIdx.put(file2, group);
    }

    public UpdatedFiles getUpdatedFiles() {
        return this.myFiles;
    }

    public void rebuildFromUpdatedFiles() {
        this.myFileIdx.clear();
        this.myGroupHolder.clear();
        for (FileGroup group : this.myFiles.getTopLevelGroups()) {
            this.addGroupToIndexes(group);
        }
    }

    private void addGroupToIndexes(FileGroup fromGroup) {
        this.myGroupHolder.put(fromGroup.getId(), fromGroup);
        for (String file2 : fromGroup.getFiles()) {
            this.myFileIdx.put(file2, fromGroup);
        }
        for (FileGroup fromChild : fromGroup.getChildren()) {
            this.addGroupToIndexes(fromChild);
        }
    }

    private void copyGroup(Parent parent, FileGroup from, DuplicateLevel duplicateLevel) {
        FileGroup to = this.createOrGet(parent, from);
        for (FileGroup.UpdatedFile updatedFile : from.getUpdatedFiles()) {
            this.addFileToGroup(to, updatedFile.getPath(), duplicateLevel, updatedFile.getVcsName());
        }
        for (FileGroup fromChild : from.getChildren()) {
            this.copyGroup(new GroupParent(to), fromChild, duplicateLevel);
        }
    }

    private FileGroup createOrGet(Parent possibleParent, FileGroup fromGroup) {
        FileGroup ownGroup = this.myGroupHolder.get(fromGroup.getId());
        if (ownGroup == null) {
            ownGroup = new FileGroup(fromGroup.getUpdateName(), fromGroup.getStatusName(), fromGroup.getSupportsDeletion(), fromGroup.getId(), fromGroup.myCanBeAbsent);
            possibleParent.accept(ownGroup);
            this.myGroupHolder.put(fromGroup.getId(), ownGroup);
        }
        return ownGroup;
    }

    public static Set<String> getPathsFromUpdatedFiles(UpdatedFiles from) {
        UpdatedFilesReverseSide helper = new UpdatedFilesReverseSide(UpdatedFiles.create());
        helper.accumulateFiles(from, DuplicateLevel.DUPLICATE_ERRORS);
        return helper.myFileIdx.keySet();
    }

    public void accumulateFiles(UpdatedFiles from, DuplicateLevel duplicateLevel) {
        TopLevelParent topLevel = new TopLevelParent();
        for (FileGroup fromGroup : from.getTopLevelGroups()) {
            this.copyGroup(topLevel, fromGroup, duplicateLevel);
        }
    }

    public boolean containErrors() {
        return UpdatedFilesReverseSide.containErrors(this.myFiles);
    }

    public static boolean containErrors(UpdatedFiles files2) {
        for (String groupId2 : ourStoppingGroups) {
            FileGroup group = files2.getGroupById(groupId2);
            if (group == null || group.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFile(VirtualFile file2) {
        return this.myFileIdx.containsKey(file2.getPresentableUrl());
    }

    public static abstract class DuplicateLevel {
        private static final List<String> ourErrorGroups = Arrays.asList("UNKNOWN", "SKIPPED");
        private static final List<String> ourLocals = Arrays.asList("LOCALLY_ADDED", "LOCALLY_REMOVED");
        public static final DuplicateLevel NO_DUPLICATES = new DuplicateLevel(){

            @Override
            boolean searchPreviousContainment(String groupId2) {
                return true;
            }

            @Override
            boolean doesExistingWin(String groupId2, String existingGroupId) {
                return false;
            }
        };
        public static final DuplicateLevel DUPLICATE_ERRORS_LOCALS = new DuplicateLevel(){

            @Override
            boolean searchPreviousContainment(String groupId2) {
                return !ourLocals.contains(groupId2) && !ourErrorGroups.contains(groupId2);
            }

            @Override
            boolean doesExistingWin(String groupId2, String existingGroupId) {
                return ourLocals.contains(groupId2);
            }
        };
        public static final DuplicateLevel DUPLICATE_ERRORS = new DuplicateLevel(){

            @Override
            boolean searchPreviousContainment(String groupId2) {
                return !ourErrorGroups.contains(groupId2);
            }

            @Override
            boolean doesExistingWin(String groupId2, String existingGroupId) {
                return false;
            }
        };
        public static final DuplicateLevel ALLOW_DUPLICATES = new DuplicateLevel(){

            @Override
            boolean searchPreviousContainment(String groupId2) {
                return false;
            }

            @Override
            boolean doesExistingWin(String groupId2, String existingGroupId) {
                return false;
            }
        };

        abstract boolean searchPreviousContainment(String var1);

        abstract boolean doesExistingWin(String var1, String var2);

        private DuplicateLevel() {
        }
    }

    private static class GroupParent
    implements Parent {
        private final FileGroup myGroup;

        private GroupParent(FileGroup group) {
            this.myGroup = group;
        }

        @Override
        public void accept(FileGroup group) {
            this.myGroup.addChild(group);
        }
    }

    private class TopLevelParent
    implements Parent {
        private TopLevelParent() {
        }

        @Override
        public void accept(FileGroup group) {
            UpdatedFilesReverseSide.this.myFiles.getTopLevelGroups().add(group);
        }
    }

    private static interface Parent {
        public void accept(FileGroup var1);
    }
}

