/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Attribute;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@com.intellij.openapi.components.State(name="Encoding", storages={@Storage(value="encoding.xml")})
public class EncodingManagerImpl
extends EncodingManager
implements PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EncodingManagerImpl.class);
    private static final Equality<Reference<Document>> REFERENCE_EQUALITY = new Equality<Reference<Document>>(){

        @Override
        public boolean equals(Reference<Document> o1, Reference<Document> o2) {
            Object v1 = o1 == null ? REFERENCE_EQUALITY : o1.get();
            Object v2 = o2 == null ? REFERENCE_EQUALITY : o2.get();
            return v1 == v2;
        }
    };
    private State myState = new State();
    private static final Key<Charset> CACHED_CHARSET_FROM_CONTENT = Key.create("CACHED_CHARSET_FROM_CONTENT");
    private final ExecutorService changedDocumentExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor("EncodingManagerImpl Document Pool", PooledThreadExecutor.INSTANCE, JobSchedulerImpl.getJobPoolParallelism(), this);
    private final AtomicBoolean myDisposed = new AtomicBoolean();
    @NonNls
    public static final String PROP_CACHED_ENCODING_CHANGED = "cachedEncoding";
    private static final Key<AtomicInteger> RUNNING_REDETECTS_KEY = Key.create("DETECTING_ENCODING_KEY");

    public EncodingManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppLifecycleListener.TOPIC, new AppLifecycleListener(){

            @Override
            public void appClosing() {
                EncodingManagerImpl.this.myDisposed.set(true);
                EncodingManagerImpl.this.clearDocumentQueue();
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent e) {
                Document document;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (EncodingManagerImpl.isEditorOpenedFor(document = e.getDocument())) {
                    EncodingManagerImpl.this.queueUpdateEncodingFromContent(document);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$3", "documentChanged"));
            }
        }, this);
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            @Override
            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                EncodingManagerImpl.this.queueUpdateEncodingFromContent(event.getEditor().getDocument());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$4", "editorCreated"));
            }
        }, this);
    }

    private static boolean isEditorOpenedFor(@NotNull Document document) {
        VirtualFile virtualFile2;
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(0);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return false;
        }
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        return project2 != null && !project2.isDisposed() && FileEditorManager.getInstance(project2).isFileOpen(virtualFile2);
    }

    private void handleDocument(@NotNull Document document) {
        VirtualFile virtualFile2;
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(1);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return;
        }
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        while (project2 == null || !project2.isDisposed()) {
            Charset oldCached;
            int nRequests = EncodingManagerImpl.addNumberOfRequestedRedetects(document, 0);
            Charset charset = LoadTextUtil.charsetFromContentOrNull(project2, virtualFile2, document.getImmutableCharSequence());
            if (!Comparing.equal(charset, oldCached = this.getCachedCharsetFromContent(document))) {
                this.setCachedCharsetFromContent(charset, oldCached, document);
            }
            if (EncodingManagerImpl.addNumberOfRequestedRedetects(document, -nRequests) != 0) continue;
            break;
        }
    }

    private void setCachedCharsetFromContent(Charset charset, Charset oldCached, @NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(2);
        }
        document.putUserData(CACHED_CHARSET_FROM_CONTENT, charset);
        this.firePropertyChange(document, PROP_CACHED_ENCODING_CHANGED, oldCached, charset, null);
    }

    @Nullable(value="returns null if charset set cannot be determined from content")
    @Nullable(value="returns null if charset set cannot be determined from content") Charset computeCharsetFromContent(@NotNull VirtualFile virtualFile2) {
        Document document;
        if (virtualFile2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(3);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(virtualFile2)) == null) {
            return null;
        }
        Charset cached = EncodingManager.getInstance().getCachedCharsetFromContent(document);
        if (cached != null) {
            return cached;
        }
        Project project2 = ProjectLocator.getInstance().guessProjectForFile(virtualFile2);
        return ReadAction.compute(() -> {
            Charset charsetFromContent = LoadTextUtil.charsetFromContentOrNull(project2, virtualFile2, document.getImmutableCharSequence());
            if (charsetFromContent != null) {
                this.setCachedCharsetFromContent(charsetFromContent, null, document);
            }
            return charsetFromContent;
        });
    }

    @Override
    public void dispose() {
        this.myDisposed.set(true);
    }

    private static int addNumberOfRequestedRedetects(@NotNull Document document, int delta) {
        AtomicInteger oldData;
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(4);
        }
        if ((oldData = document.getUserData(RUNNING_REDETECTS_KEY)) == null) {
            oldData = ((UserDataHolderEx)((Object)document)).putUserDataIfAbsent(RUNNING_REDETECTS_KEY, new AtomicInteger());
        }
        return oldData.addAndGet(delta);
    }

    void queueUpdateEncodingFromContent(@NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myDisposed.get()) {
            return;
        }
        if (EncodingManagerImpl.addNumberOfRequestedRedetects(document, 1) == 1) {
            this.changedDocumentExecutor.execute(new DocumentEncodingDetectRequest(document, this.myDisposed));
        }
    }

    @Override
    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            EncodingManagerImpl.$$$reportNull$$$0(6);
        }
        return document.getUserData(CACHED_CHARSET_FROM_CONTENT);
    }

    @Override
    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            EncodingManagerImpl.$$$reportNull$$$0(7);
        }
        return state;
    }

    @Override
    public void loadState(@NotNull State state) {
        if (state == null) {
            EncodingManagerImpl.$$$reportNull$$$0(8);
        }
        this.myState = state;
    }

    @Override
    @NotNull
    public Collection<Charset> getFavorites() {
        Project[] projects;
        THashSet<Charset> result2 = new THashSet<Charset>();
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            result2.addAll(EncodingProjectManager.getInstance(project2).getFavorites());
        }
        result2.addAll(EncodingProjectManagerImpl.widelyKnownCharsets());
        THashSet<Charset> tHashSet = result2;
        if (tHashSet == null) {
            EncodingManagerImpl.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @Override
    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile2, boolean useParentDefaults) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return null;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance(project2);
        if (encodingManager == null) {
            return null;
        }
        return encodingManager.getEncoding(virtualFile2, useParentDefaults);
    }

    public void clearDocumentQueue() {
        if (((BoundedTaskExecutor)this.changedDocumentExecutor).isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call clearDocumentQueue() from under write action because some queued detectors require read action");
        }
        ((BoundedTaskExecutor)this.changedDocumentExecutor).clearAndCancelAll();
        this.waitAllTasksExecuted(1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - void declaration
     */
    void waitAllTasksExecuted(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            EncodingManagerImpl.$$$reportNull$$$0(10);
        }
        try {
            void unit;
            ((BoundedTaskExecutor)this.changedDocumentExecutor).waitAllTasksExecuted(timeout, (TimeUnit)unit);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Nullable
    private static Project guessProject(@Nullable VirtualFile virtualFile2) {
        return ProjectLocator.getInstance().guessProjectForFile(virtualFile2);
    }

    @Override
    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFileOrDir);
        if (project2 != null) {
            EncodingProjectManager.getInstance(project2).setEncoding(virtualFileOrDir, charset);
        }
    }

    @Override
    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile2) {
        Project project2;
        if (virtualFile2 == null) {
            EncodingManagerImpl.$$$reportNull$$$0(11);
        }
        return (project2 = EncodingManagerImpl.guessProject(virtualFile2)) != null && EncodingProjectManager.getInstance(project2).isNative2Ascii(virtualFile2);
    }

    @Override
    public boolean isNative2AsciiForPropertiesFiles() {
        Project project2 = EncodingManagerImpl.guessProject(null);
        return project2 != null && EncodingProjectManager.getInstance(project2).isNative2AsciiForPropertiesFiles();
    }

    @Override
    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile2, boolean native2Ascii) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return;
        }
        EncodingProjectManager.getInstance(project2).setNative2AsciiForPropertiesFiles(virtualFile2, native2Ascii);
    }

    @Override
    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myState.myDefaultEncoding == ChooseFileEncodingAction.NO_ENCODING ? CharsetToolkit.getDefaultSystemCharset() : this.myState.myDefaultEncoding;
        if (charset == null) {
            EncodingManagerImpl.$$$reportNull$$$0(12);
        }
        return charset;
    }

    @Override
    @NotNull
    public String getDefaultCharsetName() {
        String string = this.myState.getDefaultCharsetName();
        if (string == null) {
            EncodingManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public void setDefaultCharsetName(@NotNull String name) {
        if (name == null) {
            EncodingManagerImpl.$$$reportNull$$$0(14);
        }
        this.myState.setDefaultCharsetName(name);
    }

    @Override
    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return null;
        }
        return EncodingProjectManager.getInstance(project2).getDefaultCharsetForPropertiesFiles(virtualFile2);
    }

    @Override
    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2, Charset charset) {
        Project project2 = EncodingManagerImpl.guessProject(virtualFile2);
        if (project2 == null) {
            return;
        }
        EncodingProjectManager.getInstance(project2).setDefaultCharsetForPropertiesFiles(virtualFile2, charset);
    }

    void firePropertyChange(@Nullable Document document, @NotNull String propertyName, Object oldValue, Object newValue, @Nullable Project project2) {
        if (propertyName == null) {
            EncodingManagerImpl.$$$reportNull$$$0(15);
        }
        MessageBus messageBus = (project2 != null ? project2 : ApplicationManager.getApplication()).getMessageBus();
        EncodingManagerListener publisher = messageBus.syncPublisher(EncodingManagerListener.ENCODING_MANAGER_CHANGES);
        publisher.propertyChanged(document, propertyName, oldValue, newValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavorites";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEditorOpenedFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCachedCharsetFromContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeCharsetFromContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNumberOfRequestedRedetects";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateEncodingFromContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetFromContent";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitAllTasksExecuted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNative2Ascii";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCharsetName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "firePropertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DocumentEncodingDetectRequest
    implements Runnable {
        private final Reference<Document> ref;
        @NotNull
        private final AtomicBoolean myDisposed;

        private DocumentEncodingDetectRequest(@NotNull Document document, @NotNull AtomicBoolean disposed) {
            if (document == null) {
                DocumentEncodingDetectRequest.$$$reportNull$$$0(0);
            }
            if (disposed == null) {
                DocumentEncodingDetectRequest.$$$reportNull$$$0(1);
            }
            this.ref = new WeakReference<Document>(document);
            this.myDisposed = disposed;
        }

        @Override
        public void run() {
            if (this.myDisposed.get()) {
                return;
            }
            Document document = this.ref.get();
            if (document == null) {
                return;
            }
            ((EncodingManagerImpl)EncodingManager.getInstance()).handleDocument(document);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposed";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$DocumentEncodingDetectRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class State {
        @NotNull
        private Charset myDefaultEncoding = StandardCharsets.UTF_8;

        State() {
        }

        @Attribute(value="default_encoding")
        @NotNull
        public String getDefaultCharsetName() {
            String string = this.myDefaultEncoding == ChooseFileEncodingAction.NO_ENCODING ? "" : this.myDefaultEncoding.name();
            if (string == null) {
                State.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setDefaultCharsetName(@NotNull String name) {
            if (name == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myDefaultEncoding = name.isEmpty() ? ChooseFileEncodingAction.NO_ENCODING : ObjectUtils.notNull(CharsetToolkit.forName(name), CharsetToolkit.getDefaultSystemCharset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultCharsetName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingManagerImpl$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultCharsetName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

